/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks;

import de.dafuqs.spectrum.registries.SpectrumFluids;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2402;
import net.minecraft.class_2680;
import net.minecraft.class_2754;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class FluidLogging {
    public static final class_2754<State> ANY_INCLUDING_NONE = class_2754.method_11850((String)"fluid_logged", State.class);
    public static final class_2754<State> ANY_EXCLUDING_NONE = class_2754.method_11849((String)"fluid_logged", State.class, (Enum[])new State[]{State.WATER, State.LIQUID_CRYSTAL});
    public static final class_2754<State> NONE_AND_CRYSTAL = class_2754.method_11849((String)"fluid_logged", State.class, (Enum[])new State[]{State.NOT_LOGGED, State.LIQUID_CRYSTAL});

    public static enum State implements class_3542
    {
        NOT_LOGGED("none", 0),
        WATER("water", 0),
        LIQUID_CRYSTAL("liquid_crystal", 11);

        private final String name;
        private final int luminance;

        private State(String name, int luminance) {
            this.name = name;
            this.luminance = luminance;
        }

        public String method_15434() {
            return this.name;
        }

        public class_3610 getFluidState() {
            switch (this.ordinal()) {
                case 2: {
                    return SpectrumFluids.LIQUID_CRYSTAL.method_15729(false);
                }
                case 1: {
                    return class_3612.field_15910.method_15729(false);
                }
            }
            return class_3612.field_15906.method_15785();
        }

        public static State getForFluidState(class_3610 fluidState) {
            if (fluidState.method_15772() == SpectrumFluids.LIQUID_CRYSTAL) {
                return LIQUID_CRYSTAL;
            }
            if (fluidState.method_15767(class_3486.field_15517)) {
                return WATER;
            }
            return NOT_LOGGED;
        }

        public int getLuminance() {
            return this.luminance;
        }

        public boolean isOf(class_3611 fluid) {
            return this.getFluidState().method_39360(fluid);
        }

        public boolean isIn(class_6862<class_3611> fluidTag) {
            return this.getFluidState().method_15767(fluidTag);
        }

        public String toString() {
            return this.name;
        }

        public void onEntityCollision(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
            if (this == LIQUID_CRYSTAL) {
                SpectrumFluids.LIQUID_CRYSTAL.onEntityCollision(state, world, pos, entity);
            }
        }
    }

    public static interface SpectrumFluidDrainable
    extends class_2263 {
        default public class_1799 method_9700(@Nullable class_1657 player, class_1936 world, class_2338 pos, class_2680 state) {
            State fluidLog = (State)((Object)state.method_11654(ANY_INCLUDING_NONE));
            if (fluidLog == State.WATER) {
                world.method_8652(pos, (class_2680)state.method_11657(ANY_INCLUDING_NONE, (Comparable)((Object)State.NOT_LOGGED)), 3);
                if (!state.method_26184((class_4538)world, pos)) {
                    world.method_22352(pos, true);
                }
                return new class_1799((class_1935)class_1802.field_8705);
            }
            if (fluidLog == State.LIQUID_CRYSTAL) {
                world.method_8652(pos, (class_2680)state.method_11657(ANY_INCLUDING_NONE, (Comparable)((Object)State.NOT_LOGGED)), 3);
                if (!state.method_26184((class_4538)world, pos)) {
                    world.method_22352(pos, true);
                }
                return new class_1799((class_1935)SpectrumItems.LIQUID_CRYSTAL_BUCKET);
            }
            return class_1799.field_8037;
        }

        default public Optional<class_3414> method_32351() {
            return class_3612.field_15910.method_32359();
        }
    }

    public static interface SpectrumFluidFillable
    extends class_2402 {
        default public boolean method_10310(@Nullable class_1657 player, class_1922 world, class_2338 pos, class_2680 state, class_3611 fluid) {
            return state.method_11654(ANY_INCLUDING_NONE) == State.NOT_LOGGED && (fluid == class_3612.field_15910 || fluid == SpectrumFluids.LIQUID_CRYSTAL);
        }

        default public boolean method_10311(class_1936 world, class_2338 pos, class_2680 state, class_3610 fluidState) {
            if (state.method_11654(ANY_INCLUDING_NONE) == State.NOT_LOGGED) {
                if (!world.method_8608()) {
                    if (fluidState.method_15772() == class_3612.field_15910) {
                        world.method_8652(pos, (class_2680)state.method_11657(ANY_INCLUDING_NONE, (Comparable)((Object)State.WATER)), 3);
                        world.method_39281(pos, fluidState.method_15772(), fluidState.method_15772().method_15789((class_4538)world));
                    } else if (fluidState.method_15772() == SpectrumFluids.LIQUID_CRYSTAL) {
                        world.method_8652(pos, (class_2680)state.method_11657(ANY_INCLUDING_NONE, (Comparable)((Object)State.LIQUID_CRYSTAL)), 3);
                        world.method_39281(pos, fluidState.method_15772(), fluidState.method_15772().method_15789((class_4538)world));
                    }
                }
                return true;
            }
            return false;
        }
    }

    public static interface SpectrumFluidLoggable
    extends SpectrumFluidDrainable,
    SpectrumFluidFillable {
    }
}

