/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import de.dafuqs.spectrum.cca.OnPrimordialFireComponent;
import de.dafuqs.spectrum.compat.claims.GenericClaimModsCompat;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.recipe.primordial_fire_burning.PrimordialFireBurningRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_2429;
import net.minecraft.class_2530;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3922;
import net.minecraft.class_4538;
import net.minecraft.class_4770;
import net.minecraft.class_4970;
import net.minecraft.class_5544;
import net.minecraft.class_5545;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;

public class PrimordialFireBlock
extends class_4770 {
    public static final MapCodec<PrimordialFireBlock> CODEC = PrimordialFireBlock.method_54094(PrimordialFireBlock::new);
    public static boolean EXPLOSION_CAUSES_PRIMORDIAL_FIRE_FLAG = false;
    public static final class_2746 NORTH = class_2429.field_11332;
    public static final class_2746 EAST = class_2429.field_11335;
    public static final class_2746 SOUTH = class_2429.field_11331;
    public static final class_2746 WEST = class_2429.field_11328;
    public static final class_2746 UP = class_2429.field_11327;
    private static final Map<class_2350, class_2746> DIRECTION_PROPERTIES = (Map)class_2429.field_11329.entrySet().stream().filter(entry -> entry.getKey() != class_2350.field_11033).collect(class_156.method_664());
    private static final class_265 UP_SHAPE = class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 WEST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final class_265 EAST_SHAPE = class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 NORTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final class_265 SOUTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<class_2680, class_265> shapesByState;
    private static final float DAMAGE = 0.2f;

    public PrimordialFireBlock(class_4970.class_2251 settings) {
        super(settings, 0.2f);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false)));
        this.shapesByState = ImmutableMap.copyOf(this.field_10647.method_11662().stream().collect(Collectors.toMap(Function.identity(), PrimordialFireBlock::getShapeForState)));
    }

    public MapCodec<? extends PrimordialFireBlock> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{NORTH, EAST, SOUTH, WEST, UP});
    }

    public static class_265 getShapeForState(class_2680 state) {
        class_265 voxelShape = class_259.method_1073();
        if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
            voxelShape = UP_SHAPE;
        }
        if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)NORTH_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)SOUTH_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)EAST_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)WEST_SHAPE);
        }
        return voxelShape.method_1110() ? field_22498 : voxelShape;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return this.method_9558(state, (class_4538)world, pos) ? this.getStateForPosition((class_1922)world, pos) : class_2246.field_10124.method_9564();
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapesByState.get(state);
    }

    public class_2680 method_9605(class_1750 ctx) {
        return this.getStateForPosition((class_1922)ctx.method_8045(), ctx.method_8037());
    }

    public class_2680 getStateForPosition(class_1922 world, class_2338 pos) {
        class_2338 blockPos = pos.method_10074();
        class_2680 blockState = world.method_8320(blockPos);
        if (!this.method_10195(blockState) && !blockState.method_26206(world, blockPos, class_2350.field_11036)) {
            class_2680 blockState2 = this.method_9564();
            for (class_2350 direction : class_2350.values()) {
                class_2746 booleanProperty = DIRECTION_PROPERTIES.get(direction);
                if (booleanProperty == null) continue;
                blockState2 = (class_2680)blockState2.method_11657((class_2769)booleanProperty, (Comparable)Boolean.valueOf(this.method_10195(world.method_8320(pos.method_10093(direction)))));
            }
            return blockState2;
        }
        return this.method_9564();
    }

    public static boolean tryPlacePrimordialFire(class_1937 world, class_2338 pos, class_2350 direction) {
        class_2680 state = world.method_8320(pos);
        if (PrimordialFireBlock.method_30032((class_1937)world, (class_2338)pos, (class_2350)direction)) {
            if (world.method_8501(pos, SpectrumBlocks.PRIMORDIAL_FIRE.getStateForPosition((class_1922)world, pos))) {
                world.method_33596(null, (class_6880)class_5712.field_28164, pos);
                return true;
            }
        } else {
            if (!(class_3922.method_30035((class_2680)state) || class_5544.method_31630((class_2680)state) || class_5545.method_31635((class_2680)state))) {
                if (state.method_26204() instanceof class_2530) {
                    class_2530.method_10738((class_1937)world, (class_2338)pos);
                    world.method_8650(pos, false);
                    return true;
                }
                return false;
            }
            if (world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)))) {
                world.method_33596(null, (class_6880)class_5712.field_28733, pos);
                return true;
            }
        }
        return false;
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            entity.method_5643(SpectrumDamageTypes.primordialFire(world, null), 0.2f);
            OnPrimordialFireComponent.addPrimordialFireTicks(livingEntity, 5);
        }
        if (world.method_8510() % 20L == 0L && entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            PrimordialFireBurningRecipe.processItemEntity(world, itemEntity);
        }
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 blockPos = pos.method_10074();
        return world.method_8320(blockPos).method_26206((class_1922)world, blockPos, class_2350.field_11036) || this.areBlocksAroundFlammable((class_1922)world, pos);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        world.method_39279(pos, (class_2248)this, PrimordialFireBlock.getFireTickDelay(world.field_9229));
        if (world.method_8450().method_8355(class_1928.field_19387)) {
            class_2680 blockState;
            boolean isAboveInfiniburnBlock;
            if (!state.method_26184((class_4538)world, pos)) {
                world.method_8650(pos, false);
            }
            boolean bl = isAboveInfiniburnBlock = (blockState = world.method_8320(pos.method_10074())).method_26164(world.method_8597().comp_654()) || blockState.method_26164(SpectrumBlockTags.PRIMORDIAL_FIRE_BASE_BLOCKS);
            if (!isAboveInfiniburnBlock && random.method_43057() < 0.01f) {
                world.method_8650(pos, false);
            } else {
                if (!isAboveInfiniburnBlock && !this.areBlocksAroundFlammable((class_1922)world, pos)) {
                    class_2338 blockPos = pos.method_10074();
                    if (!world.method_8320(blockPos).method_26206((class_1922)world, blockPos, class_2350.field_11036)) {
                        world.method_8650(pos, false);
                    }
                    if (random.method_43048(10) == 0 && !this.method_10195(world.method_8320(pos.method_10074()))) {
                        world.method_8650(pos, false);
                        return;
                    }
                    return;
                }
                boolean biomeHasIncreasedFireBurnout = world.method_23753(pos).method_40220(class_6908.field_41752);
                int spreadReduction = biomeHasIncreasedFireBurnout ? -50 : 0;
                this.trySpreadingFire((class_1937)world, pos.method_10078(), 300 + spreadReduction, random);
                this.trySpreadingFire((class_1937)world, pos.method_10067(), 300 + spreadReduction, random);
                this.trySpreadingFire((class_1937)world, pos.method_10074(), 250 + spreadReduction, random);
                this.trySpreadingFire((class_1937)world, pos.method_10084(), 250 + spreadReduction, random);
                this.trySpreadingFire((class_1937)world, pos.method_10095(), 300 + spreadReduction, random);
                this.trySpreadingFire((class_1937)world, pos.method_10072(), 300 + spreadReduction, random);
                class_2338.class_2339 mutable = new class_2338.class_2339();
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        for (int y = -1; y <= 4; ++y) {
                            int q;
                            if (x == 0 && y == 0 && z == 0) continue;
                            int o = 100;
                            if (y > 1) {
                                o += (y - 1) * 100;
                            }
                            mutable.method_25504((class_2382)pos, x, y, z);
                            int burnChance = this.getBurnChance((class_4538)world, (class_2338)mutable);
                            if (burnChance <= 0 || (q = (burnChance + 40 + world.method_8407().method_5461() * 7) / 30) <= 0 || random.method_43048(o) > q) continue;
                            world.method_8652((class_2338)mutable, this.getStateForPosition((class_1922)world, (class_2338)mutable), 3);
                        }
                    }
                }
            }
        }
    }

    private int getSpreadChance(class_2680 state) {
        return state.method_28498((class_2769)class_2741.field_12508) && (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false ? 0 : ((FlammableBlockRegistry.Entry)FlammableBlockRegistry.getDefaultInstance().get(state.method_26204())).getSpreadChance();
    }

    private int getBurnChance(class_2680 state) {
        return state.method_28498((class_2769)class_2741.field_12508) && (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false ? 0 : ((FlammableBlockRegistry.Entry)FlammableBlockRegistry.getDefaultInstance().get(state.method_26204())).getBurnChance();
    }

    private void trySpreadingFire(class_1937 world, class_2338 pos, int spreadFactor, class_5819 random) {
        if (!GenericClaimModsCompat.canBreak(world, pos, null)) {
            return;
        }
        int spreadChance = this.getSpreadChance(world.method_8320(pos));
        if (random.method_43048(spreadFactor) < spreadChance) {
            class_2680 currentState = world.method_8320(pos);
            if (random.method_43056()) {
                if (PrimordialFireBurningRecipe.processBlock(world, pos, currentState)) {
                    return;
                }
                world.method_8652(pos, this.getStateForPosition((class_1922)world, pos), 3);
            }
            if (currentState.method_26204() instanceof class_2530) {
                class_2530.method_10738((class_1937)world, (class_2338)pos);
            }
        }
    }

    private boolean areBlocksAroundFlammable(class_1922 world, class_2338 pos) {
        for (class_2350 direction : class_2350.values()) {
            if (!this.method_10195(world.method_8320(pos.method_10093(direction)))) continue;
            return true;
        }
        return false;
    }

    private int getBurnChance(class_4538 world, class_2338 pos) {
        if (!world.method_22347(pos)) {
            return 0;
        }
        int i = 0;
        for (class_2350 direction : class_2350.values()) {
            class_2680 blockState = world.method_8320(pos.method_10093(direction));
            i = Math.max(this.getBurnChance(blockState), i);
        }
        return i;
    }

    protected boolean method_10195(class_2680 state) {
        return this.getBurnChance(state) > 0;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        world.method_39279(pos, (class_2248)this, PrimordialFireBlock.getFireTickDelay(world.field_9229));
    }

    private static int getFireTickDelay(class_5819 random) {
        return 20 + random.method_43048(10);
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        block14: {
            double f;
            double e;
            double d;
            int i;
            block13: {
                class_2338 blockPos;
                class_2680 blockState;
                if (random.method_43048(24) == 0) {
                    world.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, SpectrumSoundEvents.PRIMORDIAL_FIRE_CRACKLE, class_3419.field_15245, 0.175f + random.method_43057(), random.method_43057() * 0.7f + 0.3f, false);
                }
                if ((blockState = world.method_8320(blockPos = pos.method_10074())).method_26206((class_1922)world, blockPos, class_2350.field_11036)) {
                    class_2400 particle = this.method_10195(blockState) ? SpectrumParticleTypes.PRIMORDIAL_SIGNAL_SMOKE : SpectrumParticleTypes.PRIMORDIAL_COSY_SMOKE;
                    for (i = 0; i < 2; ++i) {
                        d = (double)pos.method_10263() + 0.5 + random.method_43058() / 4.0 * (double)(random.method_43056() ? 1 : -1);
                        e = (double)pos.method_10264() + 0.15;
                        f = (double)pos.method_10260() + 0.5 + random.method_43058() / 4.0 * (double)(random.method_43056() ? 1 : -1);
                        world.method_8406((class_2394)particle, d, e, f, 0.0015, 0.07, 0.0015);
                    }
                }
                if (this.method_10195(blockState) || blockState.method_26206((class_1922)world, blockPos, class_2350.field_11036)) break block13;
                if (this.method_10195(world.method_8320(pos.method_10067()))) {
                    for (i = 0; i < 2; ++i) {
                        d = (double)pos.method_10263() + random.method_43058() * (double)0.1f;
                        e = (double)pos.method_10264() + random.method_43058();
                        f = (double)pos.method_10260() + random.method_43058();
                        world.method_8406((class_2394)SpectrumParticleTypes.PRIMORDIAL_SMOKE, d, e, f, 0.0, 0.0, 0.0);
                    }
                }
                if (this.method_10195(world.method_8320(pos.method_10078()))) {
                    for (i = 0; i < 2; ++i) {
                        d = (double)(pos.method_10263() + 1) - random.method_43058() * (double)0.1f;
                        e = (double)pos.method_10264() + random.method_43058();
                        f = (double)pos.method_10260() + random.method_43058();
                        world.method_8406((class_2394)SpectrumParticleTypes.PRIMORDIAL_SMOKE, d, e, f, 0.0, 0.0, 0.0);
                    }
                }
                if (this.method_10195(world.method_8320(pos.method_10095()))) {
                    for (i = 0; i < 2; ++i) {
                        d = (double)pos.method_10263() + random.method_43058();
                        e = (double)pos.method_10264() + random.method_43058();
                        f = (double)pos.method_10260() + random.method_43058() * (double)0.1f;
                        world.method_8406((class_2394)SpectrumParticleTypes.PRIMORDIAL_SMOKE, d, e, f, 0.0, 0.0, 0.0);
                    }
                }
                if (this.method_10195(world.method_8320(pos.method_10072()))) {
                    for (i = 0; i < 2; ++i) {
                        d = (double)pos.method_10263() + random.method_43058();
                        e = (double)pos.method_10264() + random.method_43058();
                        f = (double)(pos.method_10260() + 1) - random.method_43058() * (double)0.1f;
                        world.method_8406((class_2394)SpectrumParticleTypes.PRIMORDIAL_SMOKE, d, e, f, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.method_10195(world.method_8320(pos.method_10084()))) break block14;
                for (i = 0; i < 2; ++i) {
                    d = (double)pos.method_10263() + random.method_43058();
                    e = (double)(pos.method_10264() + 1) - random.method_43058() * (double)0.1f;
                    f = (double)pos.method_10260() + random.method_43058();
                    world.method_8406((class_2394)SpectrumParticleTypes.PRIMORDIAL_SMOKE, d, e, f, 0.0, 0.0, 0.0);
                }
                break block14;
            }
            for (i = 0; i < 3; ++i) {
                d = (double)pos.method_10263() + random.method_43058();
                e = (double)pos.method_10264() + random.method_43058() * 0.5 + 0.5;
                f = (double)pos.method_10260() + random.method_43058();
                world.method_8406((class_2394)SpectrumParticleTypes.PRIMORDIAL_SMOKE, d, e, f, 0.0, 0.0, 0.0);
            }
        }
    }
}

