/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TallCropBlock
extends class_2302 {
    public static final MapCodec<TallCropBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TallCropBlock.method_54096(), (App)Codec.INT.fieldOf("last_single_block_age").forGetter(TallCropBlock::getLastSingleBlockAge)).apply((Applicative)instance, TallCropBlock::new));
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    public final int lastSingleBlockAge;

    public TallCropBlock(class_4970.class_2251 settings, int lastSingleBlockAge) {
        super(settings);
        this.lastSingleBlockAge = lastSingleBlockAge;
    }

    public MapCodec<? extends TallCropBlock> method_53969() {
        return CODEC;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.tryGrow(state, world, pos, random, 25.0f);
    }

    public void method_9826(class_1937 world, class_2338 pos, class_2680 state) {
        int maxAge;
        if (state.method_11654(HALF) == class_2756.field_12609) {
            pos = pos.method_10074();
            state = world.method_8320(pos);
        }
        if (!state.method_27852((class_2248)this)) {
            return;
        }
        int newAge = this.method_9829(state) + this.method_9831(world);
        if (newAge > (maxAge = this.method_9827())) {
            newAge = maxAge;
        }
        if (newAge > this.lastSingleBlockAge && this.canGrowUp(world, pos, state, newAge)) {
            world.method_8652(pos, this.method_9828(newAge), 2);
            world.method_8652(pos.method_10084(), this.withAgeAndHalf(newAge, class_2756.field_12609), 2);
        } else {
            world.method_8652(pos, this.method_9828(Math.min(newAge, this.lastSingleBlockAge)), 2);
        }
    }

    private boolean canGrowUp(class_1937 world, class_2338 pos, class_2680 state, int age) {
        return world.method_8320(pos.method_10084()).method_27852((class_2248)this) || world.method_8320(pos.method_10084()).method_45474();
    }

    protected void tryGrow(class_2680 state, class_3218 world, class_2338 pos, class_5819 random, float upperBound) {
        float moisture;
        int age;
        if (state.method_11654(HALF) == class_2756.field_12609) {
            return;
        }
        if (world.method_22335(pos, 0) >= 9 && (age = this.method_9829(state)) < this.method_9827() && random.method_43048((int)(upperBound / (moisture = TallCropBlock.method_9830((class_2248)this, (class_1922)world, (class_2338)pos))) + 1) == 0) {
            if (age >= 2) {
                if (world.method_8320(pos.method_10084()).method_27852((class_2248)this) || world.method_8320(pos.method_10084()).method_45474()) {
                    world.method_8652(pos, this.method_9828(age + 1), 2);
                    world.method_8652(pos.method_10084(), this.withAgeAndHalf(age + 1, class_2756.field_12609), 2);
                }
            } else {
                world.method_8652(pos, this.method_9828(age + 1), 2);
            }
        }
    }

    @NotNull
    public class_2680 method_9828(int age) {
        return this.withAgeAndHalf(age, class_2756.field_12607);
    }

    public class_2680 withAgeAndHalf(int age, class_2756 half) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)this.method_9824(), (Comparable)Integer.valueOf(age))).method_11657(HALF, (Comparable)half);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{HALF}).method_11667(new class_2769[]{field_10835});
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        if (state.method_11654(HALF) != class_2756.field_12609) {
            class_2338 blockPos = pos.method_10074();
            return this.method_9695(world.method_8320(blockPos), (class_1922)world, blockPos);
        }
        class_2680 blockState = world.method_8320(pos.method_10074());
        return blockState.method_27852((class_2248)this) && blockState.method_11654(HALF) == class_2756.field_12607 && (Integer)blockState.method_11654((class_2769)field_10835) > this.lastSingleBlockAge;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (state.method_11654(HALF) == class_2756.field_12607) {
            if ((Integer)state.method_11654((class_2769)field_10835) <= this.lastSingleBlockAge) {
                return super.method_9530(state, world, pos, context);
            }
            return class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }
        return super.method_9530(this.method_9828((Integer)state.method_11654((class_2769)field_10835) - this.lastSingleBlockAge - 1), world, pos, context);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        class_2756 doubleBlockHalf = (class_2756)state.method_11654(HALF);
        if (direction.method_10166() == class_2350.class_2351.field_11052 && doubleBlockHalf == class_2756.field_12607 == (direction == class_2350.field_11036)) {
            return (Integer)state.method_11654((class_2769)field_10835) <= this.lastSingleBlockAge || neighborState.method_27852((class_2248)this) && neighborState.method_11654(HALF) != doubleBlockHalf ? state : class_2246.field_10124.method_9564();
        }
        return doubleBlockHalf == class_2756.field_12607 && direction == class_2350.field_11033 && !state.method_26184((class_4538)world, pos) ? class_2246.field_10124.method_9564() : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2338 blockPos = ctx.method_8037();
        class_1937 world = ctx.method_8045();
        return blockPos.method_10264() < world.method_31600() - 1 && world.method_8320(blockPos.method_10084()).method_26166(ctx) ? this.withAgeAndHalf(0, class_2756.field_12607) : null;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (state.method_11654(HALF) == class_2756.field_12609) {
            world.method_8652(pos.method_10074(), this.withAgeAndHalf((Integer)state.method_11654((class_2769)field_10835), class_2756.field_12607), 3);
        } else if ((Integer)state.method_11654((class_2769)field_10835) > this.lastSingleBlockAge) {
            world.method_8652(pos.method_10084(), this.withAgeAndHalf((Integer)state.method_11654((class_2769)field_10835), class_2756.field_12609), 3);
        }
    }

    protected static void breakTheOtherHalf(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!player.method_7337()) {
            TallCropBlock.method_9511((class_2680)state, (class_1937)world, (class_2338)pos, null, (class_1297)player, (class_1799)player.method_6047());
        }
        if (state.method_11654(HALF) == class_2756.field_12609) {
            class_2338 downPos = pos.method_10074();
            class_2680 blockState = world.method_8320(downPos);
            if (blockState.method_27852(state.method_26204()) && blockState.method_11654(HALF) == class_2756.field_12607) {
                TallCropBlock.breakTheOtherHalf(world, downPos, state, player, downPos, blockState);
            }
        } else {
            class_2338 upPos = pos.method_10084();
            class_2680 blockState = world.method_8320(upPos);
            if (blockState.method_27852(state.method_26204()) && blockState.method_11654(HALF) == class_2756.field_12609) {
                TallCropBlock.breakTheOtherHalf(world, pos, state, player, upPos, blockState);
            }
        }
    }

    private static void breakTheOtherHalf(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, class_2338 upPos, class_2680 blockState) {
        class_2680 blockState2 = blockState.method_28498((class_2769)class_2741.field_12508) && (Boolean)blockState.method_11654((class_2769)class_2741.field_12508) != false ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564();
        world.method_8652(upPos, blockState2, 35);
        world.method_8444(player, 2001, upPos, class_2248.method_9507((class_2680)blockState));
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.field_9236) {
            TallCropBlock.breakTheOtherHalf(world, pos, state, player);
        }
        return super.method_9576(world, pos, state, player);
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 stack) {
        super.method_9556(world, player, pos, class_2246.field_10124.method_9564(), blockEntity, stack);
    }

    public int getLastSingleBlockAge() {
        return this.lastSingleBlockAge;
    }
}

