/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.bottomless_bundle;

import com.mojang.serialization.MapCodec;
import de.dafuqs.spectrum.blocks.bottomless_bundle.BottomlessBundleBlockEntity;
import de.dafuqs.spectrum.blocks.bottomless_bundle.BottomlessBundleItem;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7718;
import net.minecraft.class_8567;
import net.minecraft.class_9062;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class BottomlessBundleBlock
extends class_2237 {
    public static final MapCodec<BottomlessBundleBlock> CODEC = BottomlessBundleBlock.method_54094(BottomlessBundleBlock::new);
    public static final class_2758 ROTATION = class_2741.field_12532;
    public static final class_2746 LOCKED = class_2741.field_12502;
    public static final int MAX_ROTATIONS = class_7718.method_45478() + 1;
    protected static final class_265 SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);

    public BottomlessBundleBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BottomlessBundleBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    public boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    public class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.field_9236) {
            if (player.method_5715()) {
                world.method_35230(pos, SpectrumBlockEntities.BOTTOMLESS_BUNDLE).ifPresent(bottomlessBundleBlockEntity -> {
                    long amount = bottomlessBundleBlockEntity.storage.amount;
                    ItemVariant variant = (ItemVariant)bottomlessBundleBlockEntity.storage.getResource();
                    long maxStoredAmount = BottomlessBundleItem.getMaxStoredAmount(bottomlessBundleBlockEntity.powerLevel);
                    if (variant.isBlank()) {
                        player.method_7353((class_2561)class_2561.method_43471((String)"item.spectrum.bottomless_bundle.tooltip.empty"), true);
                    } else {
                        player.method_7353((class_2561)class_2561.method_43469((String)"item.spectrum.bottomless_bundle.tooltip.count_of", (Object[])new Object[]{amount, maxStoredAmount}).method_10852(variant.getItem().method_7848()), true);
                    }
                });
            } else {
                world.method_35230(pos, SpectrumBlockEntities.BOTTOMLESS_BUNDLE).ifPresent(bottomlessBundleBlockEntity -> {
                    SingleVariantStorage<ItemVariant> storage = bottomlessBundleBlockEntity.storage;
                    ItemVariant storedVariant = (ItemVariant)storage.variant;
                    try (Transaction transaction = Transaction.openOuter();){
                        if (storedVariant.matches(stack) || storedVariant.isBlank()) {
                            if (!stack.method_7960() && stack.method_7909().method_31568()) {
                                long inserted = storage.insert((TransferVariant)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)transaction);
                                stack.method_7934((int)inserted);
                                world.method_8396(null, pos, class_3417.field_34376, class_3419.field_15245, 0.8f, 0.8f + world.method_8409().method_43057() * 0.4f);
                            }
                        } else {
                            long extractedAmount = storage.extract((TransferVariant)storedVariant, (long)storedVariant.getItem().method_7882(), (TransactionContext)transaction);
                            player.method_31548().method_7398(storedVariant.toStack((int)extractedAmount));
                            world.method_8396(null, pos, class_3417.field_34377, class_3419.field_15245, 0.8f, 0.8f + world.method_8409().method_43057() * 0.4f);
                        }
                        transaction.commit();
                    }
                    bottomlessBundleBlockEntity.method_5431();
                });
            }
            return class_9062.field_47729;
        }
        return class_9062.field_47728;
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        return SpectrumBlocks.BOTTOMLESS_BUNDLE.method_8389().method_7854();
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        class_2586 blockEntity = (class_2586)builder.method_51873(class_181.field_1228);
        if (blockEntity instanceof BottomlessBundleBlockEntity) {
            BottomlessBundleBlockEntity bottomlessBundleBlockEntity = (BottomlessBundleBlockEntity)blockEntity;
            return List.of(bottomlessBundleBlockEntity.retrieveBundle());
        }
        return super.method_9560(state, builder);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof BottomlessBundleBlockEntity) {
            BottomlessBundleBlockEntity bottomlessBundleBlockEntity = (BottomlessBundleBlockEntity)blockEntity;
            float curr = bottomlessBundleBlockEntity.storage.amount;
            float max = bottomlessBundleBlockEntity.storage.getCapacity();
            return (float)class_3532.method_15375((float)(curr / max * 14.0f)) + curr > 0.0f ? 1 : 0;
        }
        return 0;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof BottomlessBundleBlockEntity) {
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)((class_2680)super.method_9605(ctx).method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(class_7718.method_45479((float)ctx.method_8044())))).method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(ctx.method_8041().method_57826(class_9334.field_49625)));
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(rotation.method_10502(((Integer)state.method_11654((class_2769)ROTATION)).intValue(), MAX_ROTATIONS)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(mirror.method_10344(((Integer)state.method_11654((class_2769)ROTATION)).intValue(), MAX_ROTATIONS)));
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        class_2586 blockEntity;
        if (!world.field_9236 && (blockEntity = world.method_8321(pos)) instanceof BottomlessBundleBlockEntity) {
            BottomlessBundleBlockEntity bottomlessBundleBlockEntity = (BottomlessBundleBlockEntity)blockEntity;
            bottomlessBundleBlockEntity.setBundle(itemStack.method_7972(), (class_7225.class_7874)world.method_30349());
            world.method_8455(pos, (class_2248)this);
        }
    }

    public class_5250 method_9518() {
        return class_2561.method_43471((String)"item.spectrum.bottomless_bundle");
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{class_2741.field_12532, LOCKED});
    }
}

