/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.chests;

import de.dafuqs.spectrum.inventories.BlackHoleChestScreenHandler;
import de.dafuqs.spectrum.inventories.CompactingChestScreenHandler;
import de.dafuqs.spectrum.inventories.FabricationChestScreenHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.api.EnvironmentInterfaces;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2618;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5560;
import net.minecraft.class_5561;
import net.minecraft.class_7225;
import net.minecraft.class_9297;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

@EnvironmentInterfaces(value={@EnvironmentInterface(value=EnvType.CLIENT, itf=class_2618.class)})
public abstract class SpectrumChestBlockEntity
extends class_2621
implements class_2618 {
    public final class_5561 stateManager;
    protected final class_5560 lidAnimator;
    protected class_2371<class_1799> inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);

    protected SpectrumChestBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
        this.lidAnimator = new class_5560();
        this.stateManager = new class_5561(){

            protected void method_31681(class_1937 world, class_2338 pos, class_2680 state) {
                SpectrumChestBlockEntity.playSound(world, pos, SpectrumChestBlockEntity.this.getOpenSound());
                SpectrumChestBlockEntity.this.onOpenSpectrum();
            }

            protected void method_31683(class_1937 world, class_2338 pos, class_2680 state) {
                SpectrumChestBlockEntity.playSound(world, pos, SpectrumChestBlockEntity.this.getCloseSound());
                SpectrumChestBlockEntity.this.onCloseSpectrum();
            }

            protected void method_31682(class_1937 world, class_2338 pos, class_2680 state, int oldViewerCount, int newViewerCount) {
                SpectrumChestBlockEntity.this.onInvOpenOrClose(world, pos, state, oldViewerCount, newViewerCount);
            }

            protected boolean method_31679(class_1657 player) {
                class_1703 screenHandler = player.field_7512;
                class_1263 inventory = null;
                if (screenHandler instanceof class_1707) {
                    inventory = ((class_1707)screenHandler).method_7629();
                } else if (screenHandler instanceof FabricationChestScreenHandler) {
                    FabricationChestScreenHandler fabricationChestScreenHandler = (FabricationChestScreenHandler)screenHandler;
                    inventory = fabricationChestScreenHandler.getInventory();
                } else if (screenHandler instanceof BlackHoleChestScreenHandler) {
                    BlackHoleChestScreenHandler blackHoleChestScreenHandler = (BlackHoleChestScreenHandler)screenHandler;
                    inventory = blackHoleChestScreenHandler.getInventory();
                } else if (screenHandler instanceof CompactingChestScreenHandler) {
                    CompactingChestScreenHandler compactingChestScreenHandler = (CompactingChestScreenHandler)screenHandler;
                    inventory = compactingChestScreenHandler.getInventory();
                }
                return inventory == SpectrumChestBlockEntity.this;
            }
        };
    }

    private static void playSound(class_1937 world, class_2338 pos, class_3414 soundEvent) {
        world.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, soundEvent, class_3419.field_15245, 0.5f, world.field_9229.method_43057() * 0.1f + 0.9f);
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, SpectrumChestBlockEntity blockEntity) {
        blockEntity.lidAnimator.method_31672();
    }

    @Environment(value=EnvType.CLIENT)
    public float method_11274(float tickDelta) {
        return this.lidAnimator.method_31673(tickDelta);
    }

    public void onOpenSpectrum() {
    }

    public void onCloseSpectrum() {
    }

    public boolean method_11004(int type, int data) {
        if (type == 1) {
            this.lidAnimator.method_31674(data > 0);
            return true;
        }
        return super.method_11004(type, data);
    }

    protected void onInvOpenOrClose(class_1937 world, class_2338 pos, class_2680 state, int oldViewerCount, int newViewerCount) {
        class_2248 block = state.method_26204();
        world.method_8427(pos, block, 1, newViewerCount);
    }

    public void method_5435(class_1657 player) {
        if (!player.method_7325()) {
            this.stateManager.method_31684(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void method_5432(class_1657 player) {
        if (!player.method_7325()) {
            this.stateManager.method_31685(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void method_5447(int slot, class_1799 stack) {
        super.method_5447(slot, stack);
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> list) {
        this.inventory = list;
    }

    public void onScheduledTick() {
        this.stateManager.method_31686(this.method_10997(), this.method_11016(), this.method_11010());
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 registryLookup) {
        super.method_11014(tag, registryLookup);
        this.method_54871(tag);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, this.inventory, (class_7225.class_7874)registryLookup);
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 registryLookup) {
        super.method_11007(tag, registryLookup);
        this.method_54872(tag);
        if (!this.inventory.isEmpty()) {
            class_1262.method_5426((class_2487)tag, this.inventory, (class_7225.class_7874)registryLookup);
        }
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(class_9334.field_49626, (Object)new class_9297(this.field_12037, this.field_12036));
    }

    public class_3414 getOpenSound() {
        return class_3417.field_14982;
    }

    public class_3414 getCloseSound() {
        return class_3417.field_14823;
    }
}

