/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.crystallarieum;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.blocks.crystallarieum.CrystallarieumBlockEntity;
import de.dafuqs.spectrum.recipe.crystallarieum.CrystallarieumRecipe;
import de.dafuqs.spectrum.render.FluidRendering;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_5253;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;

@Environment(value=EnvType.CLIENT)
public class CrystallarieumBlockEntityRenderer<T extends CrystallarieumBlockEntity>
implements class_827<T> {
    private static final class_4730 SPRITE = new class_4730(class_1723.field_21668, SpectrumCommon.locate("block/crystallarieum"));
    private final class_630 active;
    private final class_630 inactive;
    private final class_630 halo;
    private final class_630 echo;
    private final class_630 upperecho;

    public CrystallarieumBlockEntityRenderer(class_5614.class_5615 ctx) {
        class_630 root = CrystallarieumBlockEntityRenderer.getTexturedModelData().method_32109();
        this.active = root.method_32086("active");
        this.inactive = root.method_32086("inactive");
        this.halo = root.method_32086("halo");
        this.echo = this.halo.method_32086("echo");
        this.upperecho = this.echo.method_32086("upperecho");
    }

    public void render(CrystallarieumBlockEntity crystal, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_1799 catalystStack;
        if (crystal.animator == null) {
            return;
        }
        crystal.animator.animate(tickDelta, 0L);
        class_4588 vertices = SPRITE.method_24145(vertexConsumers, class_1921::method_23580);
        this.renderHalo(crystal, tickDelta, matrices, vertexConsumers, light, overlay, vertices);
        FluidVariant fluid = (FluidVariant)crystal.fluidStorage.variant;
        if (!fluid.isBlank()) {
            matrices.method_22903();
            class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluid);
            assert (sprite != null);
            class_2338 pos = crystal.method_11016().method_10084();
            int luminance = FluidVariantAttributes.getLuminance((FluidVariant)fluid);
            int skylight = crystal.method_10997().method_8314(class_1944.field_9282, pos);
            int glow = class_765.method_23687((int)Math.max(luminance, skylight), (int)crystal.method_10997().method_8314(class_1944.field_9284, pos));
            boolean full = crystal.fluidStorage.amount == 81000L;
            float y = full ? 0.975f : 0.94f;
            int rim = full ? 1 : 2;
            int[] colors = FluidRendering.unpackColorOf(fluid, crystal);
            FluidRendering.renderFluid(vertexConsumers.getBuffer(class_1921.method_23583()), matrices.method_23760().method_23761(), sprite, glow, overlay, rim, 16 - rim, y, rim, 16 - rim, colors);
            matrices.method_22909();
        }
        if ((catalystStack = crystal.method_5438(0)).method_7960()) {
            return;
        }
        CrystallarieumBlockEntityRenderer.renderCatalysts(crystal, matrices, vertexConsumers, light, overlay, catalystStack);
    }

    private void renderHalo(CrystallarieumBlockEntity crystal, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_4588 vertices) {
        matrices.method_22903();
        matrices.method_22904(0.5, 1.5, 0.5);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        InkColor ink = InkColors.WHITE;
        long time = crystal.method_10997() != null ? crystal.method_10997().method_8510() % 1000000L : 0L;
        double bounce = (Math.sin(((float)time + tickDelta) / 23.0f) + 1.0) * (double)crystal._bounce.get().floatValue() / 2.0;
        if (crystal.currentRecipe != null) {
            ink = ((CrystallarieumRecipe)crystal.currentRecipe.comp_1933()).getInkColor();
            this.active.method_22699(matrices, vertices, 0xF000F0, overlay, ink.getColorInt());
        } else {
            this.inactive.method_22698(matrices, vertices, light, overlay);
        }
        crystal.rotation += crystal._speed.get().floatValue();
        matrices.method_22907(class_7833.field_40716.rotationDegrees(crystal.rotation));
        int argb = class_5253.class_5254.method_58144((int)Math.round(crystal._alpha.get().floatValue() * 255.0f), (int)ink.getColorInt());
        this.halo.field_3656 = (float)(-9.0 - bounce);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-crystal.rotation * 2.0f));
        this.echo.field_3656 = (float)(0.5 - bounce / 3.0);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(crystal.rotation * 1.5f));
        this.upperecho.field_3656 = (float)(-0.5 - bounce / 3.0);
        this.halo.method_22699(matrices, vertices, 0xF000F0, overlay, argb);
        class_1799 inkStorageStack = crystal.method_5438(1);
        if (!inkStorageStack.method_7960()) {
            matrices.method_22905(0.65f, 0.65f, 0.65f);
            matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
            matrices.method_22904(0.0, 0.975 + bounce / 3.0, 0.0);
            class_310.method_1551().method_1480().method_23178(inkStorageStack, class_811.field_4318, light, overlay, matrices, vertexConsumers, crystal.method_10997(), 0);
        }
        matrices.method_22909();
    }

    private static void renderCatalysts(CrystallarieumBlockEntity crystal, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_1799 catalystStack) {
        int renderedStackCount = (int)Math.ceil((double)catalystStack.method_7947() / 17.0);
        matrices.method_22903();
        matrices.method_22904(0.5, 0.4, 0.5);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(270.0f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(70.0f));
        if (renderedStackCount == 1) {
            class_310.method_1551().method_1480().method_23178(catalystStack, class_811.field_4318, light, overlay, matrices, vertexConsumers, crystal.method_10997(), 0);
            matrices.method_22909();
            return;
        }
        for (int i = 0; i < renderedStackCount; ++i) {
            class_310.method_1551().method_1480().method_23178(catalystStack, class_811.field_4318, light, overlay, matrices, vertexConsumers, crystal.method_10997(), 0);
            matrices.method_22904(0.0, 0.0, -0.0225);
            matrices.method_22907(class_7833.field_40718.rotationDegrees(53.0f));
        }
        matrices.method_22909();
    }

    public int method_33893() {
        return 48;
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 active = modelPartData.method_32117("active", class_5606.method_32108().method_32101(40, 34).method_32098(-5.0f, -3.0f, -5.0f, 10.0f, 4.0f, 10.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)22.0f, (float)0.0f));
        class_5610 inactive = modelPartData.method_32117("inactive", class_5606.method_32108().method_32101(80, 34).method_32098(-5.0f, -3.0f, -5.0f, 10.0f, 4.0f, 10.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)22.0f, (float)0.0f));
        class_5610 halo = modelPartData.method_32117("halo", class_5606.method_32108().method_32101(77, 48).method_32098(-8.5f, 1.0f, -8.5f, 17.0f, 0.0f, 17.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)-9.0f, (float)0.0f));
        class_5610 diamond_r1 = halo.method_32117("diamond_r1", class_5606.method_32108().method_32101(80, 65).method_32098(-7.5f, 0.0f, -7.5f, 15.0f, 0.0f, 15.0f, new class_5605(0.0f)), class_5603.method_32091((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        class_5610 echo = halo.method_32117("echo", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)0.5f, (float)0.0f));
        class_5610 echoring_r1 = echo.method_32117("echoring_r1", class_5606.method_32108().method_32101(80, 80).method_32098(-7.5f, 0.0f, -7.5f, 15.0f, 0.0f, 15.0f, new class_5605(0.0f)), class_5603.method_32091((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        class_5610 upperecho = echo.method_32117("upperecho", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)-0.5f, (float)0.0f));
        class_5610 echoring_r2 = upperecho.method_32117("echoring_r2", class_5606.method_32108().method_32101(80, 95).method_32098(-7.5f, 0.0f, -7.5f, 15.0f, 0.0f, 15.0f, new class_5605(0.0f)), class_5603.method_32091((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        return class_5607.method_32110((class_5609)modelData, (int)128, (int)128);
    }
}

