/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.decay;

import com.mojang.serialization.MapCodec;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.DeeperDownPortalBlock;
import de.dafuqs.spectrum.blocks.decay.DecayBlock;
import de.dafuqs.spectrum.particle.effect.ColoredCraftingParticleEffect;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumDimensions;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class RuinBlock
extends DecayBlock {
    public static final MapCodec<RuinBlock> CODEC = RuinBlock.method_54094(RuinBlock::new);

    public RuinBlock(class_4970.class_2251 settings) {
        super(settings, SpectrumCommon.CONFIG.RuinDecayTickRate, SpectrumCommon.CONFIG.RuinCanDestroyBlockEntities, 3, 5.0f);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)CONVERSION, (Comparable)((Object)DecayBlock.Conversion.NONE)));
    }

    protected MapCodec<? extends RuinBlock> method_53969() {
        return CODEC;
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (!world.field_9236) {
            world.method_8396(null, pos, SpectrumSoundEvents.RUIN_PLACED, class_3419.field_15245, 0.5f, 1.0f);
        } else {
            class_5819 random = world.method_8409();
            world.method_8406((class_2394)class_2398.field_11236, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, (double)((-1.0f + random.method_43057() * 2.0f) / 12.0f), 0.05, (double)((-1.0f + random.method_43057() * 2.0f) / 12.0f));
            world.method_8406((class_2394)class_2398.field_11221, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, (double)((-1.0f + random.method_43057() * 2.0f) / 12.0f), 0.05, (double)((-1.0f + random.method_43057() * 2.0f) / 12.0f));
            for (int i = 0; i < 40; ++i) {
                world.method_8406((class_2394)ColoredCraftingParticleEffect.GRAY, (double)pos.method_10263() - 0.5 + (double)(random.method_43057() * 2.0f), (double)((float)pos.method_10264() + random.method_43057()), (double)pos.method_10260() - 0.5 + (double)(random.method_43057() * 2.0f), (double)((-1.0f + random.method_43057() * 2.0f) / 12.0f), 0.05, (double)((-1.0f + random.method_43057() * 2.0f) / 12.0f));
            }
        }
    }

    @Override
    @Nullable
    protected class_2680 getSpreadState(class_2680 stateToSpreadFrom, class_2680 stateToSpreadTo, class_1937 world, class_2338 stateToSpreadToPos) {
        if (stateToSpreadTo.method_26220((class_1922)world, stateToSpreadToPos).method_1110() || stateToSpreadTo.method_26164(SpectrumBlockTags.RUIN_SAFE)) {
            return null;
        }
        if (stateToSpreadTo.method_26164(SpectrumBlockTags.RUIN_SPECIAL_CONVERSIONS)) {
            return (class_2680)this.method_9564().method_11657((class_2769)CONVERSION, (Comparable)((Object)DecayBlock.Conversion.SPECIAL));
        }
        if (stateToSpreadTo.method_26164(SpectrumBlockTags.RUIN_CONVERSIONS)) {
            if (world.method_27983().equals(class_1937.field_25181) && Math.abs(stateToSpreadToPos.method_10263()) < 8 && Math.abs(stateToSpreadToPos.method_10260()) < 8) {
                return null;
            }
            return (class_2680)this.method_9564().method_11657((class_2769)CONVERSION, (Comparable)((Object)DecayBlock.Conversion.DEFAULT));
        }
        return (class_2680)stateToSpreadFrom.method_11657((class_2769)CONVERSION, (Comparable)((Object)DecayBlock.Conversion.NONE));
    }

    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (this.shouldCreatePortalFacingUp(level, pos, state).isPresent()) {
                SpectrumAdvancementCriteria.DEEPER_DOWN_PORTAL_OPENING.trigger(serverPlayer);
            }
        }
        return super.method_9576(level, pos, state, player);
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, level, pos, newState, moved);
        Optional<Boolean> shouldCreatePortalFacingUp = this.shouldCreatePortalFacingUp(level, pos, state);
        if (shouldCreatePortalFacingUp.isPresent()) {
            level.method_8501(pos, (class_2680)SpectrumBlocks.DEEPER_DOWN_PORTAL.method_9564().method_11657((class_2769)DeeperDownPortalBlock.FACING_UP, (Comparable)shouldCreatePortalFacingUp.get()));
        }
    }

    protected Optional<Boolean> shouldCreatePortalFacingUp(class_1937 level, class_2338 pos, class_2680 state) {
        DecayBlock.Conversion conversion = (DecayBlock.Conversion)((Object)state.method_11654((class_2769)CONVERSION));
        if (level.method_27983() == class_1937.field_25180) {
            if (pos.method_10264() == level.method_31607() + level.method_8597().comp_653() - 1) {
                return Optional.of(Boolean.TRUE);
            }
            if (pos.method_10264() == level.method_31607()) {
                return Optional.of(Boolean.FALSE);
            }
        } else {
            if (conversion == DecayBlock.Conversion.SPECIAL || level.method_27983() == class_1937.field_25179 && pos.method_10264() == level.method_31607()) {
                return Optional.of(Boolean.FALSE);
            }
            if (level.method_27983() == SpectrumDimensions.DIMENSION_KEY && pos.method_10264() == level.method_31600() - 1) {
                return Optional.of(Boolean.TRUE);
            }
        }
        return Optional.empty();
    }
}

