/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.deeper_down;

import com.mojang.serialization.MapCodec;
import de.dafuqs.spectrum.blocks.deeper_down.HummingstoneBlockEntity;
import de.dafuqs.spectrum.events.SpectrumGameEvents;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5714;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class HummingstoneBlock
extends class_2237 {
    public static final MapCodec<HummingstoneBlock> CODEC = HummingstoneBlock.method_54094(HummingstoneBlock::new);
    public static final float CHANCE_TO_ECHO_HUM_EVENT = 0.08f;
    public static final class_2746 HUMMING = class_2746.method_11825((String)"humming");

    public HummingstoneBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)HUMMING, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends HummingstoneBlock> method_53969() {
        return CODEC;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        float r;
        super.method_9496(state, world, pos, random);
        if (!((Boolean)state.method_11654((class_2769)HUMMING)).booleanValue()) {
            return;
        }
        class_2350 direction = class_2350.method_10162((class_5819)random);
        if (direction != class_2350.field_11033) {
            class_2338 blockPos = pos.method_10093(direction);
            class_2680 blockState = world.method_8320(blockPos);
            if (!state.method_26225() || !blockState.method_26206((class_1922)world, blockPos, direction.method_10153())) {
                double d = direction.method_10148() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10148() * 0.6;
                double e = direction.method_10164() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10164() * 0.6;
                double f = direction.method_10165() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10165() * 0.6;
                world.method_8406((class_2394)class_2398.field_11224, (double)pos.method_10263() + d, (double)pos.method_10264() + e, (double)pos.method_10260() + f, 0.0, 0.05, 0.0);
            }
        }
        if ((r = random.method_43057()) < 0.3f) {
            float pitch = 0.4f + 0.4f * (float)pos.method_10263() % 8.0f + 0.4f * (float)pos.method_10264() % 8.0f + 0.4f * (float)pos.method_10260() % 8.0f;
            world.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, SpectrumSoundEvents.HUMMINGSTONE_HUM, class_3419.field_15245, 0.4f + random.method_43057() * 0.1f, pitch, false);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{HUMMING});
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!((Boolean)state.method_11654((class_2769)HUMMING)).booleanValue()) {
            if (!world.field_9236) {
                HummingstoneBlock.startHumming(world, pos, state, (class_1297)player, false);
            }
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    public boolean method_9542(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)HUMMING);
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9514(state, world, pos, random);
        if (!world.field_9236 && ((Boolean)state.method_11654((class_2769)HUMMING)).booleanValue()) {
            HummingstoneBlock.stopHumming((class_1937)world, pos, state);
        }
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        super.method_9548(state, world, pos, entity);
        if (!world.field_9236 && !((Boolean)state.method_11654((class_2769)HUMMING)).booleanValue()) {
            HummingstoneBlock.startHumming(world, pos, state, entity, false);
        }
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        super.method_9554(world, state, pos, entity, fallDistance);
        if (!world.field_9236 && !((Boolean)state.method_11654((class_2769)HUMMING)).booleanValue()) {
            HummingstoneBlock.startHumming(world, pos, state, entity, false);
        }
    }

    public void method_19286(class_1937 world, class_2680 state, class_3965 hit, class_1676 projectile) {
        if (!world.field_9236 && !((Boolean)state.method_11654((class_2769)HUMMING)).booleanValue()) {
            HummingstoneBlock.startHumming(world, hit.method_17777(), state, projectile.method_24921(), false);
        }
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? null : HummingstoneBlock.method_31618(type, SpectrumBlockEntities.HUMMINGSTONE, HummingstoneBlockEntity::serverTick);
    }

    public boolean method_9506(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)HUMMING);
    }

    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return (Boolean)state.method_11654((class_2769)HUMMING) != false ? 15 : 0;
    }

    public static void startHumming(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1297 entity, boolean causedByOtherHum) {
        if (!(state.method_26204() instanceof HummingstoneBlock)) {
            return;
        }
        world.method_8396(null, pos, SpectrumSoundEvents.HUMMINGSTONE_HUM, class_3419.field_15245, 0.75f, 1.0f);
        if (!((Boolean)state.method_11654((class_2769)HUMMING)).booleanValue()) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)HUMMING, (Comparable)Boolean.valueOf(true)));
        }
        if (!causedByOtherHum || world.field_9229.method_43057() < 0.08f) {
            world.method_33596(entity, SpectrumGameEvents.HUMMINGSTONE_HUMMING, pos);
        }
    }

    public static void stopHumming(class_1937 world, class_2338 pos, class_2680 state) {
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)HUMMING, (Comparable)Boolean.valueOf(false)));
        world.method_8396(null, pos, class_3417.field_26980, class_3419.field_15245, 0.5f, 0.5f + world.field_9229.method_43057() * 1.2f);
    }

    public static void onHymn(class_1937 world, class_2338 pos, @Nullable class_1297 entity) {
        if (!(world.method_8320(pos).method_26204() instanceof HummingstoneBlock)) {
            return;
        }
        world.method_33596(entity, SpectrumGameEvents.HUMMINGSTONE_HYMN, pos);
        world.method_8396(null, pos, class_3417.field_26979, class_3419.field_15245, 1.25f, 0.5f + world.field_9229.method_43057() * 1.2f);
        world.method_22352(pos, false);
        HummingstoneBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)SpectrumItems.RESONANCE_SHARD.method_7854());
        if (entity instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)entity;
            SpectrumAdvancementCriteria.CREATE_HUMMINGSTONE_HYMN.trigger(serverPlayerEntity, (class_3218)world, pos);
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new HummingstoneBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5714 method_32896(class_3218 world, T blockEntity) {
        if (blockEntity instanceof HummingstoneBlockEntity) {
            HummingstoneBlockEntity hummingstoneBlockEntity = (HummingstoneBlockEntity)blockEntity;
            return hummingstoneBlockEntity.listener;
        }
        return null;
    }
}

