/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.ender;

import de.dafuqs.spectrum.api.block.PlayerOwned;
import de.dafuqs.spectrum.api.block.PlayerOwnedWithName;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2601;
import net.minecraft.class_2680;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class EnderDropperBlockEntity
extends class_2601
implements PlayerOwnedWithName {
    private UUID ownerUUID;
    private String ownerName;

    public EnderDropperBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntities.ENDER_DROPPER, blockPos, blockState);
    }

    protected class_2561 method_17823() {
        if (this.hasOwner()) {
            return class_2561.method_43469((String)"block.spectrum.ender_dropper.owner", (Object[])new Object[]{this.ownerName});
        }
        return class_2561.method_43471((String)"block.spectrum.ender_dropper");
    }

    public int method_11076(class_5819 random) {
        return this.getInventory().map(inventory -> {
            int selectedIndex = -1;
            int chance = 1;
            for (int i = 0; i < inventory.method_5439(); ++i) {
                if (inventory.method_5438(i).method_7960() || random.method_43048(chance++) != 0) continue;
                selectedIndex = i;
            }
            return selectedIndex;
        }).orElse(-1);
    }

    public class_1799 method_11075(class_1799 stack) {
        this.getInventory().ifPresent(inventory -> {
            int i = this.method_58350(stack);
            for (int j = 0; j < inventory.method_5439(); ++j) {
                class_1799 itemStack = inventory.method_5438(j);
                if (!itemStack.method_7960() && !class_1799.method_31577((class_1799)stack, (class_1799)itemStack)) continue;
                int k = Math.min(stack.method_7947(), i - itemStack.method_7947());
                if (k > 0) {
                    if (itemStack.method_7960()) {
                        this.method_5447(j, stack.method_7971(k));
                    } else {
                        stack.method_7934(k);
                        itemStack.method_7933(k);
                    }
                }
                if (stack.method_7960()) break;
            }
        });
        return stack;
    }

    public class_1799 method_5438(int slot) {
        return this.getInventory().map(i -> i.method_5438(slot)).orElse(class_1799.field_8037);
    }

    public void method_5447(int slot, class_1799 itemStack) {
        this.getInventory().ifPresent(i -> i.method_5447(slot, itemStack));
    }

    public class_1799 method_5441(int slot) {
        return this.getInventory().map(i -> i.method_5441(slot)).orElse(class_1799.field_8037);
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.getInventory().map(i -> i.method_5434(slot, amount)).orElse(class_1799.field_8037);
    }

    public boolean method_5442() {
        return this.getInventory().map(class_1277::method_5442).orElse(true);
    }

    public boolean method_49104(class_1263 hopperInventory, int slot, class_1799 stack) {
        return false;
    }

    private Optional<class_1730> getInventory() {
        class_1657 player = this.getOwnerIfOnline();
        if (player != null) {
            return Optional.of(player.method_7274());
        }
        return Optional.empty();
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
        this.ownerName = playerEntity.method_5477().getString();
        this.method_5431();
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.ownerName = PlayerOwned.readOwnerName(nbt);
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        PlayerOwned.writeOwnerName(nbt, this.ownerName);
    }

    protected class_2371<class_1799> method_11282() {
        return this.getInventory().map(class_1277::method_54454).orElse(class_2371.method_10211());
    }

    protected void method_11281(class_2371<class_1799> inventory) {
        this.getInventory().ifPresent(inv -> {
            for (int i = 0; i < inventory.size(); ++i) {
                inv.method_5447(i, (class_1799)inventory.get(i));
            }
        });
    }

    public int method_5439() {
        return this.getInventory().map(class_1277::method_5439).orElse(0);
    }

    @Nullable
    public class_5321<class_52> method_54869() {
        return null;
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 playerEntity) {
        return null;
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return null;
    }
}

