/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.energy;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.block.PlayerOwned;
import de.dafuqs.spectrum.api.energy.InkStorage;
import de.dafuqs.spectrum.api.energy.InkStorageBlockEntity;
import de.dafuqs.spectrum.api.energy.InkStorageItem;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.energy.storage.TotalCappedInkStorage;
import de.dafuqs.spectrum.components.InkStorageComponent;
import de.dafuqs.spectrum.helpers.CodecHelper;
import de.dafuqs.spectrum.inventories.ColorPickerScreenHandler;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import de.dafuqs.spectrum.particle.effect.ColoredFluidRisingParticleEffect;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.InkConvertingRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.jetbrains.annotations.Nullable;

public class ColorPickerBlockEntity
extends class_2621
implements PlayerOwned,
InkStorageBlockEntity<TotalCappedInkStorage>,
ExtendedScreenHandlerFactory<ColorPickerScreenHandler.ScreenOpeningData> {
    public static final int INVENTORY_SIZE = 2;
    public static final int INPUT_SLOT_ID = 0;
    public static final int OUTPUT_SLOT_ID = 1;
    public static final long TICKS_PER_CONVERSION = 5L;
    public static final long STORAGE_AMOUNT = 0x1900000L;
    public class_2371<class_1799> inventory;
    protected TotalCappedInkStorage inkStorage;
    protected boolean paused;
    protected boolean inkDirty;
    @Nullable
    protected InkConvertingRecipe cachedRecipe;
    protected Optional<class_6880<InkColor>> selectedColor = Optional.empty();
    private UUID ownerUUID;

    public ColorPickerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntities.COLOR_PICKER, blockPos, blockState);
        this.inventory = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
        this.inkStorage = new TotalCappedInkStorage(0x1900000L, Map.of());
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, ColorPickerBlockEntity blockEntity) {
        if (!world.field_9236) {
            blockEntity.inkDirty = false;
            if (!blockEntity.paused) {
                boolean convertedPigment = false;
                boolean shouldPause = true;
                if (world.method_8510() % 5L == 0L) {
                    convertedPigment = blockEntity.tryConvertPigmentToEnergy((class_3218)world);
                } else {
                    shouldPause = false;
                }
                boolean filledContainer = blockEntity.tryFillInkContainer();
                if (convertedPigment || filledContainer) {
                    blockEntity.updateInClientWorld();
                    blockEntity.setInkDirty();
                    blockEntity.method_5431();
                } else if (shouldPause) {
                    blockEntity.paused = true;
                }
            }
        }
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_54871(nbt)) {
            class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        }
        CodecHelper.fromNbt(InkStorageComponent.CODEC, nbt.method_10580("InkStorage")).ifPresent(storage -> {
            this.inkStorage = new TotalCappedInkStorage(storage.maxEnergyTotal(), storage.storedEnergy());
        });
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.selectedColor = nbt.method_10573("SelectedColor", 8) ? Optional.of(SpectrumRegistries.INK_COLOR.method_47983(InkColor.ofIdString(nbt.method_10558("SelectedColor")).get())) : Optional.empty();
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        if (!this.method_54872(nbt)) {
            class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        }
        CodecHelper.writeNbt(nbt, "InkStorage", InkStorageComponent.CODEC, new InkStorageComponent(this.inkStorage));
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        this.selectedColor.ifPresent(color -> nbt.method_10582("SelectedColor", color.method_55840()));
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.spectrum.color_picker");
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new ColorPickerScreenHandler(syncId, playerInventory, new ColorPickerScreenHandler.ScreenOpeningData(this.field_11867, this.selectedColor));
    }

    public ColorPickerScreenHandler.ScreenOpeningData getScreenOpeningData(class_3222 serverPlayerEntity) {
        return new ColorPickerScreenHandler.ScreenOpeningData(this.field_11867, this.selectedColor);
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
        this.method_5431();
    }

    @Override
    public TotalCappedInkStorage getEnergyStorage() {
        return this.inkStorage;
    }

    @Override
    public void setInkDirty() {
        this.inkDirty = true;
    }

    @Override
    public boolean getInkDirty() {
        return this.inkDirty;
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> list) {
        this.inventory = list;
        this.paused = false;
        this.updateInClientWorld();
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 itemStack = super.method_5434(slot, amount);
        this.paused = false;
        this.updateInClientWorld();
        return itemStack;
    }

    public class_1799 method_5441(int slot) {
        class_1799 itemStack = super.method_5441(slot);
        this.paused = false;
        this.updateInClientWorld();
        return itemStack;
    }

    public void method_5447(int slot, class_1799 stack) {
        super.method_5447(slot, stack);
        this.paused = false;
        this.updateInClientWorld();
    }

    public int method_5439() {
        return 2;
    }

    protected boolean tryConvertPigmentToEnergy(class_3218 world) {
        InkConvertingRecipe recipe = this.getInkConvertingRecipe((class_1937)world);
        if (recipe != null) {
            InkColor inkColor = recipe.getInkColor();
            long amount = recipe.getInkAmount();
            if (amount <= this.inkStorage.getRoom(inkColor)) {
                ((class_1799)this.inventory.get(0)).method_7934(1);
                this.inkStorage.addEnergy(inkColor, amount);
                if (SpectrumCommon.CONFIG.BlockSoundVolume > 0.0f) {
                    world.method_8396(null, this.field_11867, SpectrumSoundEvents.COLOR_PICKER_PROCESSING, class_3419.field_15245, SpectrumCommon.CONFIG.BlockSoundVolume / 3.0f, 1.0f);
                }
                PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, new class_243((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.7, (double)this.field_11867.method_10260() + 0.5), ColoredFluidRisingParticleEffect.of(inkColor.getColorInt()), 5, new class_243(0.22, 0.0, 0.22), new class_243(0.0, 0.1, 0.0));
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected InkConvertingRecipe getInkConvertingRecipe(class_1937 world) {
        class_1799 inputStack = (class_1799)this.inventory.get(0);
        if (inputStack.method_7960()) {
            this.cachedRecipe = null;
            return null;
        }
        if (this.cachedRecipe != null && ((class_1856)this.cachedRecipe.method_8117().get(0)).method_8093(inputStack)) {
            return this.cachedRecipe;
        }
        Optional recipe = world.method_8433().method_8132(SpectrumRecipeTypes.INK_CONVERTING, (class_9695)new class_9696((class_1799)this.inventory.get(0)), world);
        if (recipe.isPresent()) {
            this.cachedRecipe = (InkConvertingRecipe)((class_8786)recipe.get()).comp_1933();
            return this.cachedRecipe;
        }
        this.cachedRecipe = null;
        return null;
    }

    protected boolean tryFillInkContainer() {
        long transferredAmount = 0L;
        class_1799 stack = (class_1799)this.inventory.get(1);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof InkStorageItem) {
            InkStorageItem inkStorageItem = (InkStorageItem)class_17922;
            Object itemStorage = inkStorageItem.getEnergyStorage(stack);
            class_3222 owner = null;
            class_1657 class_16572 = this.getOwnerIfOnline();
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayerEntity;
                owner = serverPlayerEntity = (class_3222)class_16572;
            }
            if (this.selectedColor.isEmpty()) {
                for (InkColor color : InkColors.all()) {
                    transferredAmount += this.tryTransferInk(owner, stack, (InkStorage)itemStorage, color);
                }
            } else {
                transferredAmount = this.tryTransferInk(owner, stack, (InkStorage)itemStorage, (InkColor)this.selectedColor.get().comp_349());
            }
            if (transferredAmount > 0L) {
                inkStorageItem.setEnergyStorage(stack, (InkStorage)itemStorage);
            }
        }
        return transferredAmount > 0L;
    }

    private long tryTransferInk(class_3222 owner, class_1799 stack, InkStorage itemStorage, InkColor color) {
        long amount = InkStorage.transferInk(this.inkStorage, itemStorage, color);
        if (amount > 0L && owner != null) {
            SpectrumAdvancementCriteria.INK_CONTAINER_INTERACTION.trigger(owner, stack, itemStorage, color, amount);
        }
        return amount;
    }

    public void setSelectedColor(Optional<class_6880<InkColor>> inkColor) {
        this.selectedColor = inkColor;
        this.paused = false;
        this.method_5431();
    }

    public Optional<class_6880<InkColor>> getSelectedColor() {
        return this.selectedColor;
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = new class_2487();
        this.method_11007(nbtCompound, registryLookup);
        return nbtCompound;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void updateInClientWorld() {
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.field_11863.method_8320(this.field_11867), this.field_11863.method_8320(this.field_11867), 4);
        }
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot == 0) {
            return InkConvertingRecipe.isInput(stack.method_7909());
        }
        if (slot == 1) {
            return stack.method_7909() instanceof InkStorageItem;
        }
        return true;
    }
}

