/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.jade_vines;

import com.mojang.serialization.MapCodec;
import de.dafuqs.spectrum.api.interaction.NaturesStaffTriggered;
import de.dafuqs.spectrum.blocks.jade_vines.JadeVine;
import de.dafuqs.spectrum.blocks.jade_vines.JadeVineRootsBlock;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumLootTables;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeVinePlantBlock
extends class_2248
implements JadeVine,
NaturesStaffTriggered {
    public static final MapCodec<JadeVinePlantBlock> CODEC = JadeVinePlantBlock.method_54094(JadeVinePlantBlock::new);
    public static final class_2754<JadeVinesPlantPart> PART = class_2754.method_11850((String)"part", JadeVinesPlantPart.class);
    public static final class_2758 AGE = class_2741.field_12550;

    public JadeVinePlantBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(PART, (Comparable)((Object)JadeVinesPlantPart.BASE))).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(1)));
    }

    public MapCodec<? extends JadeVinePlantBlock> method_53969() {
        return CODEC;
    }

    public static List<class_1799> getHarvestedStacks(class_2680 state, class_3218 world, class_2338 pos, @Nullable class_2586 blockEntity, @Nullable class_1297 entity, class_1799 stack, class_5321<class_52> lootTableIdentifier) {
        class_8567.class_8568 builder = new class_8567.class_8568(world).method_51874(class_181.field_1224, (Object)state).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos)).method_51874(class_181.field_1229, (Object)stack).method_51877(class_181.field_1226, (Object)entity).method_51877(class_181.field_1228, (Object)blockEntity);
        class_52 lootTable = world.method_8503().method_58576().method_58295(lootTableIdentifier);
        return lootTable.method_51878(builder.method_51875(class_173.field_1172));
    }

    static void setHarvested(@NotNull class_2680 blockState, @NotNull class_3218 world, @NotNull class_2338 blockPos) {
        class_2338 rootsPos = ((JadeVinesPlantPart)((Object)blockState.method_11654(PART))).getLowestRootsPos(blockPos);
        class_2248 class_22482 = world.method_8320(rootsPos).method_26204();
        if (class_22482 instanceof JadeVineRootsBlock) {
            JadeVineRootsBlock jadeVineRootsBlock = (JadeVineRootsBlock)class_22482;
            jadeVineRootsBlock.setPlantToAge(world, rootsPos, 1);
        }
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        super.method_9496(state, world, pos, random);
        int age = (Integer)state.method_11654((class_2769)AGE);
        if (age == 7) {
            if ((double)random.method_43057() < 0.3) {
                JadeVine.spawnBloomParticlesClient(world, pos);
            }
        } else if (age != 0) {
            JadeVine.spawnParticlesClient(world, pos);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (!state.method_26184((class_4538)world, pos) || this.missingBottom(state, world.method_8320(pos.method_10074()))) {
            world.method_39279(pos, (class_2248)this, 1);
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!state.method_26184((class_4538)world, pos) || this.missingBottom(state, world.method_8320(pos.method_10074()))) {
            world.method_22352(pos, false);
        }
    }

    private boolean missingBottom(class_2680 state, class_2680 belowState) {
        JadeVinesPlantPart part = (JadeVinesPlantPart)((Object)state.method_11654(PART));
        if (part == JadeVinesPlantPart.TIP) {
            return false;
        }
        return !(belowState.method_26204() instanceof JadeVinePlantBlock);
    }

    public class_9062 method_55765(class_1799 handStack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        JadeVinesGrowthStage growthStage = JadeVinesGrowthStage.fromAge((Integer)state.method_11654((class_2769)AGE));
        if (growthStage.isFullyGrown()) {
            boolean harvested = false;
            if (handStack.method_31574(class_1802.field_8469)) {
                if (world.field_9236) {
                    return class_9062.field_47728;
                }
                if (player instanceof class_3222) {
                    class_3222 serverPlayerEntity = (class_3222)player;
                    class_174.field_24478.method_23889(serverPlayerEntity, pos, handStack);
                }
                handStack.method_7934(1);
                JadeVinePlantBlock.setHarvested(state, (class_3218)world, pos);
                List<class_1799> harvestedStacks = JadeVinePlantBlock.getHarvestedStacks(state, (class_3218)world, pos, world.method_8321(pos), (class_1297)player, handStack, SpectrumLootTables.JADE_VINE_HARVESTING_NECTAR);
                for (class_1799 harvestedStack : harvestedStacks) {
                    player.method_31548().method_7398(harvestedStack);
                }
                harvested = true;
            }
            if (!harvested) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.spectrum.needs_item_to_harvest").method_10852(class_1802.field_8469.method_7848()), true);
            }
            return class_9062.method_55644((boolean)world.field_9236);
        }
        if (growthStage.canHarvestPetals()) {
            if (!world.field_9236) {
                JadeVinePlantBlock.setHarvested(state, (class_3218)world, pos);
                List<class_1799> harvestedStacks = JadeVinePlantBlock.getHarvestedStacks(state, (class_3218)world, pos, world.method_8321(pos), (class_1297)player, player.method_6047(), SpectrumLootTables.JADE_VINE_HARVESTING_PETALS);
                for (class_1799 harvestedStack : harvestedStacks) {
                    player.method_31548().method_7398(harvestedStack);
                }
            }
            return class_9062.method_55644((boolean)world.field_9236);
        }
        return super.method_55765(handStack, state, world, pos, player, hand, hit);
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        return SpectrumItems.GERMINATED_JADE_VINE_BULB.method_7854();
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return state.method_11654(PART) == JadeVinesPlantPart.TIP ? TIP_SHAPE : SHAPE;
    }

    public boolean method_9558(@NotNull class_2680 state, class_4538 world, class_2338 pos) {
        class_2680 upState = world.method_8320(pos.method_10084());
        class_2248 upBlock = upState.method_26204();
        JadeVinesPlantPart part = (JadeVinesPlantPart)((Object)state.method_11654(PART));
        if (part == JadeVinesPlantPart.BASE) {
            return upBlock instanceof JadeVineRootsBlock;
        }
        if (part == JadeVinesPlantPart.MIDDLE) {
            return upBlock instanceof JadeVinePlantBlock && upState.method_11654(PART) == JadeVinesPlantPart.BASE;
        }
        return upBlock instanceof JadeVinePlantBlock && upState.method_11654(PART) == JadeVinesPlantPart.MIDDLE;
    }

    protected void method_9515(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{PART, AGE});
    }

    @Override
    public boolean setToAge(class_1937 world, class_2338 blockPos, int age) {
        int currentAge;
        class_2680 currentState = world.method_8320(blockPos);
        if (currentState.method_26204() instanceof JadeVinePlantBlock && age != (currentAge = ((Integer)currentState.method_11654((class_2769)AGE)).intValue())) {
            world.method_8501(blockPos, (class_2680)currentState.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age)));
            return true;
        }
        return false;
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.field_9236 && !player.method_7337()) {
            JadeVinePlantBlock.method_9511((class_2680)state, (class_1937)world, (class_2338)pos, null, (class_1297)player, (class_1799)player.method_6047());
        }
        return super.method_9576(world, pos, state, player);
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 stack) {
        super.method_9556(world, player, pos, class_2246.field_10124.method_9564(), blockEntity, stack);
    }

    @Override
    public boolean canUseNaturesStaff(class_1937 world, class_2338 pos, class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) == 0;
    }

    @Override
    public boolean onNaturesStaffUse(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 rootsPos = ((JadeVinesPlantPart)((Object)state.method_11654(PART))).getLowestRootsPos(pos);
        class_2680 rootsState = world.method_8320(rootsPos);
        class_2248 class_22482 = rootsState.method_26204();
        if (class_22482 instanceof JadeVineRootsBlock) {
            JadeVineRootsBlock jadeVineRootsBlock = (JadeVineRootsBlock)class_22482;
            jadeVineRootsBlock.onNaturesStaffUse(world, rootsPos, rootsState, player);
        }
        JadeVine.spawnParticlesServer((class_3218)world, pos, 16);
        return false;
    }

    public static enum JadeVinesPlantPart implements class_3542
    {
        BASE,
        MIDDLE,
        TIP;


        @Contract(pure=true)
        @NotNull
        public String toString() {
            return this.method_15434();
        }

        @Contract(pure=true)
        @NotNull
        public String method_15434() {
            return this == BASE ? "base" : (this == MIDDLE ? "middle" : "tip");
        }

        public class_2338 getLowestRootsPos(class_2338 blockPos) {
            if (this == BASE) {
                return blockPos.method_10084();
            }
            if (this == MIDDLE) {
                return blockPos.method_10086(2);
            }
            return blockPos.method_10086(3);
        }
    }

    public static enum JadeVinesGrowthStage {
        DEAD,
        LEAVES,
        PETALS,
        BLOOM;


        public static JadeVinesGrowthStage fromAge(int age) {
            if (age == 0) {
                return DEAD;
            }
            if (age == 7) {
                return BLOOM;
            }
            if (age > 2) {
                return PETALS;
            }
            return LEAVES;
        }

        public static boolean isFullyGrown(int age) {
            return age == 7;
        }

        public boolean isFullyGrown() {
            return this == BLOOM;
        }

        public boolean canHarvestPetals() {
            return this == PETALS || this == BLOOM;
        }
    }
}

