/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.network;

import de.dafuqs.spectrum.blocks.pastel_network.PastelRenderHelper;
import de.dafuqs.spectrum.blocks.pastel_network.network.ClientPastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3829;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.joml.Math;

@Environment(value=EnvType.CLIENT)
public class ClientPastelNetworkManager
implements PastelNetworkManager<class_638, ClientPastelNetwork>,
class_3829 {
    protected static final int MAX_RENDER_DISTANCE_SQUARED = 2304;
    private final List<ClientPastelNetwork> networks = new ArrayList<ClientPastelNetwork>();

    @Override
    public Optional<? extends ClientPastelNetwork> getNetwork(UUID uuid) {
        return this.networks.stream().filter(n -> n.uuid.equals(uuid)).findFirst();
    }

    @Override
    public ClientPastelNetwork createNetwork(class_638 world, UUID uuid, int color) {
        ClientPastelNetwork network = new ClientPastelNetwork(world, uuid, color);
        this.networks.add(network);
        return network;
    }

    public void renderLines(WorldRenderContext context, class_1309 cameraEntity, boolean paintbrushInHand) {
        class_2338 cameraEntityPos = cameraEntity.method_24515();
        class_638 world = context.world();
        long worldTime = world.method_8510();
        for (ClientPastelNetwork network : this.networks) {
            float alphaMod;
            if (((class_638)network.getWorld()).method_8597() != world.method_8597()) continue;
            float f = alphaMod = paintbrushInHand ? 1.0f : (float)(network.lastChangeTick - worldTime + 20L) * 0.05f;
            if (alphaMod <= 0.0f) continue;
            Graph<class_2338, DefaultEdge> graph = network.getGraph();
            int color = network.getColor();
            float[] colors = PastelRenderHelper.unpackNormalizedColor(color);
            for (DefaultEdge edge : graph.edgeSet()) {
                class_2338 source = (class_2338)graph.getEdgeSource((Object)edge);
                class_2338 target = (class_2338)graph.getEdgeTarget((Object)edge);
                if (cameraEntityPos.method_10262((class_2382)source) > 2304.0 && cameraEntityPos.method_10262((class_2382)target) > 2304.0) continue;
                class_4587 matrices = context.matrixStack();
                class_243 pos = context.camera().method_19326();
                matrices.method_22903();
                matrices.method_22904(-pos.field_1352, -pos.field_1351, -pos.field_1350);
                class_2338 cross = source.method_10075((class_2382)target);
                float interval = (float)((long)(cross.method_10263() + cross.method_10264() + cross.method_10260()) + ((class_638)network.world).method_8510()) % 1000000.0f;
                double alpha = (double)alphaMod * (1.0 - Math.max((double)((double)Math.sin((float)(interval / 17.0f)) * 2.5 - 2.0), (double)0.0));
                colors[0] = (float)alpha;
                PastelRenderHelper.renderLineTo(context.matrixStack(), context.consumers(), colors, source, target);
                matrices.method_22909();
            }
        }
    }

    public void method_5448() {
        this.networks.clear();
    }

    @Override
    public void removeNetwork(UUID uuid) {
        ClientPastelNetwork foundNetwork = null;
        for (ClientPastelNetwork network : this.networks) {
            if (!network.uuid.equals(uuid)) continue;
            foundNetwork = network;
            break;
        }
        if (foundNetwork != null) {
            this.networks.remove(foundNetwork);
        }
    }
}

