/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.network;

import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;

public class PastelNetwork<W extends class_1937> {
    protected Graph<class_2338, DefaultEdge> graph = new SimpleGraph(DefaultEdge.class);
    protected final W world;
    protected final UUID uuid;
    protected final int color;

    public PastelNetwork(W world, UUID uuid, int color) {
        this.world = world;
        this.uuid = uuid;
        this.color = color;
    }

    public int size() {
        return this.graph.vertexSet().size();
    }

    public W getWorld() {
        return this.world;
    }

    public Graph<class_2338, DefaultEdge> getGraph() {
        return this.graph;
    }

    public boolean addEdge(PastelNodeBlockEntity node, PastelNodeBlockEntity parent) {
        return this.addEdge(node.method_11016(), parent.method_11016());
    }

    public boolean addEdge(class_2338 pos1, class_2338 pos2) {
        if (!this.hasEdge(pos1, pos2)) {
            this.graph.addEdge((Object)pos1, (Object)pos2);
            return true;
        }
        return false;
    }

    public boolean hasEdge(class_2338 pos1, class_2338 pos2) {
        if (!this.graph.containsVertex((Object)pos1) || !this.graph.containsVertex((Object)pos2)) {
            return false;
        }
        return this.graph.containsEdge((Object)pos1, (Object)pos2);
    }

    public boolean removeEdge(PastelNodeBlockEntity node, PastelNodeBlockEntity parent) {
        return this.graph.removeEdge((Object)node.method_11016(), (Object)parent.method_11016()) != null;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getColor() {
        return this.color;
    }

    public void setGraph(Graph<class_2338, DefaultEdge> graph) {
        this.graph = graph;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof PastelNetwork) {
            PastelNetwork p = (PastelNetwork)other;
            return this.uuid.equals(p.uuid);
        }
        return false;
    }

    public class_2487 graphToNbt() {
        ArrayList vertices = new ArrayList(this.graph.vertexSet());
        class_2487 graphStorage = new class_2487();
        graphStorage.method_10569("Size", vertices.size());
        for (int i = 0; i < vertices.size(); ++i) {
            class_2338 vertex = (class_2338)vertices.get(i);
            graphStorage.method_10544("Vertex" + i, vertex.method_10063());
            int currentVertex = i;
            List edgeIndexes = this.graph.edgesOf((Object)vertex).stream().map(arg_0 -> this.graph.getEdgeTarget(arg_0)).mapToInt(vertices::indexOf).filter(v -> v != currentVertex).boxed().collect(Collectors.toList());
            if (edgeIndexes.isEmpty()) continue;
            edgeIndexes.add(0, vertices.indexOf(vertex));
            graphStorage.method_10572("EdgeIndexes" + i, edgeIndexes);
        }
        return graphStorage;
    }

    public static Graph<class_2338, DefaultEdge> graphFromNbt(class_2487 nbt) {
        int i;
        SimpleGraph graph = new SimpleGraph(DefaultEdge.class);
        int size = nbt.method_10550("Size");
        ArrayList<class_2338> vertices = new ArrayList<class_2338>();
        for (i = 0; i < size; ++i) {
            class_2338 vertex = class_2338.method_10092((long)nbt.method_10537("Vertex" + i));
            vertices.add(vertex);
            graph.addVertex((Object)vertex);
        }
        for (i = 0; i < size; ++i) {
            if (!nbt.method_10545("EdgeIndexes" + i)) continue;
            int[] edgeIndexes = nbt.method_10561("EdgeIndexes" + i);
            class_2338 source = (class_2338)vertices.get(edgeIndexes[0]);
            for (int targetIndex = 1; targetIndex < edgeIndexes.length; ++targetIndex) {
                class_2338 target = (class_2338)vertices.get(edgeIndexes[targetIndex]);
                if (graph.containsEdge((Object)source, (Object)target)) continue;
                graph.addEdge((Object)source, (Object)target);
            }
        }
        return graph;
    }

    public String getNodeDebugText() {
        return "UUID: " + this.uuid.toString() + " - Edges: " + this.graph.edgeSet().size() + " - Vertices: " + this.graph.vertexSet().size();
    }

    public static enum NodePriority {
        GENERIC,
        MODERATE,
        HIGH;

    }
}

