/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.network;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.network.ServerPastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import de.dafuqs.spectrum.helpers.InWorldInteractionHelper;
import de.dafuqs.spectrum.helpers.SchedulerMap;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PastelTransmission
implements SchedulerMap.Callback {
    public static final Codec<PastelTransmission> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2338.field_25064.listOf().fieldOf("node_positions").forGetter(PastelTransmission::getNodePositions), (App)ItemVariant.CODEC.fieldOf("variant").forGetter(PastelTransmission::getVariant), (App)Codec.LONG.fieldOf("amount").forGetter(PastelTransmission::getAmount), (App)Codec.INT.fieldOf("vertex_time").forGetter(PastelTransmission::getVertexTime)).apply((Applicative)i, PastelTransmission::new));
    public static final class_9139<class_9129, PastelTransmission> PACKET_CODEC = class_9139.method_56905((class_9139)class_2338.field_48404.method_56433(class_9135.method_56363()), PastelTransmission::getNodePositions, (class_9139)ItemVariant.PACKET_CODEC, PastelTransmission::getVariant, (class_9139)class_9135.field_48551, PastelTransmission::getAmount, (class_9139)class_9135.field_48550, PastelTransmission::getVertexTime, PastelTransmission::new);
    @Nullable
    private ServerPastelNetwork network;
    private final List<class_2338> nodePositions;
    private final ItemVariant variant;
    private final long amount;
    private final int vertexTime;

    public PastelTransmission(List<class_2338> nodePositions, ItemVariant variant, long amount, int vertexTime) {
        this.nodePositions = nodePositions;
        this.variant = variant;
        this.amount = amount;
        this.vertexTime = vertexTime;
    }

    public void setNetwork(@NotNull ServerPastelNetwork network) {
        this.network = network;
    }

    @Nullable
    public PastelNetwork<class_3218> getNetwork() {
        return this.network;
    }

    public List<class_2338> getNodePositions() {
        return this.nodePositions;
    }

    public int getVertexTime() {
        return this.vertexTime;
    }

    public int getTransmissionDuration() {
        return this.vertexTime * (this.nodePositions.size() - 1);
    }

    public ItemVariant getVariant() {
        return this.variant;
    }

    public long getAmount() {
        return this.amount;
    }

    public class_2338 getStartPos() {
        return this.nodePositions.get(0);
    }

    @Override
    public void trigger() {
        this.arriveAtDestination();
    }

    private void arriveAtDestination() {
        Storage<ItemVariant> destinationStorage;
        if (this.nodePositions.isEmpty()) {
            return;
        }
        @NotNull class_2338 destinationPos = this.nodePositions.get(this.nodePositions.size() - 1);
        @Nullable PastelNodeBlockEntity destinationNode = this.network.getLoadedNodeAt(destinationPos);
        Object world = this.network.getWorld();
        int inserted = 0;
        if (destinationNode != null && (destinationStorage = destinationNode.getConnectedStorage()) != null) {
            try (Transaction transaction = Transaction.openOuter();){
                if (destinationStorage.supportsInsertion()) {
                    inserted = (int)destinationStorage.insert((Object)this.variant, this.amount, (TransactionContext)transaction);
                    destinationNode.addItemCountUnderway(-inserted);
                    transaction.commit();
                }
            }
        }
        if ((long)inserted != this.amount) {
            InWorldInteractionHelper.scatter(world, (double)destinationPos.method_10263() + 0.5, (double)destinationPos.method_10264() + 0.5, (double)destinationPos.method_10260() + 0.5, this.variant, this.amount - (long)inserted);
        }
    }
}

