/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.network;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import de.dafuqs.spectrum.blocks.pastel_network.network.NodeRemovalReason;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetworkManager;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelTransmission;
import de.dafuqs.spectrum.blocks.pastel_network.network.ServerPastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import de.dafuqs.spectrum.helpers.CodecHelper;
import de.dafuqs.spectrum.networking.s2c_payloads.PastelNetworkRemovedPayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class ServerPastelNetworkManager
extends class_18
implements PastelNetworkManager<class_3218, ServerPastelNetwork> {
    private static final String PERSISTENT_STATE_ID = "spectrum_pastel_network_manager";
    private final List<ServerPastelNetwork> networks = new ArrayList<ServerPastelNetwork>();

    public boolean method_79() {
        return true;
    }

    public static ServerPastelNetworkManager get(class_3218 world) {
        class_18.class_8645 type = new class_18.class_8645(ServerPastelNetworkManager::new, (nbtCompound, lookup) -> ServerPastelNetworkManager.fromNbt(nbtCompound), null);
        return (ServerPastelNetworkManager)world.method_17983().method_17924(type, PERSISTENT_STATE_ID);
    }

    public ServerPastelNetwork createNetwork(class_3218 world, PastelNodeBlockEntity initialNode) {
        ServerPastelNetwork network = new ServerPastelNetwork(world, initialNode);
        this.networks.add(network);
        initialNode.setNetworkUUID(network.getUUID());
        return network;
    }

    @Override
    public ServerPastelNetwork createNetwork(class_3218 world, UUID uuid, int color) {
        ServerPastelNetwork network = new ServerPastelNetwork(world, uuid, color);
        this.networks.add(network);
        return network;
    }

    @Override
    public Optional<ServerPastelNetwork> getNetwork(UUID uuid) {
        return this.networks.stream().filter(n -> n.uuid.equals(uuid)).findFirst();
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2499 networkList = new class_2499();
        for (ServerPastelNetwork network : this.networks) {
            Optional opt = ServerPastelNetwork.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)network).result();
            if (!opt.isPresent()) continue;
            class_2487 wrapper = new class_2487();
            wrapper.method_10566("network", (class_2520)opt.get());
            wrapper.method_10566("scheduler", (class_2520)ServerPastelNetworkManager.transgender(network.getTransmissions()));
            wrapper.method_10566("graph", (class_2520)network.graphToNbt());
            networkList.add((Object)wrapper);
        }
        nbt.method_10566("Networks", (class_2520)networkList);
        return nbt;
    }

    public static ServerPastelNetworkManager fromNbt(class_2487 nbt) {
        ServerPastelNetworkManager manager = new ServerPastelNetworkManager();
        for (class_2520 element : nbt.method_10554("Networks", 10)) {
            class_2487 comp = (class_2487)element;
            class_2520 netNbt = comp.method_10580("network");
            class_2487 schedulerNbt = comp.method_10562("scheduler");
            class_2487 graphNbt = comp.method_10562("graph");
            Optional<ServerPastelNetwork> network = CodecHelper.fromNbt(ServerPastelNetwork.CODEC, netNbt);
            if (!network.isPresent()) continue;
            network.get().getTransmissions().putAll(ServerPastelNetworkManager.transDecode(schedulerNbt, network.get()));
            network.get().setGraph(ServerPastelNetwork.graphFromNbt(graphNbt));
            manager.networks.add(network.get());
        }
        return manager;
    }

    @NotNull
    private static HashMap<PastelTransmission, Integer> transDecode(class_2487 schedulerNbt, ServerPastelNetwork network) {
        class_2499 transmissions = schedulerNbt.method_10554("transmissions", 10);
        int[] timers = schedulerNbt.method_10561("timers");
        HashMap<PastelTransmission, Integer> map = new HashMap<PastelTransmission, Integer>();
        for (int i = 0; i < transmissions.size(); ++i) {
            Optional result = PastelTransmission.CODEC.decode((DynamicOps)class_2509.field_11560, (Object)transmissions.method_10534(i)).result();
            if (result.isEmpty()) continue;
            PastelTransmission trans = (PastelTransmission)((Pair)result.get()).getFirst();
            trans.setNetwork(network);
            map.put(trans, timers[i]);
        }
        return map;
    }

    public void tick() {
        for (int i = 0; i < this.networks.size(); ++i) {
            this.networks.get(i).tick();
        }
    }

    private static class_2487 transgender(Map<PastelTransmission, Integer> trans) {
        class_2487 transNbt = new class_2487();
        class_2499 transmissions = new class_2499();
        int[] timers = new int[trans.size()];
        for (Map.Entry<PastelTransmission, Integer> transmissionEntry : trans.entrySet()) {
            Optional result = PastelTransmission.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)transmissionEntry.getKey()).result();
            if (!result.isPresent()) continue;
            transmissions.add((Object)((class_2520)result.get()));
            timers[transmissions.size() - 1] = transmissionEntry.getValue();
        }
        transNbt.method_10566("transmissions", (class_2520)transmissions);
        transNbt.method_10539("timers", timers);
        return transNbt;
    }

    @Override
    public void removeNetwork(UUID uuid) {
        ServerPastelNetwork foundNetwork = null;
        for (ServerPastelNetwork network : this.networks) {
            if (!network.uuid.equals(uuid)) continue;
            foundNetwork = network;
            break;
        }
        if (foundNetwork != null) {
            this.networks.remove(foundNetwork);
            PastelNetworkRemovedPayload.send(foundNetwork);
        }
    }

    public void removeNode(PastelNodeBlockEntity node, NodeRemovalReason reason) {
        Optional<ServerPastelNetwork> optional = node.getServerNetwork();
        if (optional.isPresent()) {
            ServerPastelNetwork network = optional.get();
            if (network.size() == 1) {
                this.removeNetwork(network.getUUID());
            } else {
                network.removeNode(node, reason);
            }
        }
    }
}

