/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pedestal;

import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.block.MultiblockCrafter;
import de.dafuqs.spectrum.api.block.PedestalVariant;
import de.dafuqs.spectrum.api.block.PlayerOwned;
import de.dafuqs.spectrum.api.item.GemstoneColor;
import de.dafuqs.spectrum.blocks.CraftingDelegate;
import de.dafuqs.spectrum.blocks.pedestal.BuiltinPedestalVariant;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlock;
import de.dafuqs.spectrum.blocks.pedestal.PedestalRecipeInput;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.inventories.PedestalScreenHandler;
import de.dafuqs.spectrum.items.magic_items.CraftingTabletItem;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayBlockBoundSoundInstancePayload;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayPedestalCraftingFinishedParticlePayload;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayPedestalUpgradedParticlePayload;
import de.dafuqs.spectrum.particle.effect.ColoredCraftingParticleEffect;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipe;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import de.dafuqs.spectrum.recipe.pedestal.ShapedPedestalRecipe;
import de.dafuqs.spectrum.recipe.pedestal.ShapelessPedestalRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1737;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2614;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class PedestalBlockEntity
extends class_2624
implements MultiblockCrafter,
class_1737,
class_1278,
ExtendedScreenHandlerFactory<PedestalScreenHandler.ScreenOpeningData> {
    public static final int INVENTORY_SIZE = 16;
    public static final int CRAFTING_TABLET_SLOT_ID = 14;
    public static final int OUTPUT_SLOT_ID = 15;
    private static final int[] ACCESSIBLE_SLOTS_UP = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] ACCESSIBLE_SLOTS_BASIC = new int[]{9, 10, 11};
    private static final int[] ACCESSIBLE_SLOTS_ADVANCED = new int[]{9, 10, 11, 12};
    private static final int[] ACCESSIBLE_SLOTS_COMPLEX = new int[]{9, 10, 11, 12, 13};
    protected UUID ownerUUID;
    protected PedestalVariant pedestalVariant;
    protected class_2371<class_1799> inventory;
    protected boolean shouldCraft;
    protected float storedXP;
    protected PedestalRecipeTier cachedMaxPedestalTier;
    protected long cachedMaxPedestalTierTick;
    protected Upgradeable.UpgradeHolder upgrades;
    protected boolean inventoryChanged;
    @Nullable
    public class_8786<?> currentRecipe;
    protected final CraftingDelegate propertyDelegate = new CraftingDelegate();

    public PedestalBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntities.PEDESTAL, blockPos, blockState);
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof PedestalBlock) {
            PedestalBlock pedestalBlock = (PedestalBlock)class_22482;
            this.pedestalVariant = pedestalBlock.getVariant();
        } else {
            this.pedestalVariant = BuiltinPedestalVariant.BASIC_AMETHYST;
        }
        this.inventory = class_2371.method_10213((int)16, (Object)class_1799.field_8037);
    }

    @Override
    public List<class_2382> getUpgradePosOffsets() {
        return PedestalBlock.UPGRADE_BLOCK_OFFSETS;
    }

    public void updateInClientWorld() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.field_11867);
        }
    }

    public static void clientTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, PedestalBlockEntity pedestalBlockEntity) {
        class_1860<?> currentRecipe = pedestalBlockEntity.getCurrentRecipe();
        if (currentRecipe instanceof PedestalRecipe) {
            PedestalRecipe pedestalRecipe = (PedestalRecipe)currentRecipe;
            Map<GemstoneColor, Integer> gemstonePowderInputs = pedestalRecipe.getPowderInputs();
            for (Map.Entry<GemstoneColor, Integer> entry : gemstonePowderInputs.entrySet()) {
                int amount = entry.getValue();
                if (amount <= 0) continue;
                class_2394 particleEffect = ColoredCraftingParticleEffect.of(entry.getKey().getColor());
                float particleAmount = Support.getIntFromDecimalWithChance((double)amount * 0.125, world.field_9229);
                int i = 0;
                while ((float)i < particleAmount) {
                    float randomX = 2.0f - world.method_8409().method_43057() * 5.0f;
                    float randomZ = 2.0f - world.method_8409().method_43057() * 5.0f;
                    world.method_8406(particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.03, 0.0);
                    ++i;
                }
            }
        }
    }

    public static void spawnCraftingStartParticles(@NotNull class_1937 world, class_2338 blockPos) {
        PedestalBlockEntity pedestalBlockEntity;
        class_1860<?> currentRecipe;
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity instanceof PedestalBlockEntity && (currentRecipe = (pedestalBlockEntity = (PedestalBlockEntity)blockEntity).getCurrentRecipe()) instanceof PedestalRecipe) {
            PedestalRecipe pedestalRecipe = (PedestalRecipe)currentRecipe;
            Map<GemstoneColor, Integer> gemstonePowderInputs = pedestalRecipe.getPowderInputs();
            for (Map.Entry<GemstoneColor, Integer> entry : gemstonePowderInputs.entrySet()) {
                int amount = entry.getValue();
                if (amount <= 0) continue;
                class_2394 particleEffect = ColoredCraftingParticleEffect.of(entry.getKey().getColor());
                amount *= 4;
                for (int i = 0; i < amount; ++i) {
                    class_2338 offsetPos;
                    class_2680 offsetState;
                    class_2350 direction = class_2350.method_10162((class_5819)world.field_9229);
                    if (direction == class_2350.field_11033 || (offsetState = world.method_8320(offsetPos = blockPos.method_10093(direction))).method_26206((class_1922)world, offsetPos, direction.method_10153())) continue;
                    double d = direction.method_10148() == 0 ? world.field_9229.method_43058() : 0.5 + (double)direction.method_10148() * 0.6;
                    double e = direction.method_10164() == 0 ? world.field_9229.method_43058() : 0.5 + (double)direction.method_10164() * 0.6;
                    double f = direction.method_10165() == 0 ? world.field_9229.method_43058() : 0.5 + (double)direction.method_10165() * 0.6;
                    world.method_8406(particleEffect, (double)blockPos.method_10263() + d, (double)blockPos.method_10264() + e, (double)blockPos.method_10260() + f, 0.0, 0.03, 0.0);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void serverTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, PedestalBlockEntity pedestalBlockEntity) {
        if (pedestalBlockEntity.upgrades == null) {
            pedestalBlockEntity.calculateUpgrades();
        }
        shouldMarkDirty = false;
        calculatedEntry = PedestalBlockEntity.calculateRecipe(world, pedestalBlockEntity);
        calculatedRecipe = calculatedEntry == null ? null : calculatedEntry.comp_1933();
        pedestalBlockEntity.inventoryChanged = false;
        if (pedestalBlockEntity.currentRecipe != calculatedEntry) {
            pedestalBlockEntity.shouldCraft = false;
            pedestalBlockEntity.currentRecipe = calculatedEntry;
            pedestalBlockEntity.propertyDelegate.craftingTime = 0;
            if (calculatedRecipe instanceof PedestalRecipe) {
                calculatedPedestalRecipe = (PedestalRecipe)calculatedRecipe;
                pedestalBlockEntity.propertyDelegate.craftingTimeTotal = (int)Math.ceil((float)calculatedPedestalRecipe.getCraftingTime() / pedestalBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.SPEED));
                player = pedestalBlockEntity.getOwnerIfOnline();
                if (player instanceof class_3222) {
                    serverPlayerEntity = (class_3222)player;
                    SpectrumAdvancementCriteria.PEDESTAL_RECIPE_CALCULATED.trigger(serverPlayerEntity, calculatedPedestalRecipe.assemble(pedestalBlockEntity.createRecipeInput(), (class_7225.class_7874)world.method_30349()), (int)calculatedPedestalRecipe.getExperience(), pedestalBlockEntity.propertyDelegate.craftingTimeTotal);
                }
            } else {
                pedestalBlockEntity.propertyDelegate.craftingTimeTotal = (int)Math.ceil((float)SpectrumCommon.CONFIG.VanillaRecipeCraftingTimeTicks / pedestalBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.SPEED));
            }
            pedestalBlockEntity.method_5431();
            PlayBlockBoundSoundInstancePayload.sendCancelBlockBoundSoundInstance((class_3218)pedestalBlockEntity.method_10997(), pedestalBlockEntity.method_11016());
            pedestalBlockEntity.updateInClientWorld();
        }
        if (!(pedestalBlockEntity.propertyDelegate.craftingTime != 0 || pedestalBlockEntity.shouldCraft || blockState.method_26204() instanceof PedestalBlock && ((Boolean)blockState.method_11654((class_2769)class_2741.field_12484)).booleanValue())) {
            return;
        }
        maxCountPerStack = pedestalBlockEntity.method_5444();
        craftingFinished = false;
        if (!(calculatedRecipe instanceof PedestalRecipe)) ** GOTO lbl-1000
        pedestalRecipe = (PedestalRecipe)calculatedRecipe;
        if (pedestalBlockEntity.canAcceptRecipeOutput(calculatedRecipe, pedestalBlockEntity.createRecipeInput(), maxCountPerStack)) {
            ++pedestalBlockEntity.propertyDelegate.craftingTime;
            if (pedestalBlockEntity.propertyDelegate.craftingTime == pedestalBlockEntity.propertyDelegate.craftingTimeTotal) {
                pedestalBlockEntity.propertyDelegate.craftingTime = 0;
                craftingFinished = PedestalBlockEntity.craftPedestalRecipe(pedestalBlockEntity, pedestalRecipe, (class_1263)pedestalBlockEntity, maxCountPerStack);
                if (craftingFinished) {
                    pedestalBlockEntity.inventoryChanged = true;
                }
                shouldMarkDirty = true;
            }
        } else if (calculatedRecipe instanceof class_3955) {
            vanillaCraftingRecipe = (class_3955)calculatedRecipe;
            if (pedestalBlockEntity.canAcceptRecipeOutput(calculatedRecipe, pedestalBlockEntity.createRecipeInput(), maxCountPerStack)) {
                ++pedestalBlockEntity.propertyDelegate.craftingTime;
                if (pedestalBlockEntity.propertyDelegate.craftingTime == pedestalBlockEntity.propertyDelegate.craftingTimeTotal) {
                    pedestalBlockEntity.propertyDelegate.craftingTime = 0;
                    craftingFinished = pedestalBlockEntity.craftVanillaRecipe(vanillaCraftingRecipe, pedestalBlockEntity, maxCountPerStack);
                    if (craftingFinished) {
                        PedestalBlockEntity.playCraftingFinishedSoundEvent(pedestalBlockEntity, calculatedRecipe);
                        pedestalBlockEntity.inventoryChanged = true;
                    }
                    shouldMarkDirty = true;
                }
            }
        }
        if (pedestalBlockEntity.propertyDelegate.craftingTime == 1 && pedestalBlockEntity.propertyDelegate.craftingTimeTotal > 1) {
            PlayBlockBoundSoundInstancePayload.sendPlayBlockBoundSoundInstance(SpectrumSoundEvents.PEDESTAL_CRAFTING, (class_3218)pedestalBlockEntity.method_10997(), pedestalBlockEntity.method_11016(), pedestalBlockEntity.propertyDelegate.craftingTimeTotal - pedestalBlockEntity.propertyDelegate.craftingTime);
        }
        if ((outputItemStack = (class_1799)pedestalBlockEntity.inventory.get(15)) != class_1799.field_8037) {
            if (world.method_8320(blockPos.method_10084()).method_26220((class_1922)world, blockPos.method_10084()).method_1110()) {
                PedestalBlockEntity.spawnOutputAsItemEntity((class_3218)world, blockPos, pedestalBlockEntity, outputItemStack);
            } else {
                couldOutput = false;
                belowBlockEntity = world.method_8321(blockPos.method_10074());
                if (belowBlockEntity instanceof class_1263) {
                    belowInventory = (class_1263)belowBlockEntity;
                    couldOutput = PedestalBlockEntity.tryPutIntoInventory(pedestalBlockEntity, belowInventory, outputItemStack);
                }
                if (!couldOutput && (aboveBlockEntity = world.method_8321(blockPos.method_10084())) instanceof class_1263) {
                    aboveInventory = (class_1263)aboveBlockEntity;
                    if (!(aboveBlockEntity instanceof class_2614)) {
                        couldOutput = PedestalBlockEntity.tryPutIntoInventory(pedestalBlockEntity, aboveInventory, outputItemStack);
                    }
                }
                if (couldOutput) {
                    shouldMarkDirty = true;
                } else if (craftingFinished) {
                    pedestalBlockEntity.playSound(class_3417.field_19198);
                }
            }
        }
        if (shouldMarkDirty) {
            PedestalBlockEntity.method_31663((class_1937)world, (class_2338)blockPos, (class_2680)blockState);
        }
    }

    @Contract(pure=true)
    public static PedestalVariant getVariant(@NotNull PedestalBlockEntity pedestalBlockEntity) {
        return pedestalBlockEntity.pedestalVariant;
    }

    public static void spawnOutputAsItemEntity(class_3218 world, class_2338 blockPos, @NotNull PedestalBlockEntity pedestalBlockEntity, class_1799 outputItemStack) {
        MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount((class_1937)world, pedestalBlockEntity.field_11867, outputItemStack, outputItemStack.method_7947(), new class_243(0.0, 0.1, 0.0));
        pedestalBlockEntity.inventory.set(15, (Object)class_1799.field_8037);
        MultiblockCrafter.spawnExperience((class_1937)world, pedestalBlockEntity.field_11867, pedestalBlockEntity.storedXP, world.field_9229);
        pedestalBlockEntity.storedXP = 0.0f;
        PlayPedestalCraftingFinishedParticlePayload.sendPlayPedestalCraftingFinishedParticle(world, blockPos, outputItemStack);
    }

    public static boolean tryPutIntoInventory(PedestalBlockEntity pedestalBlockEntity, class_1263 targetInventory, class_1799 outputItemStack) {
        class_1799 remainingStack = InventoryHelper.smartAddToInventory(outputItemStack, targetInventory, class_2350.field_11033);
        if (remainingStack.method_7960()) {
            pedestalBlockEntity.inventory.set(15, (Object)class_1799.field_8037);
            return true;
        }
        pedestalBlockEntity.inventory.set(15, (Object)remainingStack);
        return false;
    }

    public static void playCraftingFinishedSoundEvent(PedestalBlockEntity pedestalBlockEntity, class_1860<?> craftingRecipe) {
        class_1937 world = pedestalBlockEntity.method_10997();
        if (world != null && craftingRecipe instanceof PedestalRecipe) {
            PedestalRecipe pedestalRecipe = (PedestalRecipe)craftingRecipe;
            pedestalBlockEntity.playSound(pedestalRecipe.getSoundEvent(world.field_9229));
        } else {
            pedestalBlockEntity.playSound(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_GENERIC);
        }
    }

    @Nullable
    public static class_8786<?> calculateRecipe(class_1937 world, @NotNull PedestalBlockEntity pedestalBlockEntity) {
        class_3955 craftingRecipe;
        PedestalRecipe pedestalRecipe;
        class_1860<?> currentRecipe = pedestalBlockEntity.getCurrentRecipe();
        if (!pedestalBlockEntity.inventoryChanged) {
            return pedestalBlockEntity.currentRecipe;
        }
        if (currentRecipe instanceof PedestalRecipe && (pedestalRecipe = (PedestalRecipe)currentRecipe).matches(pedestalBlockEntity.createRecipeInput(), world)) {
            return pedestalBlockEntity.currentRecipe;
        }
        if (SpectrumCommon.CONFIG.canPedestalCraftVanillaRecipes() && currentRecipe instanceof class_3955 && (craftingRecipe = (class_3955)currentRecipe).method_8115((class_9695)pedestalBlockEntity.createRecipeInput().getCraftingGridInput(), world)) {
            return pedestalBlockEntity.currentRecipe;
        }
        @Nullable class_8786<?> craftingTabletRecipe = pedestalBlockEntity.getStoredCraftingTabletRecipe();
        class_8786 pedestalRecipe2 = world.method_8433().method_8132(SpectrumRecipeTypes.PEDESTAL, (class_9695)pedestalBlockEntity.createRecipeInput(), world).orElse(null);
        if (pedestalRecipe2 == null) {
            if (SpectrumCommon.CONFIG.canPedestalCraftVanillaRecipes()) {
                class_8786 holder = world.method_8433().method_8132(class_3956.field_17545, (class_9695)pedestalBlockEntity.createRecipeInput().getCraftingGridInput(), world).orElse(null);
                if (craftingTabletRecipe != null && !craftingTabletRecipe.equals((Object)holder)) {
                    return null;
                }
                return holder;
            }
            return null;
        }
        if (!((PedestalRecipe)pedestalRecipe2.comp_1933()).canCraft(pedestalBlockEntity)) {
            return null;
        }
        if (craftingTabletRecipe != null && !craftingTabletRecipe.equals((Object)pedestalRecipe2)) {
            return null;
        }
        return pedestalRecipe2;
    }

    private boolean canAcceptRecipeOutput(@Nullable class_1860<?> recipe, PedestalRecipeInput input, int maxCountPerStack) {
        if (recipe != null) {
            class_1799 output;
            if (recipe instanceof PedestalRecipe) {
                PedestalRecipe pedestalRecipe = (PedestalRecipe)recipe;
                output = pedestalRecipe.assemble(input, null);
            } else if (recipe instanceof class_3955) {
                class_3955 craftingRecipe = (class_3955)recipe;
                output = craftingRecipe.method_8116((class_9695)input.getCraftingGridInput(), null);
            } else {
                output = class_1799.field_8037;
            }
            if (output.method_7960()) {
                return false;
            }
            class_1799 existingOutput = this.method_5438(15);
            if (existingOutput.method_7960()) {
                return true;
            }
            if (!class_1799.method_31577((class_1799)existingOutput, (class_1799)output)) {
                return false;
            }
            if (existingOutput.method_7947() < maxCountPerStack && existingOutput.method_7947() < existingOutput.method_7914()) {
                return true;
            }
            return existingOutput.method_7947() < output.method_7914();
        }
        return false;
    }

    private static boolean craftPedestalRecipe(PedestalBlockEntity pedestalBlockEntity, @Nullable PedestalRecipe recipe, class_1263 inventory, int maxCountPerStack) {
        double yieldModifier;
        class_1937 world = pedestalBlockEntity.field_11863;
        if (world == null || !pedestalBlockEntity.canAcceptRecipeOutput(recipe, pedestalBlockEntity.createRecipeInput(), maxCountPerStack)) {
            return false;
        }
        class_1799 outputStack = recipe.assemble(pedestalBlockEntity.createRecipeInput(), (class_7225.class_7874)world.method_30349());
        recipe.consumeIngredients(pedestalBlockEntity);
        if (!recipe.areYieldUpgradesDisabled() && (yieldModifier = (double)pedestalBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.YIELD)) != 1.0) {
            int modifiedCount = Support.getIntFromDecimalWithChance((double)outputStack.method_7947() * yieldModifier, world.field_9229);
            outputStack.method_7939(Math.min(outputStack.method_7914(), modifiedCount));
        }
        float experience = recipe.getExperience() * pedestalBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.EXPERIENCE);
        pedestalBlockEntity.storedXP += experience;
        class_1657 player = pedestalBlockEntity.getOwnerIfOnline();
        if (player != null) {
            outputStack.method_7982(world, player, outputStack.method_7947());
        }
        pedestalBlockEntity.grantPlayerPedestalCraftingAdvancement(outputStack, (int)experience, pedestalBlockEntity.propertyDelegate.craftingTimeTotal);
        PedestalVariant newPedestalVariant = PedestalRecipe.getUpgradedPedestalVariantForOutput(outputStack);
        if (newPedestalVariant != null && newPedestalVariant.isBetterThan(PedestalBlockEntity.getVariant(pedestalBlockEntity))) {
            pedestalBlockEntity.playSound(SpectrumSoundEvents.PEDESTAL_UPGRADE);
            PedestalBlock.upgradeToVariant(world, pedestalBlockEntity.method_11016(), newPedestalVariant);
            PlayPedestalUpgradedParticlePayload.spawnPedestalUpgradeParticles(world, pedestalBlockEntity.field_11867, newPedestalVariant);
            pedestalBlockEntity.pedestalVariant = newPedestalVariant;
            pedestalBlockEntity.currentRecipe = null;
        } else {
            class_1799 existingOutput = inventory.method_5438(15);
            if (!existingOutput.method_7960()) {
                outputStack.method_7939(Math.min(existingOutput.method_7914(), existingOutput.method_7947() + outputStack.method_7947()));
            }
            inventory.method_5447(15, outputStack);
        }
        pedestalBlockEntity.method_5431();
        pedestalBlockEntity.inventoryChanged = true;
        pedestalBlockEntity.updateInClientWorld();
        return true;
    }

    public static class_1792 getGemstonePowderItemForSlot(int slot) {
        return switch (slot) {
            case 9 -> SpectrumItems.TOPAZ_POWDER;
            case 10 -> SpectrumItems.AMETHYST_POWDER;
            case 11 -> SpectrumItems.CITRINE_POWDER;
            case 12 -> SpectrumItems.ONYX_POWDER;
            case 13 -> SpectrumItems.MOONSTONE_POWDER;
            default -> class_1802.field_8162;
        };
    }

    /*
     * Exception decompiling
     */
    public static int getSlotForGemstonePowder(GemstoneColor gemstoneColor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=1,838
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setVariant(PedestalVariant pedestalVariant) {
        this.pedestalVariant = pedestalVariant;
    }

    public PedestalVariant getVariant() {
        return this.pedestalVariant;
    }

    public class_2561 method_17823() {
        return class_2561.method_43471((String)"block.spectrum.pedestal");
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> inventory) {
        this.inventory = inventory;
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new PedestalScreenHandler(syncId, playerInventory, this, this.propertyDelegate, this.getPedestalTier(), this.getHighestAvailableRecipeTier());
    }

    public PedestalScreenHandler.ScreenOpeningData getScreenOpeningData(class_3222 serverPlayerEntity) {
        return new PedestalScreenHandler.ScreenOpeningData(this.method_11016(), this.getPedestalTier(), this.getHighestAvailableRecipeTier());
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        class_1799 itemStack;
        Iterator var1 = this.inventory.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((itemStack = (class_1799)var1.next()).method_7960());
        return false;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 removedStack = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        this.inventoryChanged = true;
        this.method_5431();
        return removedStack;
    }

    public class_1799 method_5441(int slot) {
        class_1799 removedStack = class_1262.method_5428(this.inventory, (int)slot);
        this.inventoryChanged = true;
        this.method_5431();
        return removedStack;
    }

    public void method_5447(int slot, @NotNull class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.inventoryChanged = true;
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863 == null || this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_7683(class_1662 recipeMatcher) {
        for (class_1799 itemStack : this.inventory) {
            recipeMatcher.method_7400(itemStack);
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = new class_2487();
        this.method_11007(nbtCompound, registryLookup);
        return nbtCompound;
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.inventory = class_2371.method_10213((int)16, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        if (nbt.method_10545("StoredXP")) {
            this.storedXP = nbt.method_10583("StoredXP");
        }
        if (nbt.method_10545("CraftingTime")) {
            this.propertyDelegate.craftingTime = nbt.method_10568("CraftingTime");
        }
        if (nbt.method_10545("CraftingTimeTotal")) {
            this.propertyDelegate.craftingTimeTotal = nbt.method_10568("CraftingTimeTotal");
        }
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.upgrades = nbt.method_10573("Upgrades", 9) ? Upgradeable.UpgradeHolder.fromNbt(nbt.method_10554("Upgrades", 10)) : new Upgradeable.UpgradeHolder();
        if (nbt.method_10545("inventory_changed")) {
            this.inventoryChanged = nbt.method_10577("inventory_changed");
        }
        this.currentRecipe = null;
        this.currentRecipe = MultiblockCrafter.getRecipeHolderFromNbt(this.field_11863, nbt);
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10548("StoredXP", this.storedXP);
        nbt.method_10575("CraftingTime", (short)this.propertyDelegate.craftingTime);
        nbt.method_10575("CraftingTimeTotal", (short)this.propertyDelegate.craftingTimeTotal);
        nbt.method_10556("inventory_changed", this.inventoryChanged);
        if (this.upgrades != null) {
            nbt.method_10566("Upgrades", (class_2520)this.upgrades.toNbt());
        }
        if (this.currentRecipe != null) {
            nbt.method_10582("CurrentRecipe", this.currentRecipe.comp_1932().toString());
        }
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public boolean isCrafting() {
        return this.propertyDelegate.craftingTime > 0;
    }

    private void playSound(class_3414 soundEvent) {
        if (this.field_11863 == null) {
            return;
        }
        this.field_11863.method_43128(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), soundEvent, class_3419.field_15245, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f, 0.9f + this.field_11863.field_9229.method_43057() * 0.15f);
    }

    private boolean craftVanillaRecipe(@Nullable class_3955 recipe, PedestalBlockEntity pedestal, int maxCountPerStack) {
        if (this.canAcceptRecipeOutput((class_1860<?>)recipe, this.createRecipeInput(), maxCountPerStack)) {
            class_1799 recipeOutput = recipe.method_8116((class_9695)this.createRecipeInput().getCraftingGridInput(), (class_7225.class_7874)pedestal.method_10997().method_30349());
            class_1657 player = this.getOwnerIfOnline();
            if (player == null) {
                recipeOutput.method_54466(this.method_10997());
            } else {
                recipeOutput.method_7982(this.method_10997(), player, recipeOutput.method_7947());
            }
            this.decrementInputStacks((class_1263)pedestal);
            class_1799 existingOutput = pedestal.method_5438(15);
            if (existingOutput.method_7960()) {
                pedestal.method_5447(15, recipeOutput.method_7972());
            } else {
                existingOutput.method_7933(recipeOutput.method_7947());
                pedestal.method_5447(15, existingOutput);
            }
            return true;
        }
        return false;
    }

    private void decrementInputStacks(class_1263 inventory) {
        if (this.field_11863 == null) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            class_1799 remainder = itemStack.getRecipeRemainder();
            if (remainder.method_7960()) {
                itemStack.method_7934(1);
                continue;
            }
            if (((class_1799)this.inventory.get(i)).method_7947() == 1) {
                this.inventory.set(i, (Object)remainder);
                continue;
            }
            ((class_1799)this.inventory.get(i)).method_7934(1);
            class_1542 itemEntity = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260() + 0.5, remainder);
            itemEntity.method_5762(0.0, 0.05, 0.0);
            this.field_11863.method_8649((class_1297)itemEntity);
        }
    }

    private void grantPlayerPedestalCraftingAdvancement(class_1799 output, int experience, int duration) {
        class_3222 serverPlayerEntity = (class_3222)this.getOwnerIfOnline();
        if (serverPlayerEntity != null) {
            SpectrumAdvancementCriteria.PEDESTAL_CRAFTING.trigger(serverPlayerEntity, output, experience, duration);
        }
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot < 9) {
            return true;
        }
        if (slot == 14 && stack.method_31574(SpectrumItems.CRAFTING_TABLET)) {
            return true;
        }
        return stack.method_31574(PedestalBlockEntity.getGemstonePowderItemForSlot(slot));
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return new int[]{15};
        }
        if (side == class_2350.field_11036) {
            return ACCESSIBLE_SLOTS_UP;
        }
        switch (this.pedestalVariant.getRecipeTier()) {
            case COMPLEX: {
                return ACCESSIBLE_SLOTS_COMPLEX;
            }
            case ADVANCED: {
                return ACCESSIBLE_SLOTS_ADVANCED;
            }
        }
        return ACCESSIBLE_SLOTS_BASIC;
    }

    public boolean method_5492(int slot, @NotNull class_1799 stack, @Nullable class_2350 dir) {
        if (stack.method_31574(PedestalBlockEntity.getGemstonePowderItemForSlot(slot))) {
            return true;
        }
        if (slot < 9 && this.hasCraftingTablet()) {
            ShapedPedestalRecipe pedestalRecipe;
            class_1869 shapedRecipe;
            class_8786<?> holder = this.getStoredCraftingTabletRecipe();
            if (holder == null) {
                return false;
            }
            class_1860 storedRecipe = holder.comp_1933();
            int width = 3;
            if (storedRecipe instanceof class_1869 ? slot % 3 >= (width = (shapedRecipe = (class_1869)storedRecipe).method_8150()) : (storedRecipe instanceof ShapedPedestalRecipe ? slot % 3 >= (width = (pedestalRecipe = (ShapedPedestalRecipe)storedRecipe).getWidth()) : !(storedRecipe instanceof class_1867) && !(storedRecipe instanceof ShapelessPedestalRecipe))) {
                return false;
            }
            int resultRecipeSlot = this.getCraftingRecipeSlotDependingOnWidth(slot, width);
            if (resultRecipeSlot < storedRecipe.method_8117().size()) {
                class_1856 ingredient = (class_1856)storedRecipe.method_8117().get(resultRecipeSlot);
                return ingredient.method_8093(stack);
            }
            return false;
        }
        return slot < 14;
    }

    private boolean hasCraftingTablet() {
        return ((class_1799)this.inventory.get(14)).method_7947() > 0;
    }

    @Nullable
    private class_8786<?> getStoredCraftingTabletRecipe() {
        class_1799 craftingTabletItem = (class_1799)this.inventory.get(14);
        return CraftingTabletItem.getStoredRecipe(this.method_10997(), craftingTabletItem);
    }

    private int getCraftingRecipeSlotDependingOnWidth(int slot, int recipeWidth) {
        int line = slot / 3;
        int posInLine = slot % 3;
        return line * recipeWidth + posInLine;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 15;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Nullable
    public class_1860<?> getCurrentRecipe() {
        return this.currentRecipe == null ? null : this.currentRecipe.comp_1933();
    }

    public PedestalRecipeInput createRecipeInput() {
        return PedestalRecipeInput.create(this.inventory, this.getOwnerIfOnline());
    }

    public class_9694.class_9765 createPositionedInput() {
        return class_9694.method_60505((int)3, (int)3, this.inventory);
    }

    public class_1799 getCurrentCraftingRecipeOutput() {
        class_1860<?> currentRecipe = this.getCurrentRecipe();
        if (this.field_11863 == null || currentRecipe == null) {
            return class_1799.field_8037;
        }
        if (currentRecipe instanceof PedestalRecipe) {
            PedestalRecipe pedestalRecipe = (PedestalRecipe)currentRecipe;
            return pedestalRecipe.assemble(this.createRecipeInput(), (class_7225.class_7874)this.field_11863.method_30349());
        }
        if (currentRecipe instanceof class_3955) {
            class_3955 craftingRecipe = (class_3955)currentRecipe;
            return craftingRecipe.method_8116((class_9695)this.createRecipeInput().getCraftingGridInput(), null);
        }
        return class_1799.field_8037;
    }

    public PedestalRecipeTier getHighestAvailableRecipeTier() {
        PedestalRecipeTier denominator;
        if (this.field_11863 == null || this.field_11863.method_8510() <= this.cachedMaxPedestalTierTick + 20L) {
            return this.cachedMaxPedestalTier;
        }
        PedestalRecipeTier pedestalTier = this.getPedestalTier();
        PedestalRecipeTier structureTier = this.getStructureTier();
        this.cachedMaxPedestalTier = denominator = PedestalRecipeTier.values()[Math.min(pedestalTier.ordinal(), structureTier.ordinal())];
        this.cachedMaxPedestalTierTick = this.field_11863.method_8510();
        return denominator;
    }

    private PedestalRecipeTier getPedestalTier() {
        return this.pedestalVariant.getRecipeTier();
    }

    @NotNull
    private PedestalRecipeTier getStructureTier() {
        Multiblock multiblock = SpectrumMultiblocks.get(SpectrumMultiblocks.PEDESTAL_COMPLEX);
        if (multiblock.validate(this.field_11863, this.field_11867.method_10074(), class_2470.field_11467)) {
            SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger((class_3222)this.getOwnerIfOnline(), multiblock);
            return PedestalRecipeTier.COMPLEX;
        }
        multiblock = SpectrumMultiblocks.get(SpectrumMultiblocks.PEDESTAL_COMPLEX_WITHOUT_MOONSTONE);
        if (multiblock.validate(this.field_11863, this.field_11867.method_10074(), class_2470.field_11467)) {
            SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger((class_3222)this.getOwnerIfOnline(), multiblock);
            return PedestalRecipeTier.ADVANCED;
        }
        multiblock = SpectrumMultiblocks.get(SpectrumMultiblocks.PEDESTAL_ADVANCED);
        if (multiblock.validate(this.field_11863, this.field_11867.method_10074(), class_2470.field_11467)) {
            SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger((class_3222)this.getOwnerIfOnline(), multiblock);
            return PedestalRecipeTier.ADVANCED;
        }
        multiblock = SpectrumMultiblocks.get(SpectrumMultiblocks.PEDESTAL_SIMPLE);
        if (multiblock.validate(this.field_11863, this.field_11867.method_10074(), class_2470.field_11467)) {
            SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger((class_3222)this.getOwnerIfOnline(), multiblock);
            return PedestalRecipeTier.SIMPLE;
        }
        return PedestalRecipeTier.BASIC;
    }

    @Override
    public void resetUpgrades() {
        this.upgrades = null;
        this.method_5431();
    }

    @Override
    public void calculateUpgrades() {
        this.upgrades = Upgradeable.calculateUpgradeMods4(this.field_11863, this.field_11867, 3, 2, this.ownerUUID);
        this.method_5431();
    }

    @Override
    public Upgradeable.UpgradeHolder getUpgradeHolder() {
        return this.upgrades;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
        this.method_5431();
    }

    public void setInventoryChanged() {
        this.inventoryChanged = true;
    }
}

