/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.titration_barrel;

import de.dafuqs.spectrum.api.block.FluidStackInventory;
import de.dafuqs.spectrum.blocks.titration_barrel.TitrationBarrelBlock;
import de.dafuqs.spectrum.helpers.CodecHelper;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.mixin.accessors.BiomeAccessor;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.StorageRecipeInput;
import de.dafuqs.spectrum.recipe.titration_barrel.ITitrationBarrelRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TitrationBarrelBlockEntity
extends class_2586
implements FluidStackInventory {
    protected static final int INVENTORY_SIZE = 5;
    public static final int MAX_ITEM_COUNT = 64;
    protected class_2371<class_1799> items;
    protected SingleVariantStorage<FluidVariant> fluidStorage = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return 81000L;
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            TitrationBarrelBlockEntity.this.inventoryChanged();
        }
    };
    protected long sealTime = -1L;
    protected long tapTime = -1L;
    protected String recipe;
    protected int extractedBottles = 0;

    @Override
    public class_2371<class_1799> getItems() {
        return this.items;
    }

    @Override
    public SingleVariantStorage<FluidVariant> getFluidStorage() {
        return this.fluidStorage;
    }

    public TitrationBarrelBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.TITRATION_BARREL, pos, state);
        this.items = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, this.items, (class_7225.class_7874)registryLookup);
        CodecHelper.writeNbt(nbt, "FluidVariant", FluidVariant.CODEC, (FluidVariant)this.fluidStorage.variant);
        nbt.method_10544("FluidAmount", this.fluidStorage.amount);
        nbt.method_10544("SealTime", this.sealTime);
        nbt.method_10544("TapTime", this.tapTime);
        nbt.method_10569("ExtractedBottles", this.extractedBottles);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.items = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.items, (class_7225.class_7874)registryLookup);
        this.fluidStorage.variant = (TransferVariant)CodecHelper.fromNbt(FluidVariant.CODEC, nbt.method_10580("FluidVariant"), FluidVariant.blank());
        this.fluidStorage.amount = nbt.method_10537("FluidAmount");
        this.sealTime = nbt.method_10573("SealTime", 4) ? nbt.method_10537("SealTime") : -1L;
        this.tapTime = nbt.method_10573("TapTime", 4) ? nbt.method_10537("TapTime") : -1L;
        this.extractedBottles = nbt.method_10573("ExtractedBottles", 99) ? nbt.method_10550("ExtractedBottles") : 0;
    }

    public void seal() {
        this.sealTime = new Date().getTime();
        this.method_5431();
    }

    public void tap() {
        this.tapTime = new Date().getTime();
        this.method_5431();
    }

    public void reset(class_1937 world, class_2338 blockPos, class_2680 state) {
        this.sealTime = -1L;
        this.tapTime = -1L;
        this.fluidStorage.variant = FluidVariant.blank();
        this.fluidStorage.amount = 0L;
        this.extractedBottles = 0;
        this.getItems().clear();
        world.method_8501(this.field_11867, (class_2680)state.method_11657(TitrationBarrelBlock.BARREL_STATE, (Comparable)((Object)TitrationBarrelBlock.BarrelState.EMPTY)));
        world.method_8396(null, blockPos, class_3417.field_17604, class_3419.field_15245, 1.0f, 1.0f);
        this.method_5431();
    }

    public long getSealMilliseconds() {
        if (this.sealTime == -1L) {
            return 0L;
        }
        long tapTime = this.tapTime == -1L ? new Date().getTime() : this.tapTime;
        return tapTime - this.sealTime;
    }

    public long getSealSeconds() {
        return this.getSealMilliseconds() / 1000L;
    }

    public int getSealMinecraftDays() {
        return (int)(this.getSealMilliseconds() / 1000L / 60L / 20L);
    }

    public String getSealRealDays() {
        return Support.getWithOneDecimalAfterComma((float)this.getSealMilliseconds() / 1000.0f / 60.0f / 20.0f / 72.0f);
    }

    private boolean isEmpty(float temperature, int extractedBottles, ITitrationBarrelRecipe recipe) {
        if (this.field_11863 == null || !recipe.getFluidInput().test(this.getFluidVariant())) {
            return true;
        }
        return extractedBottles >= recipe.getOutputCountAfterAngelsShare(this.field_11863, temperature, this.getSealSeconds());
    }

    public void addOneDayOfSealTime() {
        this.sealTime -= 86400000L;
        this.method_5431();
    }

    public class_1799 tryHarvest(class_1937 world, class_2338 blockPos, class_2680 blockState, class_1799 handStack, @Nullable class_1657 player) {
        class_1799 harvestedStack = class_1799.field_8037;
        class_1959 biome = (class_1959)world.method_23753(blockPos).comp_349();
        boolean shouldReset = false;
        class_5250 message = null;
        int daysSealed = this.getSealMinecraftDays();
        int inventoryCount = InventoryHelper.countItemsInInventory(this.getItems());
        Optional<class_8786<ITitrationBarrelRecipe>> optionalRecipe = this.getRecipeForInventory(world);
        if (optionalRecipe.isEmpty()) {
            message = this.getItems().isEmpty() && this.getFluidVariant().isBlank() ? class_2561.method_43471((String)"block.spectrum.titration_barrel.empty_when_tapping") : class_2561.method_43471((String)"block.spectrum.titration_barrel.invalid_recipe_when_tapping");
            shouldReset = true;
        } else {
            ITitrationBarrelRecipe recipe = (ITitrationBarrelRecipe)optionalRecipe.get().comp_1933();
            long secondsFermented = (this.tapTime - this.sealTime) / 1000L;
            int output = recipe.getOutputCountAfterAngelsShare(world, biome.method_8712(), secondsFermented);
            if (recipe.getFluidInput().test(this.getFluidVariant())) {
                if (recipe.canPlayerCraft(player)) {
                    boolean canTap = true;
                    class_1792 tappingItem = recipe.getTappingItem();
                    if (tappingItem != class_1802.field_8162) {
                        if (handStack.method_31574(tappingItem)) {
                            output = Math.min(output, handStack.method_7947());
                            handStack.method_7934(output);
                        } else {
                            message = class_2561.method_43471((String)"block.spectrum.titration_barrel.tapping_item_required").method_10852(tappingItem.method_7848());
                            canTap = false;
                        }
                    }
                    if (canTap) {
                        float downfall = ((BiomeAccessor)biome).getClimateSettings().comp_846();
                        harvestedStack = recipe.getTitrationResult(this, secondsFermented, downfall);
                        harvestedStack.method_7939(output);
                        this.extractedBottles += output;
                        shouldReset = this.isEmpty(biome.method_8712(), this.extractedBottles, recipe);
                    }
                } else {
                    message = class_2561.method_43471((String)"block.spectrum.titration_barrel.recipe_not_unlocked");
                }
            } else {
                message = this.getFluidVariant().isBlank() ? class_2561.method_43471((String)"block.spectrum.titration_barrel.missing_liquid_when_tapping") : class_2561.method_43471((String)"block.spectrum.titration_barrel.invalid_recipe_when_tapping");
                shouldReset = true;
            }
        }
        if (player != null) {
            SpectrumAdvancementCriteria.TITRATION_BARREL_TAPPING.trigger((class_3222)player, harvestedStack, daysSealed, inventoryCount);
            player.method_7353((class_2561)message, true);
        }
        if (shouldReset) {
            this.reset(world, blockPos, blockState);
        }
        this.method_5431();
        return harvestedStack;
    }

    public Optional<class_8786<ITitrationBarrelRecipe>> getRecipeForInventory(class_1937 world) {
        return world.method_8433().method_8132(SpectrumRecipeTypes.TITRATION_BARREL, this.getRecipeInput(), world);
    }

    public StorageRecipeInput<SingleVariantStorage<FluidVariant>> getRecipeInput() {
        return new StorageRecipeInput<SingleVariantStorage<FluidVariant>>((List<class_1799>)this.items, this.fluidStorage);
    }

    public void giveRecipeRemainders(@Nullable class_1657 player) {
        for (class_1799 stack : this.getItems()) {
            class_1799 remainder = stack.getRecipeRemainder();
            if (remainder.method_7960()) continue;
            if (player == null) {
                TitrationBarrelBlock.method_9577((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_1799)remainder);
                continue;
            }
            player.method_31548().method_7398(remainder);
        }
    }

    @NotNull
    public FluidVariant getFluidVariant() {
        if (this.fluidStorage.amount > 0L) {
            return (FluidVariant)this.fluidStorage.variant;
        }
        return FluidVariant.blank();
    }

    public boolean canBeSealed(@Nullable class_1657 player) {
        int itemCount = InventoryHelper.countItemsInInventory(this.getItems());
        class_3611 fluid = ((FluidVariant)this.fluidStorage.variant).getFluid();
        if (itemCount == 0 && fluid == class_3612.field_15906) {
            return true;
        }
        if (this.field_11863 != null) {
            Optional<class_8786<ITitrationBarrelRecipe>> optionalRecipe = this.getRecipeForInventory(this.field_11863);
            return optionalRecipe.isPresent() && (player == null || ((ITitrationBarrelRecipe)optionalRecipe.get().comp_1933()).canPlayerCraft(player)) && ((ITitrationBarrelRecipe)optionalRecipe.get().comp_1933()).getFluidInput().test(this.getFluidVariant().getFluid());
        }
        return false;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return this.sealTime == -1L;
    }

    public boolean method_49104(class_1263 target, int slot, class_1799 stack) {
        return this.sealTime == -1L;
    }
}

