/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.upgrade;

import com.mojang.serialization.MapCodec;
import de.dafuqs.spectrum.blocks.upgrade.UpgradeBlockEntity;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.networking.s2c_payloads.ColorTransmissionPayload;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import de.dafuqs.spectrum.particle.effect.ColoredSparkleRisingParticleEffect;
import de.dafuqs.spectrum.particle.effect.ColoredTransmission;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5707;
import net.minecraft.class_5716;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeBlock
extends class_2237 {
    protected static final class_265 SHAPE_UP = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    private static final List<class_2248> upgradeBlocks = new ArrayList<class_2248>();
    private final Upgradeable.UpgradeType upgradeType;
    private final int upgradeMod;
    private final int effectColor;

    public UpgradeBlock(class_4970.class_2251 settings, Upgradeable.UpgradeType upgradeType, int upgradeMod, int effectColor) {
        super(settings);
        this.upgradeType = upgradeType;
        this.upgradeMod = upgradeMod;
        this.effectColor = effectColor;
        upgradeBlocks.add((class_2248)this);
    }

    public MapCodec<? extends UpgradeBlock> method_53969() {
        return null;
    }

    public static List<class_2248> getUpgradeBlocks() {
        return upgradeBlocks;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE_UP;
    }

    public boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        if (!world.field_9236) {
            this.updateConnectedUpgradeBlock((class_3218)world, pos);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        if (!world.field_9236) {
            this.updateConnectedUpgradeBlock((class_3218)world, pos);
        }
    }

    private void updateConnectedUpgradeBlock(@NotNull class_3218 world, @NotNull class_2338 pos) {
        for (class_2382 possibleUpgradeBlockOffset : Upgradeable.POSSIBLE_UPGRADE_POS_OFFSETS) {
            Upgradeable upgradeable;
            class_2338 currentPos = pos.method_10081(possibleUpgradeBlockOffset);
            class_2586 blockEntity = world.method_8321(currentPos);
            if (!(blockEntity instanceof Upgradeable) || !(upgradeable = (Upgradeable)blockEntity).getUpgradePosOffsets().contains(possibleUpgradeBlockOffset)) continue;
            upgradeable.resetUpgrades();
            this.playConnectedParticles(world, pos, currentPos);
        }
    }

    private void playConnectedParticles(@NotNull class_3218 world, @NotNull class_2338 pos, class_2338 currentPos) {
        int particleColor = this.getEffectColor();
        world.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, SpectrumSoundEvents.CRAFTING_DING, class_3419.field_15245, 1.0f, 1.0f);
        PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, class_243.method_24953((class_2382)pos), ColoredSparkleRisingParticleEffect.of(particleColor), 10, new class_243(0.5, 0.5, 0.5), new class_243(0.1, 0.1, 0.1));
        ColorTransmissionPayload.playColorTransmissionParticle(world, new ColoredTransmission(new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5), (class_5716)new class_5707(currentPos), 6, particleColor));
    }

    private int getEffectColor() {
        return this.effectColor;
    }

    public Upgradeable.UpgradeType getUpgradeType() {
        return this.upgradeType;
    }

    public int getUpgradeMod() {
        return this.upgradeMod;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new UpgradeBlockEntity(pos, state);
    }
}

