/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.REI.plugins;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.compat.REI.SpectrumPlugins;
import de.dafuqs.spectrum.compat.REI.plugins.EnchanterDisplay;
import de.dafuqs.spectrum.items.magic_items.KnowledgeGemItem;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.RecipeScaling;
import de.dafuqs.spectrum.recipe.enchanter.EnchanterRecipe;
import de.dafuqs.spectrum.recipe.enchanter.EnchantmentUpgradeRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6880;
import net.minecraft.class_8786;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class EnchantmentUpgradeDisplay
extends EnchanterDisplay {
    protected final class_6880<class_1887> enchantment;
    final int enchantMaxLevel;
    final int recipeMaxLevel;
    final class_2561 transKey;
    final RecipeScaling.ScalingData itemScaling;
    final RecipeScaling.ScalingData xpScaling;
    int index = 0;

    public EnchantmentUpgradeDisplay(@NotNull class_8786<EnchantmentUpgradeRecipe> recipeEntry) {
        super((class_8786<? extends GatedSpectrumRecipe<?>>)recipeEntry, EnchantmentUpgradeDisplay.buildIngredients((EnchantmentUpgradeRecipe)recipeEntry.comp_1933()), EnchantmentUpgradeDisplay.buildOutputs((EnchantmentUpgradeRecipe)recipeEntry.comp_1933()));
        EnchantmentUpgradeRecipe recipe = (EnchantmentUpgradeRecipe)recipeEntry.comp_1933();
        this.enchantment = recipe.getEnchantment();
        this.enchantMaxLevel = ((class_1887)this.enchantment.comp_349()).method_8183();
        this.recipeMaxLevel = recipe.getLevelCap();
        this.itemScaling = recipe.getItemScaling();
        this.xpScaling = recipe.getXPScaling();
        this.transKey = ((class_1887)this.enchantment.comp_349()).comp_2686().method_27661().method_27694(s -> {
            s.method_10978(Boolean.valueOf(true));
            s.method_36139(5060181);
            return s;
        });
    }

    private static List<EntryIngredient> buildIngredients(EnchantmentUpgradeRecipe recipe) {
        ArrayList<EntryIngredient> inputs = new ArrayList<EntryIngredient>();
        class_6880<class_1887> enchant = recipe.getEnchantment();
        int levelCap = recipe.getLevelCap();
        ArrayList<class_1799> knowledgeGem = new ArrayList<class_1799>();
        ArrayList<class_1799> enchantedBooks = new ArrayList<class_1799>();
        for (int i = 0; i < 8; ++i) {
            inputs.add(EntryIngredients.of((class_1935)recipe.getBulkItem(), (int)1));
        }
        for (int level = 1; level < levelCap; ++level) {
            knowledgeGem.add(KnowledgeGemItem.getKnowledgeDropStackWithXP(recipe.getXPScaling().apply(level), true));
            enchantedBooks.add(EnchantmentUpgradeDisplay.getEnchantedBookStackWith(enchant, level));
        }
        inputs.add(EntryIngredients.ofItemStacks(knowledgeGem));
        inputs.add(EntryIngredients.ofItemStacks(enchantedBooks));
        return inputs;
    }

    private static List<EntryIngredient> buildOutputs(EnchantmentUpgradeRecipe recipe) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        int levelCap = recipe.getLevelCap();
        for (int level = 1; level < levelCap; ++level) {
            stacks.add(EnchantmentUpgradeDisplay.getEnchantedBookStackWith(recipe.getEnchantment(), level + 1));
        }
        return Collections.singletonList(EntryIngredients.ofItemStacks(stacks));
    }

    private static class_1799 getEnchantedBookStackWith(class_6880<class_1887> enchant, int level) {
        class_1799 enchStack = new class_1799((class_1935)class_1802.field_8598);
        class_9304.class_9305 builder = new class_9304.class_9305(class_9304.field_49385);
        builder.method_57547(enchant, level);
        enchStack.method_57379(class_9334.field_49643, (Object)builder.method_57549());
        return enchStack;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return SpectrumPlugins.ENCHANTMENT_UPGRADE;
    }

    @Override
    public boolean isUnlocked() {
        class_310 client = class_310.method_1551();
        return AdvancementHelper.hasAdvancement((class_1657)client.field_1724, (class_2960)EnchanterRecipe.UNLOCK_IDENTIFIER) && super.isUnlocked();
    }
}

