/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.emi.recipes;

import com.google.common.collect.Lists;
import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.compat.emi.GatedSpectrumEmiRecipe;
import de.dafuqs.spectrum.compat.emi.widgets.DynamicStackWidget;
import de.dafuqs.spectrum.compat.emi.widgets.DynamicTextWidget;
import de.dafuqs.spectrum.compat.emi.widgets.SaneButtonWidget;
import de.dafuqs.spectrum.items.magic_items.KnowledgeGemItem;
import de.dafuqs.spectrum.recipe.RecipeScaling;
import de.dafuqs.spectrum.recipe.enchanter.EnchantmentUpgradeRecipe;
import de.dafuqs.spectrum.registries.SpectrumAdvancements;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_6880;
import net.minecraft.class_8786;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class EnchantmentUpgradeEmiRecipeGated
extends GatedSpectrumEmiRecipe<EnchantmentUpgradeRecipe> {
    private static final class_2960 BACKGROUND_TEXTURE = SpectrumCommon.locate("textures/gui/container/enchanter.png");
    private static final int NORMAL_COLOR = 5060181;
    private static final int OVERCHANT_COLOR = 14366052;
    private static final int BOOK_INDEXES_START = 9;
    private final class_2561 transKey;
    private final int levelCap;
    private final int maxNormal;
    private final RecipeScaling.ScalingData itemScaling = ((EnchantmentUpgradeRecipe)this.recipe).getItemScaling();
    private final RecipeScaling.ScalingData xpScaling = ((EnchantmentUpgradeRecipe)this.recipe).getXPScaling();
    private int indexer = 1;

    public EnchantmentUpgradeEmiRecipeGated(EmiRecipeCategory category, class_8786<EnchantmentUpgradeRecipe> entry) {
        super(category, entry, 132, 90);
        int i;
        this.inputs = Lists.newArrayList();
        class_6880<class_1887> enchant = ((EnchantmentUpgradeRecipe)this.recipe).getEnchantment();
        this.levelCap = ((EnchantmentUpgradeRecipe)this.recipe).getLevelCap();
        this.maxNormal = ((class_1887)enchant.comp_349()).method_8183();
        this.transKey = ((class_1887)enchant.comp_349()).comp_2686().method_27661().method_27694(s -> s.method_10978(Boolean.valueOf(true)));
        for (i = 0; i < 8; ++i) {
            this.inputs.add(EmiStack.of((class_1935)((EnchantmentUpgradeRecipe)this.recipe).getBulkItem(), (long)1L));
        }
        this.inputs.add(EmiStack.of((class_1799)KnowledgeGemItem.getKnowledgeDropStackWithXP(((EnchantmentUpgradeRecipe)this.recipe).getBaseXPCost(), true)));
        this.outputs = new ArrayList();
        for (i = 1; i <= this.levelCap; ++i) {
            class_1799 enchStack = new class_1799((class_1935)class_1802.field_8598);
            class_9304.class_9305 builder = new class_9304.class_9305(class_9304.field_49385);
            builder.method_57547(enchant, i);
            enchStack.method_57379(class_9334.field_49643, (Object)builder.method_57549());
            this.inputs.add(EmiStack.of((class_1799)enchStack.method_7972()));
            if (i <= 1) continue;
            enchStack.method_57379(class_9334.field_49643, (Object)builder.method_57549());
            this.outputs.add(EmiStack.of((class_1799)enchStack));
        }
    }

    @Override
    public void addUnlockedWidgets(WidgetHolder widgets) {
        boolean overEnchant = AdvancementHelper.hasAdvancement((class_1657)class_310.method_1551().field_1724, (class_2960)SpectrumAdvancements.OVERENCHANTING);
        this.indexer = 1;
        widgets.addTexture(BACKGROUND_TEXTURE, 13, 13, 54, 54, 0, 0);
        if (overEnchant && this.levelCap > this.maxNormal) {
            widgets.addTexture(BACKGROUND_TEXTURE, 0, 0, 16, 16, 64, 0).tooltipText(List.of(class_2561.method_43471((String)"container.spectrum.rei.enchantment_upgrade.tooltip").method_27694(s -> s.method_36139(14366052))));
        }
        DynamicStackWidget gem = new DynamicStackWidget(c -> {
            int xp = this.xpScaling.apply(this.indexer);
            return EmiStack.of((class_1799)KnowledgeGemItem.getKnowledgeDropStackWithXP(xp, false));
        }, 0, 111, 5);
        widgets.add((Widget)gem);
        widgets.addSlot((EmiIngredient)EmiStack.of((class_1935)SpectrumBlocks.ENCHANTER), 111, 51).drawBack(false);
        int cap = overEnchant ? this.levelCap : this.maxNormal;
        SaneButtonWidget minus = (SaneButtonWidget)((Object)new SaneButtonWidget(84, 18, 8, 8, 64, 16, BACKGROUND_TEXTURE, () -> false, (mX, mY, b) -> {
            this.indexer = Math.clamp((long)(this.indexer - 1), 1, cap - 1);
        }).tooltipText(List.of(class_2561.method_43471((String)"container.spectrum.rei.enchantment_upgrade.button"))));
        SaneButtonWidget plus = (SaneButtonWidget)((Object)new SaneButtonWidget(94, 18, 8, 8, 72, 16, BACKGROUND_TEXTURE, () -> false, (mX, mY, b) -> {
            this.indexer = Math.clamp((long)(this.indexer + 1), 1, cap - 1);
        }).tooltipText(List.of(class_2561.method_43471((String)"container.spectrum.rei.enchantment_upgrade.button"))));
        widgets.add((Widget)minus);
        widgets.add((Widget)plus);
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 18, 0);
        widgets.addSlot((EmiIngredient)this.inputs.get(1), 44, 0);
        widgets.addSlot((EmiIngredient)this.inputs.get(2), 62, 18);
        widgets.addSlot((EmiIngredient)this.inputs.get(3), 62, 44);
        widgets.addSlot((EmiIngredient)this.inputs.get(4), 44, 62);
        widgets.addSlot((EmiIngredient)this.inputs.get(5), 18, 62);
        widgets.addSlot((EmiIngredient)this.inputs.get(6), 0, 44);
        widgets.addSlot((EmiIngredient)this.inputs.get(7), 0, 18);
        DynamicStackWidget in = new DynamicStackWidget(c -> (EmiIngredient)this.inputs.get(9 + this.indexer - 1), 0, 31, 31);
        widgets.add((Widget)in);
        DynamicStackWidget out = new DynamicStackWidget(c -> (EmiIngredient)this.inputs.get(9 + this.indexer), 0, 106, 26);
        out.large(true).recipeContext((EmiRecipe)this);
        widgets.add((Widget)out);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 80, 31);
        DynamicTextWidget lv = new DynamicTextWidget(c -> {
            int color = 5060181;
            if (this.indexer + 1 > this.maxNormal) {
                color = 14366052;
            }
            return new class_3545((Object)class_2561.method_43469((String)"container.spectrum.rei.enchantment_upgrade.level", (Object[])new Object[]{this.indexer, this.indexer + 1}).method_30937(), (Object)color);
        }, 67, 2, false);
        widgets.add((Widget)lv);
        DynamicTextWidget itemUse = new DynamicTextWidget(c -> new class_3545((Object)class_2561.method_43469((String)"container.spectrum.rei.enchantment_upgrade.required_item_count", (Object[])new Object[]{this.itemScaling.apply(this.indexer)}).method_30937(), (Object)5060181), 67, 70, false);
        widgets.add((Widget)itemUse);
        widgets.addText(this.transKey, 3, 82, 5060181, false);
    }

    @Override
    public List<EmiStack> getOutputs() {
        return super.getOutputs();
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return super.getInputs();
    }
}

