/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.config;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="Spectrum")
public class SpectrumConfig
implements ConfigData {
    @Comment(value="The duration in milliseconds ingame recipe/unlock popups stay on the screen")
    public long ToastTimeMilliseconds = 7500L;
    @Comment(value="The reverb decay time for sound effects in Spectrum's dimension")
    public float DimensionReverbDecayTime = 8.0f;
    @Comment(value="The reverb density for sound effects in Spectrum's dimension")
    public float DimensionReverbDensity = 0.5f;
    @Comment(value="Graphical options for spectrum's dimension")
    public boolean WindSim = true;
    public boolean ReducedParticles = false;
    @Comment(value="Affects how often the wind simulation updates - A lower number makes the simulation smoother, but increases the performance impact significantly")
    public int WindSimInterval = 3;
    @Comment(value="Post process shaders")
    public boolean PostProcess = true;
    @Comment(value="Items transported by a Pastel Network spawn particles")
    public boolean PastelNetworkParticles = true;
    @Comment(value="Adjusts the general brightness of the dimension (an increase of 1 is a lot, for reference)")
    public float DimensionBrightnessMod = 1.0f;
    @Comment(value="Mod Integration Packs to not load (in case of mod compat errors). Put the mod id of the mod with integration pack conflict here")
    public List<String> IntegrationPacksToSkipLoading = new ArrayList<String>();
    @Comment(value="Add some advanced tooltips to items, like if Sculk Shriekers are able to summon the Warden")
    public boolean AddItemTooltips = true;
    @Comment(value="The vanilla anvil caps enchantment levels at the max level for the enchantment\nSo enchanted books that exceed the enchantments natural max level get capped\nIf true the bedrock anvil will not cap the enchantments level to it's natural max level")
    public boolean BedrockAnvilCanExceedMaxVanillaEnchantmentLevel = false;
    @Comment(value="The chance that an Enderman is holding a special treasure block on spawn\nSeparate value for Endermen spawning in the end, since there are LOTS of them there\nThose blocks do not gate progression, so it is not that drastic not finding any right away.\nBetter to let players stumble about them organically instead of forcing it.")
    public float EndermanHoldingEnderTreasureChance = 0.1f;
    public float EndermanHoldingEnderTreasureInEndChance = 0.0075f;
    @Comment(value="Worlds where shooting stars spawn for players. Shooting Stars will only spawn for players with sufficient progress in the mod")
    public List<String> ShootingStarWorlds = new ArrayList<String>();
    @Comment(value="Worlds where lightning strikes can spawn Storm Stones")
    public List<String> StormStonesWorlds = new ArrayList<String>();
    @Comment(value="Chance for a lightning strike to spawn a Storm Stone")
    public float StormStonesChance = 0.4f;
    @Comment(value="Enables quitoxic reed tag-based spawning.\nBy default, the reeds spawn in any biome that is\nwet, hot, and not an ocean.\nThis can be swapped to using a tag, for more delicate filtering.\n")
    public boolean QuitoxicSpawnTag = false;
    @Comment(value="Shooting star spawns are checked every night between time 13000 and 22000, every 100 ticks (so 100 chances per night).\nBy default, there is a 0.0075 ^= 0.75 % chance at each of those check times. Making it ~1 shooting star spawn\nper night per player that unlocked the required progression.")
    public float ShootingStarChance = 0.0075f;
    @Comment(value="The time in ticks it takes a Pigment Pedestal to craft a vanilla Crafting Table recipe without upgrades\nSetting this to <=0 will make the Pedestal not able to be used for crafting Crafting Table recipes.\n")
    public int VanillaRecipeCraftingTimeTicks = 40;
    @Comment(value="How fast decay will be spreading on random tick\ncan be used to slow down propagation speed of decay in the worlds\ndecay does use very few resources, but if your fear of someone letting decay\nspread free or using higher random tick rates than vanilla you can limit the spreading rate here\n\nFading and Failing do no real harm to the world. If you turn up these values too high players\nmay lack the feedback they need that what they are doing is correct\n\n1.0: Every random tick (default)\n0.5: Every second random tick\n0.0: Never (forbidden - players would be unable to progress)")
    public float FadingDecayTickRate = 1.0f;
    public float FailingDecayTickRate = 1.0f;
    public float RuinDecayTickRate = 1.0f;
    public float ForfeitureDecayTickRate = 1.0f;
    @Comment(value="Whether bottles can be used to pick up decay. Default is true.")
    public boolean CanBottleUpFading = true;
    public boolean CanBottleUpFailing = true;
    public boolean CanBottleUpRuin = true;
    public boolean CanBottleUpForfeiture = true;
    @Comment(value="Whether decay can take over block entities. Defaults to false.")
    public boolean FadingCanDestroyBlockEntities = false;
    public boolean FailingCanDestroyBlockEntities = false;
    public boolean RuinCanDestroyBlockEntities = false;
    public boolean ForfeitureCanDestroyBlockEntities = true;
    @Comment(value="When a player places decay, add an entry to the server log")
    public boolean LogPlacingOfDecay = true;
    @Comment(value="Allow End Portals to be aligned in any shape, not only 3x3")
    public boolean AllowDynamicEndPortalShape = true;
    @Comment(value="The audio volume for Spectrums crafting blocks. Set to 0.0 to turn those sounds off completely.")
    public float BlockSoundVolume = 0.5f;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="When empty, enchantments that the player has not unlocked show up with a scattered name. You can use a different name here")
    public String NameForUnrevealedEnchantments = "";
    @Comment(value="Exuberance increases experience gained when killing mobs. With 25% bonus XP and 5 levels this would mean 2,25x XP on max level")
    public float ExuberanceBonusExperiencePercentPerLevel = 0.25f;
    @Comment(value="In vanilla, crits are a flat 50 % damage bonus. Improved Critical increases this damage by additional 50 % per level by default")
    public float ImprovedCriticalExtraDamageMultiplierPerLevel = 0.5f;
    @Comment(value="Flat additional damage dealt with each level of the First Strike enchantment")
    public float FirstStrikeDamagePerLevel = 2.0f;
    @Comment(value="The percentile a mobs armor/hand stacks are being dropped when hit with a Disarming enchanted weapon per the enchantments level")
    public float DisarmingChancePerLevelMobs = 0.01f;
    @Comment(value="If > 0 the Disarming Enchantment is able to remove armor and hand tools from a hit player. Should be a far smaller chance than for mobs")
    public float DisarmingChancePerLevelPlayers = 0.001f;
    @Comment(value="The duration a glow ink sac gives night vision when wearing a glow vision helmet in seconds")
    public int GlowVisionGogglesDuration = 240;
    @Comment(value="If the Omni Accelerator should be able to have interactions in PvP that can drain the targets XP, modify their equipment, ... (configured via the requires_omni_accelerator_pvp_enabled item tag)")
    public boolean OmniAcceleratorPvP = false;
    public int GemstoneArmorHelmetProtection = 3;
    public int GemstoneArmorChestplateProtection = 7;
    public int GemstoneArmorLeggingsProtection = 5;
    public int GemstoneArmorBootsProtection = 3;
    public float GemstoneArmorToughness = 0.0f;
    public float GemstoneArmorKnockbackResistance = 0.0f;
    public int GemstoneArmorWeaknessAmplifier = 1;
    public int GemstoneArmorSlownessAmplifier = 1;
    public int GemstoneArmorAbsorptionAmplifier = 0;
    public int GemstoneArmorResistanceAmplifier = 0;
    public int GemstoneArmorRegenerationAmplifier = 0;
    public int GemstoneArmorSpeedAmplifier = 1;
    public int BedrockArmorHelmetProtection = 5;
    public int BedrockArmorLeggingsProtection = 9;
    public int BedrockArmorChestplateProtection = 13;
    public int BedrockArmorBootsProtection = 5;
    public float BedrockArmorToughness = 3.0f;
    public float BedrockArmorKnockbackResistance = 0.3f;
    public int MaxLevelForEffectsInLesserPotionPendant = 3;
    public int MaxLevelForEffectsInGreaterPotionPendant = 1;
    @Comment(value="True will prevent the spread of Decay blocks in claims.\nOnly enable when necessary and communicate to your players that those blocks will not work in their claims.\nIf any player comes to the Spectrum devs claiming that decay does not spread for them, and therefore they could not progress\nYou will get put on the 'bad pack devs' list and this config setting removed again\n")
    public boolean DecayIsStoppedByClaimMods = false;
    @Comment(value="By Default, Roughly Enough Items will show a 'recipe not unlocked yet' screen for not yet unlocked recipes.\nSetting this value to false will instead not show this screen, showing no recipes whatsoever, until unlocked\n")
    public boolean REIListsRecipesAsNotUnlocked = true;
    @Comment(value="If the player has Azure Dike Charges: Where should they be rendered on the screen. Default: Over the food bar\nOnly touch those values if you have other mods that render GUI overlays!\n")
    public int AzureDikeHudOffsetX = 0;
    public int AzureDikeHudOffsetY = 0;
    public int AzureDikeHudOffsetYWithArmor = -10;

    public void validatePostLoad() {
        if (this.VanillaRecipeCraftingTimeTicks <= 0) {
            this.VanillaRecipeCraftingTimeTicks = 40;
        }
        if ((double)this.FadingDecayTickRate <= 0.1) {
            this.FadingDecayTickRate = 1.0f;
        }
        if ((double)this.FailingDecayTickRate <= 0.1) {
            this.FadingDecayTickRate = 1.0f;
        }
        if ((double)this.RuinDecayTickRate <= 0.1) {
            this.RuinDecayTickRate = 1.0f;
        }
        if ((double)this.ShootingStarChance <= 0.001) {
            this.ShootingStarChance = 0.01f;
        }
        if ((double)this.StormStonesChance <= 0.03) {
            this.StormStonesChance = 0.3f;
        }
        if (this.EndermanHoldingEnderTreasureChance <= 0.0f) {
            this.EndermanHoldingEnderTreasureChance = 0.05f;
        }
        if (this.ExuberanceBonusExperiencePercentPerLevel <= 0.0f) {
            this.ExuberanceBonusExperiencePercentPerLevel = 0.2f;
        }
        if (this.ImprovedCriticalExtraDamageMultiplierPerLevel <= 0.0f) {
            this.ImprovedCriticalExtraDamageMultiplierPerLevel = 0.5f;
        }
        if (this.FirstStrikeDamagePerLevel <= 0.0f) {
            this.FirstStrikeDamagePerLevel = 3.0f;
        }
        if (this.ShootingStarWorlds.isEmpty()) {
            this.ShootingStarWorlds.add("minecraft:overworld");
            this.ShootingStarWorlds.add("starry_skies:overworld");
            this.ShootingStarWorlds.add("paradise_lost:paradise_lost");
        }
        if (this.StormStonesWorlds.isEmpty()) {
            this.StormStonesWorlds.add("minecraft:overworld");
            this.StormStonesWorlds.add("starry_skies:overworld");
            this.StormStonesWorlds.add("paradise_lost:paradise_lost");
        }
        if (this.WindSimInterval <= 0) {
            this.WindSimInterval = 1;
        } else if (this.WindSimInterval > 10) {
            this.WindSimInterval = 10;
        }
    }

    public boolean canPedestalCraftVanillaRecipes() {
        return this.VanillaRecipeCraftingTimeTicks > 0;
    }
}

