/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.data;

import com.google.gson.JsonElement;
import de.dafuqs.spectrum.blocks.decoration.CardinalFacingBlock;
import de.dafuqs.spectrum.data.DatagenProxy;
import de.dafuqs.spectrum.registries.DeferredRegistrar;
import de.dafuqs.spectrum.registries.client.SpectrumTextureKeys;
import de.dafuqs.spectrum.registries.client.SpectrumTextureMaps;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2350;
import net.minecraft.class_2362;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4917;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4940;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4946;
import net.minecraft.class_5000;
import net.minecraft.class_5794;

public class SpectrumModelHelper {
    public static final DeferredRegistrar.Contextual<class_4915> ITEM_MODEL_REGISTRAR = new DeferredRegistrar.Contextual(DatagenProxy.IS_DATAGEN);
    public static final DeferredRegistrar.Contextual<class_4910> BLOCK_STATE_MODEL_REGISTRAR = new DeferredRegistrar.Contextual(DatagenProxy.IS_DATAGEN);

    public static void registerItemModel(class_4915 ctx, class_1792 item) {
        SpectrumModelHelper.registerItemModel(ctx, item, "");
    }

    public static void registerItemModel(class_4915 ctx, class_1792 item, String suffix) {
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)item), SpectrumTextureMaps.layer0(item, suffix), ctx.field_22844);
    }

    public static void registerItemModel(class_4915 ctx, class_1792 item, class_4942 model) {
        model.method_25852(class_4941.method_25840((class_1792)item), SpectrumTextureMaps.layer0(item, ""), ctx.field_22844);
    }

    public static void registerLayeredItemModel(class_4915 ctx, class_1792 item, class_4942 model, String suffix0, String suffix1) {
        model.method_25852(class_4941.method_25840((class_1792)item), class_4944.method_48529((class_2960)class_4944.method_25863((class_1792)item, (String)suffix0), (class_2960)class_4944.method_25863((class_1792)item, (String)suffix1)), ctx.field_22844);
    }

    public static void registerLayeredItemModel(class_4915 ctx, class_1792 item, class_4942 model, String suffix0, String suffix1, String suffix2) {
        model.method_25852(class_4941.method_25840((class_1792)item), class_4944.method_48745((class_2960)class_4944.method_25863((class_1792)item, (String)suffix0), (class_2960)class_4944.method_25863((class_1792)item, (String)suffix1), (class_2960)class_4944.method_25863((class_1792)item, (String)suffix2)), ctx.field_22844);
    }

    public static void registerLayeredItemModel(class_4915 ctx, class_1792 item, class_4942 model, String suffix0, String suffix1, String suffix2, String suffix3) {
        model.method_25852(class_4941.method_25840((class_1792)item), class_4944.method_48745((class_2960)class_4944.method_25863((class_1792)item, (String)suffix0), (class_2960)class_4944.method_25863((class_1792)item, (String)suffix1), (class_2960)class_4944.method_25863((class_1792)item, (String)suffix2)).method_25868(SpectrumTextureKeys.LAYER3, class_4944.method_25863((class_1792)item, (String)suffix3)), ctx.field_22844);
    }

    public static void registerBlockTexturedItemModel(class_4915 ctx, class_2248 block) {
        SpectrumModelHelper.registerBlockTexturedItemModel(ctx, block, "");
    }

    public static void registerBlockTexturedItemModel(class_4915 ctx, class_2248 block, String suffix) {
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)block.method_8389()), SpectrumTextureMaps.layer0(block, suffix), ctx.field_22844);
    }

    public static void registerParentedItemModel(class_4915 ctx, class_1935 item, class_1792 parent) {
        SpectrumModelHelper.registerParentedItemModel(ctx, item, parent, "");
    }

    public static void registerParentedItemModel(class_4915 ctx, class_1935 item, class_2248 parent) {
        SpectrumModelHelper.registerParentedItemModel(ctx, item, parent, "");
    }

    public static void registerParentedItemModel(class_4915 ctx, class_1935 item, class_1792 parent, String suffix) {
        SpectrumModelHelper.registerParentedItemModel(ctx, item, class_4941.method_25841((class_1792)parent, (String)suffix));
    }

    public static void registerParentedItemModel(class_4915 ctx, class_1935 item, class_2248 parent, String suffix) {
        SpectrumModelHelper.registerParentedItemModel(ctx, item, class_4941.method_25843((class_2248)parent, (String)suffix));
    }

    public static void registerParentedItemModel(class_4915 ctx, class_1935 item, class_2960 parentModelId) {
        ctx.field_22844.accept(class_4941.method_25840((class_1792)item.method_8389()), new class_4940(parentModelId));
    }

    public static class_4917 simpleMirroredBlockModel(class_4910 ctx, class_2248 block) {
        return SpectrumModelHelper.createMirroredVariantsSupplier(block, class_4946.field_23036, class_4946.field_23037, ctx.field_22831);
    }

    public static class_4917 logBlockModel(class_4910 ctx, class_2248 logBlock) {
        class_4944 textureMap = SpectrumTextureMaps.sideEnd(logBlock, "", logBlock, "_top");
        class_2960 vertical = class_4943.field_22974.method_25846(logBlock, textureMap, ctx.field_22831);
        class_2960 horizonal = class_4943.field_22975.method_25846(logBlock, textureMap, ctx.field_22831);
        return class_4925.method_25769((class_2248)logBlock).method_25775(SpectrumModelHelper.createAxisRotatedVariantMap(vertical, horizonal));
    }

    public static class_4917 woodBlockModel(class_4910 ctx, class_2248 woodBlock, class_2248 logBlock) {
        class_4944 textureMap = SpectrumTextureMaps.sideEnd(logBlock, "", logBlock, "");
        class_2960 model = class_4943.field_22974.method_25846(woodBlock, textureMap, ctx.field_22831);
        return class_4925.method_25770((class_2248)woodBlock, (class_4935)SpectrumModelHelper.createModelVariant(model)).method_25775(SpectrumModelHelper.createAxisRotatedVariantMap());
    }

    public static class_4917 pottedPlantBlockModel(class_4910 ctx, class_2362 block, boolean tinted) {
        class_4910.class_4913 tintType = tinted ? class_4910.class_4913.field_22839 : class_4910.class_4913.field_22840;
        class_4944 textureMap = class_4944.method_25881((class_2248)block.method_16231());
        class_2960 identifier = tintType.method_25727().method_25846((class_2248)block, textureMap, ctx.field_22831);
        return class_4910.method_25644((class_2248)block, (class_2960)identifier);
    }

    public static class_4917 pottedPlantWithCustomTextureBlockModel(class_4910 ctx, class_2362 block, String suffix) {
        class_4944 textureMap = class_4944.method_25884((class_2960)class_4944.method_25860((class_2248)block.method_16231()).method_48331(suffix));
        class_2960 identifier = class_4943.field_22923.method_25846((class_2248)block, textureMap, ctx.field_22831);
        return class_4910.method_25644((class_2248)block, (class_2960)identifier);
    }

    public static class_4917 glassPaneBlockModel(class_4910 ctx, class_2248 glassPaneBlock, class_2248 glassBlock) {
        class_4944 textureMap = class_4944.method_25873((class_2248)glassBlock, (class_2248)glassPaneBlock);
        class_2960 post = class_4943.field_22953.method_25846(glassPaneBlock, textureMap, ctx.field_22831);
        class_2960 side = class_4943.field_22954.method_25846(glassPaneBlock, textureMap, ctx.field_22831);
        class_2960 sideAlt = class_4943.field_22955.method_25846(glassPaneBlock, textureMap, ctx.field_22831);
        class_2960 noside = class_4943.field_22951.method_25846(glassPaneBlock, textureMap, ctx.field_22831);
        class_2960 nosideAlt = class_4943.field_22952.method_25846(glassPaneBlock, textureMap, ctx.field_22831);
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)glassPaneBlock.method_8389()), class_4944.method_25911((class_2248)glassBlock), ctx.field_22831);
        return class_4922.method_25758((class_2248)glassPaneBlock).method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)post)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideAlt)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideAlt).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noside)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)nosideAlt)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)nosideAlt).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noside).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893));
    }

    public static class_5794 registerBlockFamily(class_5794 family) {
        BLOCK_STATE_MODEL_REGISTRAR.defer(ctx -> ctx.method_25650(family.method_33469()).method_33522(family));
        return family;
    }

    public static class_5794 registerBlockFamilyExceptBase(class_5794 family, class_4946.class_4947 variantFactory) {
        BLOCK_STATE_MODEL_REGISTRAR.defer(ctx -> {
            class_4946 texturedModel = variantFactory.get(family.method_33469());
            class_4910 class_49102 = ctx;
            Objects.requireNonNull(class_49102);
            class_4910.class_4912 texturePool = new class_4910.class_4912(class_49102, texturedModel.method_25921());
            texturePool.field_22838 = class_4941.method_25842((class_2248)family.method_33469());
            texturePool.method_33522(family);
        });
        return family;
    }

    public static class_4925 createVariantsSupplier(class_2248 block, class_2960 ... modelIds) {
        return class_4925.method_25771((class_2248)block, (class_4935[])((class_4935[])Arrays.stream(modelIds).map(modelId -> class_4935.method_25824().method_25828(class_4936.field_22887, modelId)).toArray(class_4935[]::new)));
    }

    public static class_4925 createVariantsSupplier(class_4910 ctx, class_2248 block, class_4946.class_4947 factory) {
        return SpectrumModelHelper.createVariantsSupplier(block, factory.method_25923(block, ctx.field_22831));
    }

    public static class_4925 createMirroredVariantsSupplier(class_2248 block, class_4946.class_4947 factory, class_4946.class_4947 mirroredFactory, BiConsumer<class_2960, Supplier<JsonElement>> modelCollector) {
        return class_4925.method_25771((class_2248)block, (class_4935[])new class_4935[]{SpectrumModelHelper.createModelVariant(factory.method_25923(block, modelCollector)), SpectrumModelHelper.createModelVariant(mirroredFactory.method_25923(block, modelCollector))});
    }

    public static List<class_4935> createHorizontalRotationVariantList(class_2960 modelId) {
        return List.of(SpectrumModelHelper.createModelVariant(modelId), SpectrumModelHelper.createModelVariant(modelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891), SpectrumModelHelper.createModelVariant(modelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892), SpectrumModelHelper.createModelVariant(modelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893));
    }

    public static class_4926 createBooleanModelMap(class_2746 property, class_2960 trueModel, class_2960 falseModel) {
        return class_4926.method_25783((class_2769)property).method_25793((Comparable)Boolean.valueOf(false), SpectrumModelHelper.createModelVariant(falseModel)).method_25793((Comparable)Boolean.valueOf(true), SpectrumModelHelper.createModelVariant(trueModel));
    }

    public static class_4926 createCardinalFacingVariantMap() {
        return class_4926.method_25783((class_2769)CardinalFacingBlock.CARDINAL_FACING).method_25793((Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)Boolean.valueOf(true), class_4935.method_25824());
    }

    public static class_4926 createAxisRotatedVariantMap() {
        return class_4926.method_25783((class_2769)class_2741.field_12496).method_25793((Comparable)class_2350.class_2351.field_11048, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.class_2351.field_11052, class_4935.method_25824()).method_25793((Comparable)class_2350.class_2351.field_11051, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891));
    }

    public static class_4926 createAxisRotatedVariantMap(class_2960 verticalModelId, class_2960 horizontalModelId) {
        return class_4926.method_25783((class_2769)class_2741.field_12496).method_25793((Comparable)class_2350.class_2351.field_11048, SpectrumModelHelper.createModelVariant(horizontalModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.class_2351.field_11052, SpectrumModelHelper.createModelVariant(verticalModelId)).method_25793((Comparable)class_2350.class_2351.field_11051, SpectrumModelHelper.createModelVariant(horizontalModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891));
    }

    public static class_4926 createUpDefaultFacingVariantMap() {
        return class_4926.method_25783((class_2769)class_2741.field_12525).method_25793((Comparable)class_2350.field_11033, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892)).method_25793((Comparable)class_2350.field_11036, class_4935.method_25824()).method_25793((Comparable)class_2350.field_11043, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25793((Comparable)class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25793((Comparable)class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
    }

    public static class_4926 createDownDefaultFacingVariantMap(class_2960 horizontalModelId, class_2960 verticalModelId) {
        return class_4926.method_25783((class_2769)class_2318.field_10927).method_25793((Comparable)class_2350.field_11033, SpectrumModelHelper.createModelVariant(verticalModelId)).method_25793((Comparable)class_2350.field_11036, SpectrumModelHelper.createModelVariant(verticalModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892)).method_25793((Comparable)class_2350.field_11043, SpectrumModelHelper.createModelVariant(horizontalModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25793((Comparable)class_2350.field_11035, SpectrumModelHelper.createModelVariant(horizontalModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.field_11039, SpectrumModelHelper.createModelVariant(horizontalModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25793((Comparable)class_2350.field_11034, SpectrumModelHelper.createModelVariant(horizontalModelId));
    }

    public static class_4926 createNorthDefaultFacingVariantMap() {
        return class_4926.method_25783((class_2769)class_2741.field_12525).method_25793((Comparable)class_2350.field_11033, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.field_11036, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893)).method_25793((Comparable)class_2350.field_11043, class_4935.method_25824()).method_25793((Comparable)class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25793((Comparable)class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25793((Comparable)class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
    }

    public static class_4926 createUpDefaultHorizontalFacingVariantMap() {
        return class_4926.method_25783((class_2769)class_2741.field_12481).method_25793((Comparable)class_2350.field_11043, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25793((Comparable)class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25793((Comparable)class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
    }

    public static class_4926 createNorthDefaultHorizontalFacingVariantMap() {
        return class_4926.method_25783((class_2769)class_2741.field_12481).method_25793((Comparable)class_2350.field_11043, class_4935.method_25824()).method_25793((Comparable)class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25793((Comparable)class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25793((Comparable)class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
    }

    public static class_4926 createSouthDefaultHorizontalFacingVariantMap() {
        return class_4926.method_25783((class_2769)class_2741.field_12481).method_25793((Comparable)class_2350.field_11043, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25793((Comparable)class_2350.field_11035, class_4935.method_25824()).method_25793((Comparable)class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893));
    }

    public static class_4926 createWestDefaultHorizontalFacingVariantMap() {
        return class_4926.method_25783((class_2769)class_2741.field_12481).method_25793((Comparable)class_2350.field_11043, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25793((Comparable)class_2350.field_11039, class_4935.method_25824()).method_25793((Comparable)class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892));
    }

    public static class_4926 createEastDefaultHorizontalFacingVariantMap() {
        return class_4926.method_25783((class_2769)class_2741.field_12481).method_25793((Comparable)class_2350.field_11043, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25793((Comparable)class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25793((Comparable)class_2350.field_11034, class_4935.method_25824());
    }

    public static class_4926 createUpNorthDefaultOrientationVariantMap() {
        return class_4926.method_25783((class_2769)class_2741.field_23333).method_25793((Comparable)class_5000.field_23382, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_5000.field_23383, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25793((Comparable)class_5000.field_23384, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25793((Comparable)class_5000.field_23381, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_5000.field_23386, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25793((Comparable)class_5000.field_23387, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893)).method_25793((Comparable)class_5000.field_23388, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_5000.field_23385, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25793((Comparable)class_5000.field_23391, class_4935.method_25824()).method_25793((Comparable)class_5000.field_23392, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25793((Comparable)class_5000.field_23389, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25793((Comparable)class_5000.field_23390, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
    }

    public static class_4935 createModelVariant(class_2960 modelId) {
        return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelId);
    }

    public static class_4935 createModelVariant(class_2248 block, String suffix) {
        return SpectrumModelHelper.createModelVariant(class_4941.method_25843((class_2248)block, (String)suffix));
    }

    public static class_4936.class_4937 getSouthDefaultRotation(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11039 -> class_4936.class_4937.field_22891;
            case class_2350.field_11043 -> class_4936.class_4937.field_22892;
            case class_2350.field_11034 -> class_4936.class_4937.field_22893;
            default -> class_4936.class_4937.field_22890;
        };
    }
}

