/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.data_loaders;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.predicate.location.WorldConditionsPredicate;
import de.dafuqs.spectrum.helpers.CodecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6007;
import net.minecraft.class_6008;
import net.minecraft.class_6012;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class EntityFishingDataLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    public static final String ID = "entity_fishing";
    public static final EntityFishingDataLoader INSTANCE = new EntityFishingDataLoader();
    protected static final List<EntityFishingEntry> ENTITY_FISHING_ENTRIES = new ArrayList<EntityFishingEntry>();

    private EntityFishingDataLoader() {
        super(new Gson(), ID);
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        ENTITY_FISHING_ENTRIES.clear();
        prepared.forEach((identifier, jsonElement) -> CodecHelper.fromJson(EntityFishingEntry.CODEC, (JsonElement)jsonElement.getAsJsonObject()).ifPresent(ENTITY_FISHING_ENTRIES::add));
    }

    public class_2960 getFabricId() {
        return SpectrumCommon.locate(ID);
    }

    public static Optional<EntityFishingEntity> tryCatchEntity(class_3218 world, class_2338 pos, int bigCatchLevel) {
        for (EntityFishingEntry entry : ENTITY_FISHING_ENTRIES) {
            Optional x;
            if (!entry.predicates.stream().anyMatch(p -> p.test(world, pos))) continue;
            if (world.field_9229.method_43057() < entry.entityChance * (float)(1 + bigCatchLevel) && (x = entry.weightedEntities.method_34992(world.field_9229)).isPresent()) {
                return Optional.of((EntityFishingEntity)((class_6008.class_6010)x.get()).comp_2542());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public record EntityFishingEntry(List<WorldConditionsPredicate> predicates, float entityChance, class_6012<class_6008.class_6010<EntityFishingEntity>> weightedEntities) {
        public static final Codec<EntityFishingEntry> CODEC = RecordCodecBuilder.create(i -> i.group((App)CodecHelper.singleOrList(WorldConditionsPredicate.CODEC).fieldOf("location").forGetter(EntityFishingEntry::predicates), (App)Codec.FLOAT.fieldOf("chance").forGetter(EntityFishingEntry::entityChance), (App)EntityFishingEntity.WEIGHTED_CODEC.listOf().xmap(class_6012::method_34988, class_6012::method_34994).fieldOf("entities").forGetter(EntityFishingEntry::weightedEntities)).apply((Applicative)i, EntityFishingEntry::new));
    }

    public record EntityFishingEntity(class_6880<class_1299<?>> entityType, class_2487 nbt) {
        public static final MapCodec<EntityFishingEntity> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)class_7923.field_41177.method_40294().fieldOf("id").forGetter(EntityFishingEntity::entityType), (App)class_2487.field_25128.optionalFieldOf("nbt", (Object)new class_2487()).forGetter(EntityFishingEntity::nbt)).apply((Applicative)i, EntityFishingEntity::new));
        public static final Codec<class_6008.class_6010<EntityFishingEntity>> WEIGHTED_CODEC = RecordCodecBuilder.create(i -> i.group((App)CODEC.forGetter(class_6008.class_6010::comp_2542), (App)class_6007.field_29927.optionalFieldOf("id", (Object)class_6007.method_34977((int)1)).forGetter(class_6008.class_6010::comp_2543)).apply((Applicative)i, class_6008.class_6010::new));
    }
}

