/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.data_loaders;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.recipe.RecipeUtils;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class NaturesStaffConversionDataLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    public static final String ID = "natures_staff_conversion";
    public static final NaturesStaffConversionDataLoader INSTANCE = new NaturesStaffConversionDataLoader();
    public static final HashMap<class_2248, class_2680> CONVERSIONS = new HashMap();
    public static final HashMap<class_2248, class_2960> UNLOCK_IDENTIFIERS = new HashMap();

    private NaturesStaffConversionDataLoader() {
        super(new Gson(), ID);
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        CONVERSIONS.clear();
        prepared.forEach((identifier, jsonElement) -> {
            class_2680 output;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            class_2248 input = (class_2248)class_7923.field_41175.method_10223(class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)"input_block")));
            try {
                output = RecipeUtils.blockStateFromString(jsonObject.get("output_state").getAsString());
            }
            catch (CommandSyntaxException e) {
                throw new JsonParseException((Throwable)e);
            }
            if (input != class_2246.field_10124 && !output.method_26215()) {
                CONVERSIONS.put(input, output);
                if (class_3518.method_15289((JsonObject)jsonObject, (String)"unlock_identifier")) {
                    UNLOCK_IDENTIFIERS.put(input, class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)"unlock_identifier")));
                }
            }
        });
    }

    public class_2960 getFabricId() {
        return SpectrumCommon.locate(ID);
    }

    @Nullable
    public static class_2680 getConvertedBlockState(class_2248 block) {
        return CONVERSIONS.getOrDefault(block, null);
    }
}

