/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import de.dafuqs.spectrum.blocks.gravity.FloatBlock;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.recipe.anvil_crushing.AnvilCrusher;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2968;
import net.minecraft.class_3231;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_4538;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class FloatBlockEntity
extends class_1297 {
    private static final float MAX_DAMAGE = 12.0f;
    private static final float DAMAGE_PER_FALLEN_BLOCK = 1.0f;
    private static final class_2940<class_2338> ORIGIN = class_2945.method_12791(FloatBlockEntity.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Long> LAUNCH_TIME = class_2945.method_12791(FloatBlockEntity.class, (class_2941)class_2943.field_39965);
    private static final class_2940<Float> GRAVITY_MODIFIER = class_2945.method_12791(FloatBlockEntity.class, (class_2941)class_2943.field_13320);
    public int moveTime = 0;
    protected class_2487 blockEntityData;
    protected class_2680 blockState = class_2246.field_10340.method_9564();
    protected boolean canSetBlock = true;
    protected boolean collides;

    public FloatBlockEntity(class_1299<? extends FloatBlockEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public FloatBlockEntity(class_1299<? extends FloatBlockEntity> entityType, class_1937 world, double x, double y, double z, class_2680 blockState) {
        this(entityType, world);
        this.blockState = blockState;
        this.field_23807 = true;
        this.method_5814(x, y, z);
        this.method_18799(class_243.field_1353);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
        this.setOrigin(class_2338.method_49638((class_2374)this.method_19538()));
        this.setLaunchTime(this.method_37908().method_8510());
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof FloatBlock) {
            FloatBlock floatBlock = (FloatBlock)class_22482;
            this.setGravity(floatBlock.getGravityMod());
        }
    }

    public FloatBlockEntity(class_1937 world, class_2338 pos, class_2680 blockState) {
        this(SpectrumEntityTypes.FLOAT_BLOCK, world, (double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5, blockState);
    }

    protected class_238 method_33332() {
        if (this.field_6011 == null || this.blockState == null) {
            return super.method_33332();
        }
        class_2338 origin = (class_2338)this.field_6011.method_12789(ORIGIN);
        class_265 shape = this.blockState.method_26220((class_1922)this.method_37908(), origin);
        if (shape.method_1110()) {
            this.collides = false;
            shape = this.blockState.method_26218((class_1922)this.method_37908(), origin);
            if (shape.method_1110()) {
                return super.method_33332();
            }
        } else {
            this.collides = true;
        }
        class_238 box = shape.method_1107();
        return box.method_997(this.method_19538().method_1020(new class_243(0.5, 0.0, 0.5)));
    }

    public void method_5773() {
        if (this.getBlockState().method_26215()) {
            this.method_31472();
            return;
        }
        if (this.moveTime++ == 0) {
            class_2338 blockPos = this.method_24515();
            class_2248 block = this.blockState.method_26204();
            if (this.method_37908().method_8320(blockPos).method_27852(block)) {
                this.method_37908().method_8650(blockPos, false);
            }
        }
        if (!this.method_5740()) {
            this.field_5994 = (float)this.method_19538().method_10214() - (float)this.getOrigin().method_10264();
            long launchTime = this.method_37908().method_8510() - this.getLaunchTime();
            double additionalYVelocity = launchTime > 100L ? this.method_7490() / 10.0 : Math.min(Math.sin(Math.PI * (double)launchTime / 100.0), 1.0) * (this.method_7490() / 10.0);
            this.method_5762(0.0, additionalYVelocity, 0.0);
            this.method_18799(this.method_18798().method_1021(0.98));
            if (!this.method_37908().field_9236) {
                this.dealDamage();
            }
        }
        this.moveEntities();
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (!this.method_37908().field_9236) {
            if (this.field_5992) {
                this.trySetBlock();
            } else if (this.field_6012 > 100 && this.method_37908().method_31606(this.method_24515())) {
                this.dropAsItem();
                this.method_31472();
            }
        }
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        super.method_5784(movementType, movement);
        if (movementType != class_1313.field_6308) {
            this.method_18799(movement);
        }
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player.method_5715()) {
            if (this.method_37908().method_8608()) {
                return class_1269.field_5812;
            }
            class_1792 item = this.blockState.method_26204().method_8389();
            if (item != null) {
                player.method_31548().method_7398(item.method_7854());
            }
            this.method_31472();
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public class_1799 method_31480() {
        return this.blockState.method_26204().method_8389().method_7854();
    }

    public void onEntityCollision(class_1297 entity) {
        if (!(entity instanceof FloatBlockEntity)) {
            this.blockState.method_26178(this.method_37908(), this.method_24515(), entity);
        }
    }

    public void dealDamage() {
        int damage;
        int traveledDistance = class_3532.method_15386((float)(this.field_6017 - 1.0f));
        if (traveledDistance > 0 && (damage = (int)Math.min((float)class_3532.method_15375((float)((float)traveledDistance * 1.0f)), 12.0f)) > 0) {
            Predicate<class_1297> predicate = class_1301.field_6156.and(entity -> entity.method_5805() && (entity instanceof class_1309 || entity instanceof class_1542));
            this.method_37908().method_8333((class_1297)this, this.method_5829(), predicate).forEach(entity -> {
                if (entity instanceof class_1542) {
                    class_1542 itemEntity = (class_1542)entity;
                    AnvilCrusher.crush(itemEntity, damage * 2);
                } else {
                    entity.method_5643(SpectrumDamageTypes.floatblock(entity.method_37908()), (float)damage);
                }
            });
        }
    }

    protected void method_5652(class_2487 compound) {
        compound.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)this.blockState));
        compound.method_10569("Time", this.moveTime);
        if (this.blockEntityData != null) {
            compound.method_10566("BlockEntityData", (class_2520)this.blockEntityData);
        }
        compound.method_10548("GravityModifier", (float)this.method_7490());
    }

    protected void method_5749(class_2487 compound) {
        this.blockState = class_2512.method_10681((class_7871)this.method_37908().method_45448(class_7924.field_41254), (class_2487)compound.method_10562("BlockState"));
        this.moveTime = compound.method_10550("Time");
        if (compound.method_10573("BlockEntityData", 10)) {
            this.blockEntityData = compound.method_10562("BlockEntityData");
        }
        if (this.blockState.method_26215()) {
            this.blockState = class_2246.field_10340.method_9564();
        }
        if (compound.method_10573("GravityModifier", 5)) {
            this.setGravity(compound.method_10583("GravityModifier"));
        }
    }

    public boolean method_5862() {
        return false;
    }

    public void method_5819(class_129 section) {
        super.method_5819(section);
        section.method_578("Imitating BlockState", (Object)this.blockState.toString());
    }

    public class_2680 getBlockState() {
        return this.blockState;
    }

    public void trySetBlock() {
        class_2338 blockPos = this.method_24515();
        class_2680 blockState = this.method_37908().method_8320(blockPos);
        boolean canReplace = blockState.method_26166((class_1750)new class_2968(this.method_37908(), blockPos, class_2350.field_11036, class_1799.field_8037, class_2350.field_11033));
        boolean canPlace = this.blockState.method_26184((class_4538)this.method_37908(), blockPos);
        if (!(this.canSetBlock && canPlace && canReplace)) {
            return;
        }
        if (this.blockState.method_28498((class_2769)class_2741.field_12508) && this.method_37908().method_8316(blockPos).method_15772() == class_3612.field_15910) {
            this.blockState = (class_2680)this.blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
        }
        if (this.method_37908().method_8652(blockPos, this.blockState, 3)) {
            class_2586 blockEntity;
            this.method_31472();
            if (this.blockEntityData != null && this.blockState.method_31709() && (blockEntity = this.method_37908().method_8321(blockPos)) != null) {
                class_5455 registryLookup = this.method_37908().method_30349();
                class_2487 compoundTag = blockEntity.method_38244((class_7225.class_7874)registryLookup);
                for (String keyName : this.blockEntityData.method_10541()) {
                    class_2520 tag = this.blockEntityData.method_10580(keyName);
                    if (tag == null || "x".equals(keyName) || "y".equals(keyName) || "z".equals(keyName)) continue;
                    compoundTag.method_10566(keyName, tag.method_10707());
                }
                blockEntity.method_58690(compoundTag, (class_7225.class_7874)registryLookup);
                blockEntity.method_5431();
            }
        }
    }

    public void moveEntities() {
        if (class_2346.method_10128((class_2680)this.blockState)) {
            return;
        }
        class_1937 world = this.method_37908();
        class_238 collissionBox = this.method_5829().method_1009(0.0, 2.0, 0.0);
        for (class_1297 entity : world.method_8335((class_1297)this, collissionBox)) {
            FloatBlockEntity other;
            if (entity instanceof FloatBlockEntity && this.isPaltaeriaStratineCollision(other = (FloatBlockEntity)entity)) {
                world.method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 1.0f, class_1937.class_7867.field_40888);
                class_1799 collisionStack = SpectrumBlocks.HOVER_BLOCK.method_8389().method_7854();
                class_1542 itemEntity = new class_1542(world, this.method_23317(), this.method_23318(), this.method_23321(), collisionStack);
                itemEntity.method_5762(0.1 - (double)world.field_9229.method_43057() * 0.2, 0.1 - (double)world.field_9229.method_43057() * 0.2, 0.1 - (double)world.field_9229.method_43057() * 0.2);
                world.method_8649((class_1297)itemEntity);
                this.method_31472();
                other.method_31472();
                continue;
            }
            if (!entity.method_5810() || entity.method_5657() == class_3619.field_15975 || !entity.method_5829().method_994(collissionBox)) continue;
            entity.method_5784(class_1313.field_6306, this.method_18798());
            entity.method_24830(true);
            entity.field_6017 = 0.0f;
            this.onEntityCollision(entity);
        }
    }

    public boolean isPaltaeriaStratineCollision(FloatBlockEntity other) {
        class_2248 thisBlock = this.blockState.method_26204();
        class_2248 otherBlock = other.getBlockState().method_26204();
        return thisBlock == SpectrumBlocks.PALTAERIA_FLOATBLOCK && otherBlock == SpectrumBlocks.STRATINE_FLOATBLOCK || thisBlock == SpectrumBlocks.STRATINE_FLOATBLOCK && otherBlock == SpectrumBlocks.PALTAERIA_FLOATBLOCK;
    }

    public void dropAsItem() {
        if (this.method_31481()) {
            return;
        }
        this.method_31472();
        if (this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            class_2248.method_9497((class_2680)this.blockState, (class_1937)this.method_37908(), (class_2338)this.method_24515());
        }
        this.method_37908().method_8444(null, 2001, this.method_24515(), class_2248.method_9507((class_2680)this.blockState));
    }

    public boolean method_5833() {
        return true;
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        return new class_2604((class_1297)this, entityTrackerEntry, class_2248.method_9507((class_2680)this.getBlockState()));
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.blockState = class_2248.method_9531((int)packet.method_11166());
        this.field_23807 = true;
        double d = packet.method_11175();
        double e = packet.method_11174();
        double f = packet.method_11176();
        this.method_5814(d, e + (double)((1.0f - this.method_17682()) / 2.0f), f);
        this.setOrigin(this.method_24515());
    }

    public boolean method_5732() {
        return false;
    }

    public class_2338 getOrigin() {
        return (class_2338)this.field_6011.method_12789(ORIGIN);
    }

    public void setOrigin(class_2338 origin) {
        this.field_6011.method_12778(ORIGIN, (Object)origin);
        this.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
    }

    public Long getLaunchTime() {
        return (Long)this.field_6011.method_12789(LAUNCH_TIME);
    }

    public void setLaunchTime(long spawnTime) {
        this.field_6011.method_12778(LAUNCH_TIME, (Object)spawnTime);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(ORIGIN, (Object)class_2338.field_10980);
        builder.method_56912(GRAVITY_MODIFIER, (Object)Float.valueOf(0.0f));
        builder.method_56912(LAUNCH_TIME, (Object)0L);
    }

    public boolean method_30948() {
        return this.collides;
    }

    public double method_7490() {
        return ((Float)this.field_6011.method_12789(GRAVITY_MODIFIER)).floatValue();
    }

    protected void setGravity(float modifier) {
        this.field_6011.method_12778(GRAVITY_MODIFIER, (Object)Float.valueOf(modifier));
    }

    public boolean method_5740() {
        return this.method_7490() == 0.0 || super.method_5740();
    }
}

