/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColorMixes;
import de.dafuqs.spectrum.api.energy.color.InkColorTags;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.entity.POIMemorized;
import de.dafuqs.spectrum.api.entity.PackEntity;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.entity.SpectrumTrackedDataHandlerRegistry;
import de.dafuqs.spectrum.entity.variants.LizardFrillVariant;
import de.dafuqs.spectrum.entity.variants.LizardHornVariant;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumPointOfInterestTypeTags;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import de.dafuqs.spectrum.registries.SpectrumRegistryKeys;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1371;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3489;
import net.minecraft.class_3730;
import net.minecraft.class_4158;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5532;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7477;
import org.jetbrains.annotations.Nullable;

public class LizardEntity
extends class_1321
implements PackEntity<LizardEntity>,
POIMemorized {
    protected static final class_2940<class_6880<LizardFrillVariant>> FRILL_VARIANT = class_2945.method_12791(LizardEntity.class, SpectrumTrackedDataHandlerRegistry.LIZARD_FRILL_VARIANT);
    protected static final class_2940<class_6880<LizardHornVariant>> HORN_VARIANT = class_2945.method_12791(LizardEntity.class, SpectrumTrackedDataHandlerRegistry.LIZARD_HORN_VARIANT);
    protected static final class_2940<InkColor> COLOR = class_2945.method_12791(LizardEntity.class, SpectrumTrackedDataHandlerRegistry.INK_COLOR);
    @Nullable
    protected LizardEntity leader;
    protected int groupSize = 1;
    protected int ticksLeftToFindPOI;
    @Nullable
    protected class_2338 poiPos;

    public LizardEntity(class_1299<? extends LizardEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 4;
    }

    public static class_5132.class_5133 createLizardAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 60.0).method_26868(class_5134.field_23721, 16.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23724, 6.0).method_26868(class_5134.field_23725, 1.0).method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23717, 12.0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1371((class_1308)this));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.2));
        this.field_6201.method_6277(4, new PackEntity.FollowClanLeaderGoal<LizardEntity>(this));
        this.field_6201.method_6277(5, (class_1352)new FindPOIGoal((class_5321<class_4158>)class_7477.field_39296, 32));
        this.field_6201.method_6277(6, (class_1352)new ClanLeaderWanderAroundGoal((class_1314)this, 0.8, 20, 8, 4));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true, target -> !this.method_6171((class_1309)target)));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1309.class, true, target -> {
            if (target instanceof LizardEntity) {
                LizardEntity other = (LizardEntity)target;
                return this.isDifferentPack(other);
            }
            return !target.method_6109();
        }));
    }

    public float method_5718() {
        return 1.0f;
    }

    public boolean method_6171(class_1309 entity) {
        return entity == this.method_35057() || this.leader != null && entity == this.leader.method_35057();
    }

    protected void method_5958() {
        super.method_5958();
        if (this.field_6012 % 1200 == 0) {
            this.method_6025(1.0f);
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(COLOR, (Object)InkColors.MAGENTA);
        class_5455 registryAccess = this.method_56673();
        class_2378 lizardFrillVariantRegistry = registryAccess.method_30530(SpectrumRegistryKeys.LIZARD_FRILL_VARIANT);
        Optional frillHolder = lizardFrillVariantRegistry.method_40264(LizardFrillVariant.SIMPLE);
        builder.method_56912(FRILL_VARIANT, (Object)((class_6880)frillHolder.or(() -> ((class_2378)lizardFrillVariantRegistry).method_60385()).orElseThrow()));
        class_2378 kindlingHornRegistry = registryAccess.method_30530(SpectrumRegistryKeys.LIZARD_HORN_VARIANT);
        Optional hornHolder = kindlingHornRegistry.method_40264(LizardHornVariant.HORNY);
        builder.method_56912(HORN_VARIANT, (Object)((class_6880)hornHolder.or(() -> ((class_2378)kindlingHornRegistry).method_60385()).orElseThrow()));
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_5819 random = world.method_8409();
        this.setFrills((class_6880<LizardFrillVariant>)((class_6880)((class_2378)world.method_30349().method_33310(SpectrumRegistryKeys.LIZARD_FRILL_VARIANT).get()).method_10240(world.method_8409()).get()));
        this.setHorns((class_6880<LizardHornVariant>)((class_6880)((class_2378)world.method_30349().method_33310(SpectrumRegistryKeys.LIZARD_HORN_VARIANT).get()).method_10240(world.method_8409()).get()));
        List<InkColor> elementals = InkColors.elementals();
        this.setColor(elementals.get(random.method_43048(elementals.size())));
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("color", this.getColor().getID().toString());
        this.getFrills().method_40230().ifPresent(resourceKey -> nbt.method_10582("frills", resourceKey.method_29177().toString()));
        this.getHorns().method_40230().ifPresent(resourceKey -> nbt.method_10582("horns", resourceKey.method_29177().toString()));
        this.writePOIPosToNbt(nbt);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        InkColor color = (InkColor)SpectrumRegistries.INK_COLOR.method_10223(class_2960.method_12829((String)nbt.method_10558("color")));
        this.setColor(color == null ? SpectrumRegistries.getRandomTagEntry(SpectrumRegistries.INK_COLOR, InkColorTags.ELEMENTAL_COLORS, this.field_5974, InkColors.CYAN) : color);
        Optional.ofNullable(class_2960.method_12829((String)nbt.method_10558("frills"))).map(resourceLocation -> class_5321.method_29179(SpectrumRegistryKeys.LIZARD_FRILL_VARIANT, (class_2960)resourceLocation)).flatMap(resourceKey -> this.method_56673().method_30530(SpectrumRegistryKeys.LIZARD_FRILL_VARIANT).method_40264(resourceKey)).ifPresent(this::setFrills);
        Optional.ofNullable(class_2960.method_12829((String)nbt.method_10558("horns"))).map(resourceLocation -> class_5321.method_29179(SpectrumRegistryKeys.LIZARD_HORN_VARIANT, (class_2960)resourceLocation)).flatMap(resourceKey -> this.method_56673().method_30530(SpectrumRegistryKeys.LIZARD_HORN_VARIANT).method_40264(resourceKey)).ifPresent(this::setHorns);
        this.readPOIPosFromNbt(nbt);
    }

    public void method_6007() {
        class_1937 world = this.method_37908();
        super.method_6007();
        if (!world.field_9236 && this.ticksLeftToFindPOI > 0) {
            --this.ticksLeftToFindPOI;
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1937 world = this.method_37908();
        class_1799 itemStack = player.method_5998(hand);
        if (this.method_6481(itemStack)) {
            int i = this.method_5618();
            if (!world.field_9236 && i == 0 && this.method_6482() && this.field_5974.method_43048(5) == 0) {
                this.method_6475(player, hand, itemStack);
                this.method_6170(player);
                this.method_6480(player);
                return class_1269.field_5812;
            }
            if (this.method_6109()) {
                this.method_6475(player, hand, itemStack);
                this.method_5620(LizardEntity.method_41321((int)(-i)), true);
                return class_1269.method_29236((boolean)world.field_9236);
            }
            if (world.field_9236) {
                return class_1269.field_21466;
            }
        }
        return class_1269.field_5811;
    }

    public boolean method_6482() {
        return super.method_6482() || this.method_35057() != null;
    }

    public InkColor getColor() {
        return (InkColor)this.field_6011.method_12789(COLOR);
    }

    public void setColor(InkColor color) {
        this.field_6011.method_12778(COLOR, (Object)color);
    }

    public class_6880<LizardFrillVariant> getFrills() {
        return (class_6880)this.field_6011.method_12789(FRILL_VARIANT);
    }

    public void setFrills(class_6880<LizardFrillVariant> variant) {
        this.field_6011.method_12778(FRILL_VARIANT, variant);
    }

    public class_6880<LizardHornVariant> getHorns() {
        return (class_6880)this.field_6011.method_12789(HORN_VARIANT);
    }

    public void setHorns(class_6880<LizardHornVariant> variant) {
        this.field_6011.method_12778(HORN_VARIANT, variant);
    }

    protected class_3414 method_5994() {
        return SpectrumSoundEvents.ENTITY_LIZARD_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return SpectrumSoundEvents.ENTITY_LIZARD_HURT;
    }

    protected class_3414 method_6002() {
        return SpectrumSoundEvents.ENTITY_LIZARD_DEATH;
    }

    public boolean method_6481(class_1799 stack) {
        if (stack.method_31574(SpectrumItems.LIZARD_MEAT)) {
            return false;
        }
        return stack.method_31573(class_3489.field_49932);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        LizardEntity other = (LizardEntity)entity;
        LizardEntity child = (LizardEntity)SpectrumEntityTypes.LIZARD.method_5883((class_1937)world);
        if (child != null) {
            child.setColor(this.getChildColor(this, other));
            child.setFrills(this.getChildFrills(this, other));
            child.setHorns(this.getChildHorns(this, other));
        }
        return child;
    }

    private InkColor getChildColor(LizardEntity firstParent, LizardEntity secondParent) {
        class_1937 world = firstParent.method_37908();
        InkColor color1 = firstParent.getColor();
        InkColor color2 = secondParent.getColor();
        return InkColorMixes.getRandomMixedColor(color1, color2, world.field_9229);
    }

    private class_6880<LizardFrillVariant> getChildFrills(LizardEntity firstParent, LizardEntity secondParent) {
        class_1937 world = this.method_37908();
        return world.field_9229.method_43056() ? firstParent.getFrills() : secondParent.getFrills();
    }

    private class_6880<LizardHornVariant> getChildHorns(LizardEntity firstParent, LizardEntity secondParent) {
        class_1937 world = this.method_37908();
        return world.field_9229.method_43056() ? firstParent.getHorns() : secondParent.getHorns();
    }

    @Override
    public boolean hasOthersInGroup() {
        return this.groupSize > 1;
    }

    @Override
    @Nullable
    public LizardEntity getLeader() {
        return this.leader;
    }

    @Override
    public boolean isCloseEnoughToLeader() {
        return this.method_5858((class_1297)this.leader) <= 121.0;
    }

    @Override
    public void leaveGroup() {
        this.leader.decreaseGroupSize();
        this.leader = null;
    }

    @Override
    public void moveTowardLeader() {
        if (this.hasLeader()) {
            this.method_5942().method_6335((class_1297)this.leader, 1.0);
        }
    }

    @Override
    public int getMaxGroupSize() {
        return super.method_5945();
    }

    @Override
    public void joinGroupOf(LizardEntity groupLeader) {
        this.leader = groupLeader;
        groupLeader.increaseGroupSize();
    }

    @Override
    public int getGroupSize() {
        return this.groupSize;
    }

    protected void increaseGroupSize() {
        ++this.groupSize;
    }

    protected void decreaseGroupSize() {
        --this.groupSize;
    }

    @Override
    public class_6862<class_4158> getPOITag() {
        return SpectrumPointOfInterestTypeTags.LIZARD_DENS;
    }

    @Override
    @Nullable
    public class_2338 getPOIPos() {
        return this.poiPos;
    }

    @Override
    public void setPOIPos(@Nullable class_2338 blockPos) {
        this.poiPos = blockPos;
    }

    private class FindPOIGoal
    extends class_1352 {
        FindPOIGoal(class_5321<class_4158> poiType, int maxDistance) {
        }

        public boolean method_6264() {
            return LizardEntity.this.hasOthersInGroup() && LizardEntity.this.ticksLeftToFindPOI == 0 && !LizardEntity.this.isPOIValid((class_3218)LizardEntity.this.method_37908());
        }

        public void method_6269() {
            LizardEntity.this.ticksLeftToFindPOI = 200;
            LizardEntity.this.poiPos = LizardEntity.this.findNearestPOI((class_3218)LizardEntity.this.method_37908(), LizardEntity.this.method_24515(), 40);
        }
    }

    protected class ClanLeaderWanderAroundGoal
    extends class_1379 {
        int chanceToNavigateToPOI;
        int maxDistanceFromPOI;

        public ClanLeaderWanderAroundGoal(class_1314 mob, double speed, int chance, int chanceToNavigateToPOI, int maxDistanceFromPOI) {
            super(mob, speed, chance);
            this.chanceToNavigateToPOI = chanceToNavigateToPOI;
            this.maxDistanceFromPOI = maxDistanceFromPOI;
        }

        public boolean method_6264() {
            return !LizardEntity.this.hasLeader() && super.method_6264();
        }

        @Nullable
        protected class_243 method_6302() {
            if (LizardEntity.this.field_5974.method_43057() < (float)this.chanceToNavigateToPOI && LizardEntity.this.isPOIValid((class_3218)LizardEntity.this.method_37908()) && !LizardEntity.this.method_24515().method_19771((class_2382)LizardEntity.this.poiPos, (double)this.maxDistanceFromPOI)) {
                return class_243.method_24953((class_2382)LizardEntity.this.poiPos);
            }
            return class_5532.method_31510((class_1314)LizardEntity.this, (int)8, (int)7);
        }
    }
}

