/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import de.dafuqs.spectrum.api.interaction.ItemProvider;
import de.dafuqs.spectrum.api.interaction.ItemProviderRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1798;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Triplet;

public class BuildingHelper {
    private static final Map<class_6862<class_2248>, List<class_2248>> SIMILAR_BLOCKS = new HashMap<class_6862<class_2248>, List<class_2248>>(){
        {
            this.put(class_3481.field_29822, new ArrayList<class_2248>(){
                {
                    this.add(class_2246.field_10219);
                }
            });
            this.put(class_3481.field_21953, new ArrayList<class_2248>(){
                {
                    this.add(class_2246.field_10515);
                }
            });
        }
    };
    private static final Map<class_2248, List<class_2248>> SIMILAR_BLOCKS_CACHE = new HashMap<class_2248, List<class_2248>>();
    private static final ArrayList<class_2382> NEIGHBOR_VECTORS_Y = new ArrayList<class_2382>(){
        {
            this.add(class_2350.field_11043.method_10163());
            this.add(class_2350.field_11034.method_10163());
            this.add(class_2350.field_11035.method_10163());
            this.add(class_2350.field_11039.method_10163());
            this.add(class_2350.field_11039.method_10163().method_35851(class_2350.field_11043));
            this.add(class_2350.field_11043.method_10163().method_35851(class_2350.field_11034));
            this.add(class_2350.field_11034.method_10163().method_35851(class_2350.field_11035));
            this.add(class_2350.field_11035.method_10163().method_35851(class_2350.field_11039));
        }
    };

    public static Triplet<class_2248, class_1792, Integer> getBuildingItemCountInInventoryIncludingSimilars(class_1657 player, class_2248 block, long maxCount) {
        class_1792 blockItem = block.method_8389();
        if (blockItem instanceof class_1798) {
            class_1798 aliasedBlockItem = (class_1798)blockItem;
            return new Triplet((Object)block, (Object)aliasedBlockItem, (Object)0);
        }
        for (class_2248 similarBlock : BuildingHelper.getSimilarBlocks(block)) {
            class_1792 similarBlockItem = similarBlock.method_8389();
            class_1661 playerInventory = player.method_31548();
            int similarCount = playerInventory.method_18861(similarBlockItem);
            for (int i = 0; i < playerInventory.method_5439(); ++i) {
                class_1799 currentStack = playerInventory.method_5438(i);
                ItemProvider itemProvider = ItemProviderRegistry.getProvider(currentStack);
                if (itemProvider == null) continue;
                similarCount += itemProvider.getItemCount(player, currentStack, similarBlockItem);
            }
            if (similarCount <= 0) continue;
            return new Triplet((Object)similarBlock, (Object)similarBlockItem, (Object)((int)Math.min((long)similarCount, maxCount)));
        }
        return new Triplet((Object)block, (Object)blockItem, (Object)0);
    }

    @NotNull
    public static List<class_2338> getConnectedBlocks(@NotNull class_1937 world, @NotNull class_2338 blockPos, long maxCount, int maxRange) {
        class_2338 currentPos;
        class_2680 originState = world.method_8320(blockPos);
        class_2248 originBlock = originState.method_26204();
        ArrayList<class_2338> connectedPositions = new ArrayList<class_2338>();
        ArrayList<class_2338> visitedPositions = new ArrayList<class_2338>();
        LinkedList<class_2338> positionsToVisit = new LinkedList<class_2338>();
        connectedPositions.add(blockPos);
        visitedPositions.add(blockPos);
        positionsToVisit.add(blockPos);
        block0: while ((long)connectedPositions.size() < maxCount && (currentPos = (class_2338)positionsToVisit.poll()) != null) {
            for (class_2350 direction : class_2350.values()) {
                class_2248 localBlock;
                class_2338 offsetPos = currentPos.method_10093(direction);
                if (visitedPositions.contains(offsetPos)) continue;
                visitedPositions.add(offsetPos);
                if (!blockPos.method_19771((class_2382)offsetPos, (double)maxRange) || !BuildingHelper.getSimilarBlocks(localBlock = world.method_8320(offsetPos).method_26204()).contains(originBlock)) continue;
                positionsToVisit.add(offsetPos);
                connectedPositions.add(offsetPos);
                if ((long)connectedPositions.size() >= maxCount) continue block0;
            }
        }
        return connectedPositions;
    }

    @NotNull
    public static List<class_2338> calculateBuildingStaffSelection(@NotNull class_1937 world, @NotNull class_2338 originPos, class_2350 direction, long maxCount, int maxRange, boolean sameBlockOnly) {
        class_2338 offsetPos = originPos.method_10093(direction);
        class_2680 originState = world.method_8320(originPos);
        ArrayList<class_2338> selectedPositions = new ArrayList<class_2338>();
        int count = 1;
        ArrayList<Object> storedNeighbors = new ArrayList<Object>();
        if (world.method_8628(originState, offsetPos, class_3726.method_16194())) {
            storedNeighbors.add(offsetPos);
        }
        while ((long)count < maxCount && !storedNeighbors.isEmpty()) {
            selectedPositions.addAll(storedNeighbors);
            ArrayList<class_2338> newNeighbors = new ArrayList<class_2338>();
            for (class_2338 class_23382 : storedNeighbors) {
                List<class_2338> facingNeighbors = BuildingHelper.getValidNeighbors(world, class_23382, direction, originState, sameBlockOnly);
                for (class_2338 facingNeighbor : facingNeighbors) {
                    if ((long)count >= maxCount || !originPos.method_19771((class_2382)facingNeighbor, (double)maxRange) || selectedPositions.contains(facingNeighbor) || storedNeighbors.contains(facingNeighbor) || newNeighbors.contains(facingNeighbor)) continue;
                    newNeighbors.add(facingNeighbor);
                    ++count;
                }
            }
            storedNeighbors.clear();
            storedNeighbors.addAll(newNeighbors);
        }
        selectedPositions.addAll(storedNeighbors);
        return selectedPositions;
    }

    @NotNull
    private static List<class_2338> getValidNeighbors(class_1937 world, class_2338 startPos, class_2350 facingDirection, class_2680 originState, boolean similarBlockOnly) {
        ArrayList<class_2338> foundNeighbors = new ArrayList<class_2338>();
        for (class_2382 neighborVectors : BuildingHelper.getNeighborVectors(facingDirection)) {
            class_2338 targetPos = startPos.method_10081(neighborVectors);
            class_2680 targetState = world.method_8320(targetPos);
            class_2680 facingAgainstState = world.method_8320(targetPos.method_10093(facingDirection.method_10153()));
            if (!targetState.method_45474() && targetState.method_26227().method_15769() || !world.method_8628(originState, targetPos, class_3726.method_16194())) continue;
            if (similarBlockOnly) {
                if (!BuildingHelper.getSimilarBlocks(facingAgainstState.method_26204()).contains(originState.method_26204())) continue;
                foundNeighbors.add(targetPos);
                continue;
            }
            if (facingAgainstState.method_26215()) continue;
            foundNeighbors.add(targetPos);
        }
        return foundNeighbors;
    }

    @NotNull
    private static List<class_2382> getNeighborVectors(final @NotNull class_2350 direction) {
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return NEIGHBOR_VECTORS_Y;
        }
        return new ArrayList<class_2382>(){
            {
                this.add(direction.method_10170().method_10163());
                this.add(direction.method_10160().method_10163());
                this.add(class_2350.field_11036.method_10163());
                this.add(class_2350.field_11033.method_10163());
            }
        };
    }

    private static List<class_2248> getSimilarBlocks(final class_2248 block) {
        ArrayList<class_2248> similarBlocks = SIMILAR_BLOCKS_CACHE.get(block);
        if (similarBlocks == null) {
            similarBlocks = new ArrayList<class_2248>(){
                {
                    this.add(block);
                    for (Map.Entry<class_6862<class_2248>, List<class_2248>> entry : SIMILAR_BLOCKS.entrySet()) {
                        if (!block.method_9564().method_26164(entry.getKey())) continue;
                        this.addAll((Collection)entry.getValue());
                    }
                }
            };
            SIMILAR_BLOCKS_CACHE.put(block, (List<class_2248>)similarBlocks);
        }
        return similarBlocks;
    }
}

