/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import de.dafuqs.spectrum.helpers.Orientation;
import de.dafuqs.spectrum.particle.VectorPattern;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class ParticleHelper {
    public static void playParticleWithPatternAndVelocityClient(class_1937 world, class_243 position, class_2394 particleEffect, @NotNull VectorPattern pattern, double velocity) {
        for (class_243 vec3d : pattern.getVectors()) {
            world.method_8406(particleEffect, position.method_10216(), position.method_10214(), position.method_10215(), vec3d.field_1352 * velocity, vec3d.field_1351 * velocity, vec3d.field_1350 * velocity);
        }
    }

    public static void playParticleWithRotation(class_1937 world, class_243 position, double longitude, double latitude, class_2394 particleEffect, @NotNull VectorPattern pattern, double velocity) {
        for (class_243 vec3d : pattern.getVectors()) {
            double length = vec3d.method_1033();
            Orientation orientation = Orientation.getVectorOrientation(vec3d).add(longitude, latitude);
            vec3d = orientation.toVector(length);
            world.method_8406(particleEffect, position.method_10216(), position.method_10214(), position.method_10215(), vec3d.field_1352 * velocity, vec3d.field_1351 * velocity, vec3d.field_1350 * velocity);
        }
    }

    public static void playTriangulatedParticle(class_1937 world, class_2394 particleEffect, int quantity, boolean triangular, class_243 scale, double bonusYOffset, boolean solidSpawns, class_243 position, class_243 velocity) {
        class_5819 random = world.method_8409();
        for (int i = 0; i < quantity; ++i) {
            double f;
            double e;
            double d;
            if (triangular) {
                d = random.method_43385(0.0, scale.field_1352);
                e = random.method_43385(0.0, scale.field_1351) + bonusYOffset;
                f = random.method_43385(0.0, scale.field_1350);
            } else {
                d = random.method_43058() * 2.0 * scale.field_1352 - scale.field_1352;
                e = random.method_43058() * 2.0 * scale.field_1351 - scale.field_1351 + -bonusYOffset;
                f = random.method_43058() * 2.0 * scale.field_1350 - scale.field_1350;
            }
            if (!solidSpawns && world.method_22347(class_2338.method_49638((class_2374)position))) continue;
            world.method_8406(particleEffect, position.method_10216() + d, position.method_10214() + e, position.method_10215() + f, velocity.method_10216(), velocity.method_10214(), velocity.method_10215());
        }
    }

    public static void playParticleAroundBlockSides(class_1937 world, class_2394 particleEffect, class_2338 position, class_2350[] sides, int quantity, class_243 velocity) {
        ParticleHelper.playParticleAroundBlockSides(world, particleEffect, position, List.of(sides), quantity, velocity);
    }

    public static void playParticleAroundBlockSides(class_1937 world, class_2394 particleEffect, class_2338 position, List<class_2350> sides, int quantity, class_243 velocity) {
        class_5819 random = world.method_8409();
        for (class_2350 direction : sides) {
            class_2338 blockPos = position.method_10093(direction);
            class_2680 state = world.method_8320(blockPos);
            if (state.method_26225() && state.method_26206((class_1922)world, blockPos, direction.method_10153())) continue;
            for (int i = 0; i < quantity; ++i) {
                double d = direction.method_10148() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10148() * 0.6;
                double e = direction.method_10164() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10164() * 0.6;
                double f = direction.method_10165() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10165() * 0.6;
                world.method_8406(particleEffect, (double)position.method_10263() + d, (double)position.method_10264() + e, (double)position.method_10260() + f, velocity.method_10216(), velocity.method_10214(), velocity.method_10215());
            }
        }
    }
}

