/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1751;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class SpectrumEnchantmentHelper {
    public static class_3545<Boolean, class_1799> addOrUpgradeEnchantment(class_7225.class_7874 registryLookup, class_1799 stack, class_5321<class_1887> enchantmentKey, int level, boolean forceEvenIfNotApplicable, boolean allowEnchantmentConflicts) {
        return SpectrumEnchantmentHelper.getEntry(registryLookup, enchantmentKey).map(entry -> SpectrumEnchantmentHelper.addOrUpgradeEnchantment(stack, (class_6880<class_1887>)entry, level, forceEvenIfNotApplicable, allowEnchantmentConflicts)).orElse(new class_3545((Object)false, (Object)stack));
    }

    public static Optional<class_1799> addOrUpgradeEnchantmentOpt(class_7225.class_7874 registryLookup, class_1799 stack, class_5321<class_1887> enchantmentKey, int level, boolean forceEvenIfNotApplicable, boolean allowEnchantmentConflicts) {
        class_3545<Boolean, class_1799> result = SpectrumEnchantmentHelper.addOrUpgradeEnchantment(registryLookup, stack, enchantmentKey, level, forceEvenIfNotApplicable, allowEnchantmentConflicts);
        return (Boolean)result.method_15442() != false ? Optional.empty() : Optional.of((class_1799)result.method_15441());
    }

    public static class_3545<Boolean, class_1799> addOrUpgradeEnchantment(class_1799 stack, class_6880<class_1887> enchantment, int level, boolean forceEvenIfNotApplicable, boolean allowEnchantmentConflicts) {
        class_9304.class_9305 builder;
        boolean isEnchantedBook;
        boolean isAcceptable = stack.canBeEnchantedWith(enchantment, EnchantingContext.ACCEPTABLE) || forceEvenIfNotApplicable;
        boolean isConflicting = !allowEnchantmentConflicts && !class_1890.method_8201((Collection)stack.method_58657().method_57534(), enchantment);
        boolean bl = isEnchantedBook = stack.method_31574(class_1802.field_8598) || SpectrumEnchantmentHelper.isEnchantableBook(stack);
        if (!isAcceptable && !isEnchantedBook) {
            return new class_3545((Object)false, (Object)stack);
        }
        if (isConflicting) {
            return new class_3545((Object)false, (Object)stack);
        }
        if (isEnchantedBook && !stack.method_31574(class_1802.field_8598)) {
            class_1799 enchantedBookStack = new class_1799((class_1935)class_1802.field_8598, stack.method_7947());
            enchantedBookStack.method_59692(stack.method_57380());
            stack = enchantedBookStack;
        }
        if (level <= (builder = new class_9304.class_9305(class_1890.method_57532((class_1799)stack))).method_57546(enchantment)) {
            return new class_3545((Object)false, (Object)stack);
        }
        builder.method_57547(enchantment, level);
        class_1890.method_57530((class_1799)stack, (class_9304)builder.method_57549());
        return new class_3545((Object)true, (Object)stack);
    }

    public static boolean isEnchantableBook(@NotNull class_1799 stack) {
        return stack.method_31573(SpectrumItemTags.ENCHANTABLE_BOOKS) || stack.method_7909() instanceof class_1751;
    }

    public static class_9304 collectHighestEnchantments(List<class_1799> itemStacks) {
        class_9304.class_9305 builder = new class_9304.class_9305(class_9304.field_49385);
        for (class_1799 itemStack : itemStacks) {
            for (Object2IntMap.Entry entry : class_1890.method_57532((class_1799)itemStack).method_57539()) {
                builder.method_57550((class_6880)entry.getKey(), entry.getIntValue());
            }
        }
        return builder.method_57549();
    }

    public static boolean canCombineAny(class_1799 existingStack, class_1799 newStack) {
        Set existingEnchantments = class_1890.method_57532((class_1799)existingStack).method_57534();
        Set newEnchantments = class_1890.method_57532((class_1799)newStack).method_57534();
        return existingEnchantments.isEmpty() || newEnchantments.stream().anyMatch(newEnchantment -> class_1890.method_8201((Collection)existingEnchantments, (class_6880)newEnchantment));
    }

    @SafeVarargs
    public static class_3545<class_1799, Integer> removeEnchantments(class_7225.class_7874 registryLookup, @NotNull class_1799 itemStack, class_5321<class_1887> ... enchantmentKeys) {
        if (!class_1890.method_58117((class_1799)itemStack)) {
            return new class_3545((Object)itemStack, (Object)0);
        }
        class_7225.class_7226 wrapper = SpectrumEnchantmentHelper.getRegistry(registryLookup).orElse(null);
        if (wrapper == null) {
            return new class_3545((Object)itemStack, (Object)0);
        }
        return SpectrumEnchantmentHelper.removeEnchantments(itemStack, Arrays.stream(enchantmentKeys).map(key -> wrapper.method_46746(key).orElse(null)).filter(Objects::nonNull).toList());
    }

    @SafeVarargs
    public static class_3545<class_1799, Integer> removeEnchantments(@NotNull class_1799 itemStack, class_6880<class_1887> ... enchantments) {
        return SpectrumEnchantmentHelper.removeEnchantments(itemStack, Arrays.stream(enchantments).toList());
    }

    public static <T extends class_6880<class_1887>> class_3545<class_1799, Integer> removeEnchantments(@NotNull class_1799 itemStack, List<T> enchantments) {
        AtomicInteger removals = new AtomicInteger(0);
        class_9304.class_9305 builder = new class_9304.class_9305(class_1890.method_57532((class_1799)itemStack));
        enchantments.forEach(enchantment -> {
            if (builder.method_57545().contains(enchantment)) {
                builder.method_57547(enchantment, 0);
                removals.getAndIncrement();
            }
        });
        class_9304 component = builder.method_57549();
        if (itemStack.method_31574(class_1802.field_8598) && component.method_57543()) {
            itemStack = new class_1799((class_1935)class_1802.field_8529, itemStack.method_7947());
        }
        class_1890.method_57530((class_1799)itemStack, (class_9304)builder.method_57549());
        return new class_3545((Object)itemStack, (Object)removals.get());
    }

    public static class_1799 getEnchantedStack(class_7225.class_7874 lookup, class_1792 item, Map<class_5321<class_1887>, Integer> enchantments) {
        class_7225.class_7226 wrapper = lookup.method_46762(class_7924.field_41265);
        class_9304.class_9305 builder = new class_9304.class_9305(class_9304.field_49385);
        for (Map.Entry<class_5321<class_1887>, Integer> e : enchantments.entrySet()) {
            builder.method_57550((class_6880)wrapper.method_46747(e.getKey()), e.getValue().intValue());
        }
        class_1799 stack = item.method_7854();
        stack.method_57379(class_9334.field_49633, (Object)builder.method_57549());
        return stack;
    }

    public static int getLevel(class_7225.class_7874 registryLookup, class_5321<class_1887> enchantment, class_1799 stack) {
        return SpectrumEnchantmentHelper.getRegistry(registryLookup).flatMap(impl -> impl.method_46746(enchantment)).map(entry -> class_1890.method_8225((class_6880)entry, (class_1799)stack)).orElse(0);
    }

    public static boolean hasEnchantment(class_7225.class_7874 registryLookup, class_5321<class_1887> enchantment, class_1799 stack) {
        return SpectrumEnchantmentHelper.getLevel(registryLookup, enchantment, stack) > 0;
    }

    public static Optional<class_7225.class_7226<class_1887>> getRegistry(class_7225.class_7874 registryLookup) {
        return registryLookup.method_46759(class_7924.field_41265);
    }

    public static Optional<class_6880<class_1887>> getEntry(class_7225.class_7874 lookup, class_5321<class_1887> key) {
        return SpectrumEnchantmentHelper.getRegistry(lookup).flatMap(impl -> impl.method_46746(key));
    }

    public static int getEquipmentLevel(class_7225.class_7874 lookup, class_5321<class_1887> key, class_1309 entity) {
        return SpectrumEnchantmentHelper.getEntry(lookup, key).map(e -> class_1890.method_8203((class_6880)e, (class_1309)entity)).orElse(0);
    }

    public static boolean canEntityUse(class_1297 entity, String idAsString) {
        if (entity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)entity;
            if (((String)idAsString).contains("razing") || ((String)idAsString).contains("resonance") || ((String)idAsString).contains("voiding")) {
                idAsString = (String)idAsString + "_usage";
            }
            return AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)SpectrumCommon.locate("unlocks/enchantments/" + ((String)idAsString).substring(((String)idAsString).indexOf(58) + 1)));
        }
        return false;
    }
}

