/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.registries.SpectrumStatusEffectTags;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import net.minecraft.class_1293;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

public class StatusEffectHelper {
    private static final StatusEffectBackground DIVINITY = new StatusEffectBackground("divinity");
    private static final StatusEffectBackground SEVERE = new StatusEffectBackground("severe");
    private static final StatusEffectBackground NIGHT_ALCHEMY = new StatusEffectBackground("night_alchemy");

    public static class_2960 getTextureLocation(class_2960 original, class_1293 effect, RenderType renderType) {
        class_6880 type = effect.method_5579();
        if (type == SpectrumStatusEffects.DIVINITY) {
            return DIVINITY.get(renderType);
        }
        if (StatusEffectHelper.isSevere(effect) && type != SpectrumStatusEffects.ETERNAL_SLUMBER && type != SpectrumStatusEffects.FATAL_SLUMBER) {
            return SEVERE.get(renderType);
        }
        if (type.method_40220(SpectrumStatusEffectTags.NIGHT_ALCHEMY)) {
            return NIGHT_ALCHEMY.get(renderType);
        }
        return original;
    }

    public static boolean isSevere(class_1293 instance) {
        class_6880 type = instance.method_5579();
        if (type.method_40220(SpectrumStatusEffectTags.CANNOT_BE_SEVERE)) {
            return false;
        }
        return instance.spectrum$isSevere();
    }

    public record StatusEffectBackground(class_2960 guiLarge, class_2960 guiSmall, class_2960 hudDefault, class_2960 hudAmbient) {
        public StatusEffectBackground(String name) {
            this(SpectrumCommon.locate("container/inventory/" + name + "_effect_background_gui_large"), SpectrumCommon.locate("container/inventory/" + name + "_effect_background_gui_small"), SpectrumCommon.locate("hud/" + name + "_effect_background_hud_default"), SpectrumCommon.locate("hud/" + name + "_effect_background_hud_ambient"));
        }

        public class_2960 get(RenderType type) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.guiLarge;
                case 1 -> this.guiSmall;
                case 2 -> this.hudDefault;
                case 3 -> this.hudAmbient;
            };
        }
    }

    public static enum RenderType {
        GUI_LARGE,
        GUI_SMALL,
        HUD_DEFAULT,
        HUD_AMBIENT;

    }
}

