/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import de.dafuqs.spectrum.helpers.CollisionResult;
import de.dafuqs.spectrum.helpers.Orientation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class VectorCast {
    protected final class_243 start;
    protected final class_243 end;
    protected float radius;

    public VectorCast(class_243 start, class_243 end, float radius) {
        this.start = start;
        this.end = end;
        this.radius = radius;
    }

    public List<CollisionResult<class_1297>> castForEntities(class_3218 world, Predicate<class_1297> preCollisionTestFiltering, class_1297 ... except) {
        class_243 ray = this.getRelativeToOrigin(this.end);
        class_238 casterBox = new class_238(this.start, this.end).method_1014(ray.method_1033() / 2.0);
        List entities = world.method_8390(class_1297.class, casterBox, preCollisionTestFiltering);
        List<class_1297> exceptSet = Arrays.asList(except);
        return entities.stream().filter(entity -> !exceptSet.contains(entity)).map(entity -> this.processEntity(ray, (class_1297)entity, world)).filter(Optional::isPresent).map(Optional::get).toList();
    }

    public List<CollisionResult<class_2338>> castForBlocks(class_3218 world, class_1297 except, BiPredicate<class_3218, class_2338> preCollisionTestFiltering) {
        class_2338 blockStart = class_2338.method_49638((class_2374)this.start);
        class_2338 blockEnd = class_2338.method_49638((class_2374)this.end);
        class_243 ray = this.getRelativeToOrigin(this.end);
        Iterable iterableBlocks = class_2338.method_10097((class_2338)blockStart, (class_2338)blockEnd);
        ArrayList<CollisionResult<class_2338>> collisions = new ArrayList<CollisionResult<class_2338>>();
        iterableBlocks.forEach(blockPos -> {
            if (!preCollisionTestFiltering.test(world, blockEnd)) {
                return;
            }
            Optional<CollisionResult<class_2338>> collisionResult = this.processBlock(ray, (class_2338)blockPos, world);
            collisionResult.ifPresent(collisions::add);
        });
        return collisions;
    }

    private Optional<CollisionResult<class_1297>> processEntity(class_243 ray, class_1297 entity, class_3218 world) {
        class_243 closestPointToIntercept;
        boolean hit = false;
        class_238 hitbox = entity.method_5829().method_1014((double)this.radius);
        if (hitbox.method_1006(this.end)) {
            closestPointToIntercept = this.end;
            hit = true;
        } else if (hitbox.method_1006(this.start)) {
            closestPointToIntercept = this.start;
            hit = true;
        } else {
            Orientation orientation = this.getOrientation();
            class_243 entityOrigin = this.getRelativeToOrigin(hitbox.method_1005());
            double product = ray.method_1026(entityOrigin);
            double vectorAngle = Math.acos(product / (ray.method_1033() * entityOrigin.method_1033()));
            double entityOffset = Math.abs(Math.cos(vectorAngle) * entityOrigin.method_1033());
            closestPointToIntercept = new class_243(entityOffset * Math.sin(orientation.getLongitude()) * Math.cos(orientation.getLatitude()) + this.start.field_1352, entityOffset * Math.sin(orientation.getLongitude()) * Math.sin(orientation.getLatitude()) + this.start.field_1351, entityOffset * Math.cos(orientation.getLongitude()) + this.start.field_1350);
            hit = hitbox.method_1006(closestPointToIntercept);
        }
        if (hit) {
            return Optional.of(new CollisionResult<class_1297>((class_1937)world, entity, entity instanceof class_1309 ? CollisionResult.CollisionType.LIVING : CollisionResult.CollisionType.NON_LIVING, closestPointToIntercept));
        }
        return Optional.empty();
    }

    private Optional<CollisionResult<class_2338>> processBlock(class_243 ray, class_2338 pos, class_3218 world) {
        class_243 closestPointToIntercept;
        boolean hit = false;
        if (this.blockContains(pos, this.end)) {
            closestPointToIntercept = this.end;
            hit = true;
        } else if (this.blockContains(pos, this.start)) {
            closestPointToIntercept = this.start;
            hit = true;
        } else {
            Orientation orientation = this.getOrientation();
            class_243 blockCenter = this.getRelativeToOrigin(class_243.method_24953((class_2382)pos));
            double product = ray.method_1026(blockCenter);
            double vectorAngle = Math.acos(product / (ray.method_1033() * blockCenter.method_1033()));
            double entityOffset = Math.cos(vectorAngle) * blockCenter.method_1033();
            closestPointToIntercept = new class_243(entityOffset * Math.sin(orientation.getLatitude()) * Math.cos(orientation.getLongitude()) + this.start.field_1352, entityOffset * Math.sin(orientation.getLatitude()) * Math.sin(orientation.getLongitude()) + this.start.field_1351, entityOffset * Math.cos(orientation.getLatitude()) + this.start.field_1350);
            hit = this.blockContains(pos, closestPointToIntercept);
        }
        if (hit) {
            return Optional.of(new CollisionResult<class_2338>((class_1937)world, pos, CollisionResult.CollisionType.BLOCK, closestPointToIntercept));
        }
        return Optional.empty();
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public boolean blockContains(class_2338 pos, class_243 point) {
        return (double)((float)pos.method_10263() - this.radius) <= point.method_10216() && point.method_10216() <= (double)((float)(pos.method_10263() + 1) + this.radius) && (double)((float)pos.method_10264() - this.radius) <= point.method_10214() && point.method_10214() <= (double)((float)(pos.method_10264() + 1) + this.radius) && (double)((float)pos.method_10260() - this.radius) <= point.method_10215() && point.method_10215() <= (double)((float)(pos.method_10260() + 1) + this.radius);
    }

    public Orientation getOrientation() {
        class_243 vector = this.getRelativeToOrigin(this.end);
        return Orientation.fromVector(vector);
    }

    public class_243 getRelativeToOrigin(class_243 vector) {
        return vector.method_1020(this.start);
    }
}

