/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items;

import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.InkPoweredStatusEffectInstance;
import de.dafuqs.spectrum.api.item.InkPoweredPotionFillable;
import de.dafuqs.spectrum.items.food.DrinkItem;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_4174;
import net.minecraft.class_5536;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public class ConcealingOilsItem
extends DrinkItem
implements InkPoweredPotionFillable {
    public static final int POISONED_COLOUR = 4002085;

    public ConcealingOilsItem(class_1792.class_1793 settings) {
        super(settings);
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        if (!InkPoweredPotionFillable.getEffects(stack).isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.concealing_oils.tooltip").method_27694(s -> s.method_27706(class_124.field_1080).method_10978(Boolean.valueOf(true))));
        }
        this.appendPotionFillableTooltip(stack, tooltip, class_2561.method_43471((String)"item.spectrum.concealing_oils.when_poisoned"), true, context.method_59531());
    }

    public boolean method_31565(class_1799 oilsStack, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType != class_5536.field_27014) {
            return false;
        }
        class_1799 stackToApplyTo = slot.method_7677();
        if (!stackToApplyTo.method_57826(class_9334.field_50075)) {
            return false;
        }
        if (!this.isFull(oilsStack)) {
            return false;
        }
        if (this.tryApplyOil(oilsStack, stackToApplyTo, player)) {
            if (!player.method_31549().field_7477) {
                oilsStack.method_7934(1);
            }
            player.method_5783(class_3417.field_14826, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private boolean tryApplyOil(class_1799 oilsStack, class_1799 foodStack, class_1657 user) {
        if (foodStack.method_7909() instanceof DrinkItem) {
            return false;
        }
        if (foodStack.method_57826(SpectrumDataComponentTypes.CONCEALED_EFFECT)) {
            return false;
        }
        InkPoweredStatusEffectInstance effect = InkPoweredPotionFillable.getEffects(oilsStack).getFirst();
        if (!InkPowered.tryDrainEnergy(user, effect.getInkCost().color(), effect.getInkCost().cost())) {
            return false;
        }
        class_4174 foodComponent = (class_4174)foodStack.method_57824(class_9334.field_50075);
        if (foodComponent != null && foodComponent.comp_2495().stream().map(class_4174.class_9423::comp_2496).anyMatch(e -> e.method_55654(effect.getStatusEffectInstance().method_5579()))) {
            return false;
        }
        foodStack.method_57379(class_9334.field_49617, (Object)new class_9296(user.method_7334()));
        foodStack.method_57379(SpectrumDataComponentTypes.CONCEALED_EFFECT, (Object)effect.getStatusEffectInstance());
        return true;
    }

    @Override
    public int maxEffectCount() {
        return 1;
    }

    @Override
    public int maxEffectAmplifier() {
        return 3;
    }
}

