/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.api.item.ExperienceStorageItem;
import de.dafuqs.spectrum.api.item.LoomPatternProvider;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.registries.SpectrumBannerPatterns;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.List;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3902;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class KnowledgeGemItem
extends class_1792
implements ExperienceStorageItem,
LoomPatternProvider {
    private final int maxStorageBase;
    protected final int[] displayTiers = new int[]{1, 10, 25, 50, 100, 250, 500, 1000, 2500, 5000};

    public KnowledgeGemItem(class_1792.class_1793 settings, int maxStorageBase) {
        super(settings);
        this.maxStorageBase = maxStorageBase;
    }

    public static class_1799 getKnowledgeDropStackWithXP(int experience, boolean noStoreTooltip) {
        class_1799 stack = new class_1799((class_1935)SpectrumItems.KNOWLEDGE_GEM);
        stack.method_57379(SpectrumDataComponentTypes.STORED_EXPERIENCE, (Object)experience);
        if (noStoreTooltip) {
            stack.method_57379(SpectrumDataComponentTypes.HIDE_USAGE_TOOLTIP, (Object)class_3902.field_17274);
        }
        return stack;
    }

    @Override
    public int getMaxStoredExperience(class_7225.class_7874 lookup, class_1799 itemStack) {
        int efficiencyLevel = SpectrumEnchantmentHelper.getLevel(lookup, (class_5321<class_1887>)class_1893.field_9131, itemStack);
        return this.maxStorageBase * (int)Math.pow(10.0, Math.min(5, efficiencyLevel));
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int getTransferableExperiencePerTick(class_7225.class_7874 lookup, class_1799 itemStack) {
        int quickChargeLevel = SpectrumEnchantmentHelper.getLevel(lookup, (class_5321<class_1887>)class_1893.field_9098, itemStack);
        return (int)(2.0 * Math.pow(2.0, Math.min(10, quickChargeLevel)));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return Integer.MAX_VALUE;
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        super.method_7852(world, user, stack, remainingUseTicks);
        if (user instanceof class_3222) {
            int experienceToTransfer;
            class_3222 serverPlayerEntity = (class_3222)user;
            int playerExperience = this.getActualPlayerExperience((class_1657)serverPlayerEntity);
            int itemExperience = ExperienceStorageItem.getStoredExperience(stack);
            int transferableExperience = this.getTransferableExperiencePerTick((class_7225.class_7874)world.method_30349(), stack);
            if (serverPlayerEntity.method_5715()) {
                int experienceToTransfer2;
                int maxStorage = this.getMaxStoredExperience((class_7225.class_7874)world.method_30349(), stack);
                int n = experienceToTransfer2 = serverPlayerEntity.method_7337() ? Math.min(transferableExperience, maxStorage - itemExperience) : Math.min(Math.min(transferableExperience, playerExperience), maxStorage - itemExperience);
                if (experienceToTransfer2 > 0 && itemExperience < maxStorage && this.removePlayerExperience((class_1657)serverPlayerEntity, experienceToTransfer2)) {
                    ExperienceStorageItem.addStoredExperience((class_7225.class_7874)world.method_30349(), stack, experienceToTransfer2);
                    if (remainingUseTicks % 4 == 0) {
                        world.method_8396(null, user.method_24515(), class_3417.field_14627, class_3419.field_15248, 0.3f, 0.8f + world.method_8409().method_43057() * 0.4f);
                    }
                }
            } else if (itemExperience > 0 && playerExperience != Integer.MAX_VALUE && (experienceToTransfer = Math.min(Math.min(transferableExperience, itemExperience), Integer.MAX_VALUE - playerExperience)) > 0) {
                if (!serverPlayerEntity.method_7337()) {
                    serverPlayerEntity.method_7255(experienceToTransfer);
                }
                ExperienceStorageItem.removeStoredExperience(stack, experienceToTransfer);
                if (remainingUseTicks % 4 == 0) {
                    world.method_8396(null, user.method_24515(), class_3417.field_14627, class_3419.field_15248, 0.3f, 0.8f + world.method_8409().method_43057() * 0.4f);
                }
            }
        }
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        class_7225.class_7874 lookup = context.method_59527();
        int maxExperience = this.getMaxStoredExperience(lookup, stack);
        int storedExperience = ExperienceStorageItem.getStoredExperience(stack);
        if (storedExperience == 0) {
            tooltip.add((class_2561)class_2561.method_43470((String)"0 ").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43469((String)"item.spectrum.knowledge_gem.tooltip.stored_experience", (Object[])new Object[]{maxExperience}).method_27692(class_124.field_1080)));
        } else {
            tooltip.add((class_2561)class_2561.method_43470((String)(storedExperience + " ")).method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43469((String)"item.spectrum.knowledge_gem.tooltip.stored_experience", (Object[])new Object[]{maxExperience}).method_27692(class_124.field_1080)));
        }
        if (this.shouldDisplayUsageTooltip(stack)) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.knowledge_gem.tooltip.use", (Object[])new Object[]{this.getTransferableExperiencePerTick(lookup, stack)}).method_27692(class_124.field_1080));
            this.addBannerPatternProviderTooltip(tooltip);
        }
    }

    public boolean shouldDisplayUsageTooltip(class_1799 itemStack) {
        return itemStack.method_57826(SpectrumDataComponentTypes.HIDE_USAGE_TOOLTIP);
    }

    public boolean removePlayerExperience(@NotNull class_1657 playerEntity, int experience) {
        if (playerEntity.method_7337()) {
            return true;
        }
        if (this.getActualPlayerExperience(playerEntity) < experience) {
            return false;
        }
        playerEntity.method_7255(-experience);
        return true;
    }

    public boolean changedDisplayTier(int currentStoredExperience, int destinationStoredExperience) {
        return this.getDisplayTierForExperience(currentStoredExperience) != this.getDisplayTierForExperience(destinationStoredExperience);
    }

    public int getDisplayTierForExperience(int experience) {
        for (int i = 0; i < this.displayTiers.length; ++i) {
            if (experience >= this.displayTiers[i]) continue;
            return i;
        }
        return this.displayTiers.length;
    }

    @Override
    public class_5321<class_2582> getPattern() {
        return SpectrumBannerPatterns.KNOWLEDGE_GEM;
    }

    public boolean method_7870(class_1799 stack) {
        return stack.method_7947() == 1;
    }

    public int method_7837() {
        return 5;
    }

    public boolean canBeEnchantedWith(class_1799 stack, class_6880<class_1887> enchantment, EnchantingContext context) {
        return super.canBeEnchantedWith(stack, enchantment, context) || enchantment.method_40225(class_1893.field_9131) || enchantment.method_40225(class_1893.field_9098);
    }

    public int getActualPlayerExperience(class_1657 player) {
        int experience = 0;
        for (int i = 0; i < player.field_7520; ++i) {
            int levelXP = i >= 30 ? 112 + (i - 30) * 9 : (i >= 15 ? 37 + (i - 15) * 5 : 7 + i * 2);
            experience += levelXP;
        }
        int playerExperience = experience;
        int result = player.field_7520 >= 30 ? 112 + (player.field_7520 - 30) * 9 : (player.field_7520 >= 15 ? 37 + (player.field_7520 - 15) * 5 : 7 + player.field_7520 * 2);
        return playerExperience += Math.round(player.field_7510 * (float)result);
    }
}

