/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.api.item.DamageAwareItem;
import de.dafuqs.spectrum.api.item.TickAwareItem;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.sound.PipeBombChargingSoundInstance;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5328;
import net.minecraft.class_5362;
import net.minecraft.class_8103;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class PipeBombItem
extends class_1792
implements DamageAwareItem,
TickAwareItem {
    public PipeBombItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (PipeBombItem.isPrimed(user.method_5998(hand))) {
            return super.method_7836(world, user, hand);
        }
        if (world.field_9236) {
            this.startSoundInstance(user);
        }
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    @Environment(value=EnvType.CLIENT)
    public void startSoundInstance(class_1657 user) {
        class_310.method_1551().method_1483().method_4873((class_1113)new PipeBombChargingSoundInstance(user));
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 55;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        PipeBombItem.prime(stack, world, user.method_19538(), (class_1297)user);
        return stack;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (PipeBombItem.isPrimeTimeElapsed(world, stack)) {
                this.explode(stack, serverWorld, entity.method_19538(), entity);
            }
        }
    }

    @Override
    public void onItemEntityTicked(class_1542 itemEntity) {
        class_3218 world;
        class_1799 stack = itemEntity.method_6983();
        class_1937 class_19372 = itemEntity.method_37908();
        if (class_19372 instanceof class_3218 && PipeBombItem.isPrimeTimeElapsed((class_1937)(world = (class_3218)class_19372), stack)) {
            this.explode(stack, world, itemEntity.method_33571(), null);
        }
    }

    @Override
    public void onItemEntityDamaged(class_1282 source, float amount, class_1542 itemEntity) {
        class_1937 class_19372 = itemEntity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            if (source.method_48789(class_8103.field_42246) || source.method_48789(class_8103.field_42249)) {
                this.explode(itemEntity.method_6983(), world, itemEntity.method_19538(), null);
            }
        }
    }

    private void explode(class_1799 stack, class_3218 world, class_243 pos, @Nullable class_1297 target) {
        stack.method_7934(1);
        class_1297 owner = this.tryGetOwner(stack, world);
        if (target != null) {
            class_1309 living;
            target.method_5643(SpectrumDamageTypes.incandescence((class_1937)world, owner instanceof class_1309 ? (living = (class_1309)owner) : null), 200.0f);
        }
        world.method_55117(null, SpectrumDamageTypes.incandescence((class_1937)world), new class_5362(), pos.method_10216(), pos.method_10214(), pos.method_10215(), 7.5f, true, class_1937.class_7867.field_40888);
    }

    public class_1297 tryGetOwner(class_1799 stack, class_3218 world) {
        class_9296 profile = (class_9296)stack.method_57824(class_9334.field_49617);
        if (profile == null || profile.comp_2411().isEmpty()) {
            return null;
        }
        return world.method_14190((UUID)profile.comp_2411().get());
    }

    public static void prime(class_1799 stack, class_1937 world, class_243 pos, @Nullable class_1297 user) {
        world.method_43128(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), SpectrumSoundEvents.INCANDESCENT_ARM, class_3419.field_15248, 2.0f, 0.9f);
        stack.method_57379(SpectrumDataComponentTypes.TIMESTAMP, (Object)world.method_8510());
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            stack.method_57379(class_9334.field_49617, (Object)new class_9296(player.method_7334()));
        }
    }

    public static boolean isPrimed(class_1799 stack) {
        return stack.method_57824(SpectrumDataComponentTypes.TIMESTAMP) != null;
    }

    public static boolean isPrimeTimeElapsed(class_1937 world, class_1799 stack) {
        Optional<Long> timestamp = PipeBombItem.getPrimeTime(stack);
        if (timestamp.isEmpty()) {
            return false;
        }
        return world.method_8510() - timestamp.get() >= 100L;
    }

    private static Optional<Long> getPrimeTime(class_1799 stack) {
        if (stack.method_57826(SpectrumDataComponentTypes.TIMESTAMP)) {
            return Optional.of((Long)stack.method_57824(SpectrumDataComponentTypes.TIMESTAMP));
        }
        return Optional.empty();
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.pipe_bomb.tooltip").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.pipe_bomb.tooltip2").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.pipe_bomb.tooltip3").method_27692(class_124.field_1080));
    }
}

