/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.map;

import com.mojang.datafixers.util.Pair;
import de.dafuqs.spectrum.helpers.CodecHelper;
import de.dafuqs.spectrum.items.map.StructureLocatorAsync;
import de.dafuqs.spectrum.mixin.accessors.MapStateAccessor;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_17;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_21;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9428;
import org.jetbrains.annotations.Nullable;

public class ArtisansAtlasState
extends class_22 {
    private final MapStateAccessor accessor = (MapStateAccessor)((Object)this);
    private Set<class_2338> targets = new HashSet<class_2338>();
    private class_2338 displayedCenter;
    private class_2960 targetId;
    @Nullable
    private class_2382 displayDelta;
    @Nullable
    private StructureLocatorAsync locator;

    public ArtisansAtlasState(byte scale, boolean locked, class_5321<class_1937> dimension) {
        this(0.0, 0.0, scale, false, false, locked, dimension);
    }

    public ArtisansAtlasState(double centerX, double centerZ, byte scale, boolean showIcons, boolean unlimitedTracking, boolean locked, class_5321<class_1937> dimension) {
        super((int)centerX, (int)centerZ, scale, showIcons, unlimitedTracking, locked, dimension);
        this.displayedCenter = new class_2338((int)centerX, 0, (int)centerZ);
        this.displayDelta = null;
        this.locator = null;
    }

    public ArtisansAtlasState(double centerX, double centerZ, byte scale, boolean showIcons, boolean unlimitedTracking, boolean locked, class_5321<class_1937> dimension, class_2487 nbt) {
        this((int)centerX, (int)centerZ, scale, showIcons, unlimitedTracking, locked, dimension);
        this.displayDelta = class_2382.field_11176;
        this.targetId = nbt.method_10573("targetId", 8) ? class_2960.method_60654((String)nbt.method_10558("targetId")) : null;
        int xDisplay = nbt.method_10573("displayX", 99) ? nbt.method_10550("displayX") : this.displayedCenter.method_10263();
        int zDisplay = nbt.method_10573("displayZ", 99) ? nbt.method_10550("displayZ") : this.displayedCenter.method_10260();
        this.displayedCenter = new class_2338(xDisplay, 0, zDisplay);
        this.targets = new HashSet<class_2338>(CodecHelper.fromNbt(class_2338.field_25064.listOf(), nbt.method_10580("targets"), List.of()));
    }

    @Nullable
    public static Pair<class_2960, class_3449> locateAnyStructureAtBlock(class_3218 world, class_2338 pos) {
        class_2378 registry = world.method_30349().method_33310(class_7924.field_41246).orElse(null);
        if (registry != null) {
            for (class_3195 structure : registry.method_10220().toList()) {
                class_2960 id = registry.method_10221((Object)structure);
                class_3449 start = world.method_27056().method_38854(pos, structure);
                if (start == class_3449.field_16713 || id == null) continue;
                return new Pair((Object)id, (Object)start);
            }
        }
        return null;
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 lookup) {
        nbt = super.method_75(nbt, lookup);
        nbt.method_10556("isArtisansAtlas", true);
        nbt.method_10569("displayX", this.displayedCenter.method_10263());
        nbt.method_10569("displayZ", this.displayedCenter.method_10260());
        if (this.targetId != null) {
            nbt.method_10582("targetId", this.targetId.toString());
        }
        CodecHelper.writeNbt(nbt, "targets", class_2338.field_25064.listOf(), this.targets.stream().toList());
        return nbt;
    }

    public class_22 method_32364() {
        return ArtisansAtlasState.method_32363((double)this.field_116, (double)this.field_115, (byte)((byte)class_3532.method_15340((int)(this.field_119 + 1), (int)0, (int)4)), (boolean)this.accessor.getTrackingPosition(), (boolean)this.accessor.getUnlimitedTracking(), (class_5321)this.field_118);
    }

    public void method_102(class_1657 player, class_1799 stack) {
        if (this.displayDelta != null) {
            class_1937 class_19372;
            if (this.locator == null && this.targetId != null && (class_19372 = player.method_37908()) instanceof class_3218) {
                class_3218 world = (class_3218)class_19372;
                this.startLocator(world);
            }
            this.displayDelta = player.method_24515().method_10059((class_2382)this.displayedCenter);
        } else {
            this.displayedCenter = player.method_24515();
        }
        this.accessor.getDecorations().clear();
        super.method_102(player, stack);
        for (class_2338 target : this.targets) {
            this.addTargetIcon((class_1936)player.method_37908(), target);
        }
    }

    public void method_107(class_6880<class_9428> type, @Nullable class_1936 world, String key, double x, double z, double rotation, @Nullable class_2561 text) {
        int scale = 1 << this.field_119;
        float scaledX = (float)(x - (double)this.displayedCenter.method_10263()) / (float)scale;
        float scaledZ = (float)(z - (double)this.displayedCenter.method_10260()) / (float)scale;
        float squaredDistance = scaledX * scaledX + scaledZ * scaledZ;
        byte scaleByte = (byte)Math.clamp(-16.0 * (0.5 * Math.log(squaredDistance) / Math.log(2.0) - 7.0), -100.0, 0.0);
        byte pixelX = (byte)(scaledX * 2.0f + 0.5f);
        byte pixelZ = (byte)(scaledZ * 2.0f + 0.5f);
        byte rotationByte = (byte)((rotation += rotation < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
        if (this.field_118 == class_1937.field_25180 && world != null) {
            int light = (int)(world.method_8401().method_217() / 10L);
            rotationByte = (byte)(light * light * 34187121 + light * 121 >> 15 & 0xF);
        }
        if (scaledX < -63.0f || scaledZ < -63.0f || scaledX > 63.0f || scaledZ > 63.0f) {
            double borderRotation;
            if (scaledZ >= 63.0f) {
                pixelZ = 127;
                if (scaledX <= -63.0f) {
                    pixelX = -128;
                    borderRotation = -135.0;
                } else if (scaledX >= 63.0f) {
                    pixelX = 127;
                    borderRotation = 135.0;
                } else {
                    borderRotation = 180.0;
                }
            } else if (scaledZ <= -63.0f) {
                pixelZ = -128;
                if (scaledX <= -63.0f) {
                    pixelX = -128;
                    borderRotation = -45.0;
                } else if (scaledX >= 63.0f) {
                    pixelX = 127;
                    borderRotation = 45.0;
                } else {
                    borderRotation = 0.0;
                }
            } else if (scaledX <= -63.0f) {
                pixelX = -128;
                borderRotation = -90.0;
            } else {
                pixelX = 127;
                borderRotation = 90.0;
            }
            if (type.method_55838(class_21.field_91)) {
                type = class_21.field_86;
                rotationByte = 0;
            } else if (type.method_55838(class_21.field_85)) {
                rotationByte = (byte)((borderRotation += borderRotation < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            }
        }
        class_20 icon = new class_20(type, pixelX, pixelZ, rotationByte, Optional.ofNullable(text));
        icon.spectrum$setScale(scaleByte);
        class_20 previousIcon = this.accessor.getDecorations().put(key, icon);
        if (!icon.equals((Object)previousIcon)) {
            if (previousIcon != null && ((class_9428)previousIcon.comp_1842().comp_349()).comp_2518()) {
                this.accessor.setTrackedDecorationCount(this.accessor.getTrackedDecorationCount() - 1);
            }
            if (((class_9428)type.comp_349()).comp_2518()) {
                this.accessor.setTrackedDecorationCount(this.accessor.getTrackedDecorationCount() + 1);
            }
            this.accessor.invokeSetDecorationsDirty();
        }
    }

    public boolean method_108(class_1936 world, class_2338 pos) {
        double x = (double)pos.method_10263() + 0.5;
        double z = (double)pos.method_10260() + 0.5;
        int scale = 1 << this.field_119;
        double scaledX = (x - (double)this.displayedCenter.method_10263()) / (double)scale;
        double scaledZ = (z - (double)this.displayedCenter.method_10260()) / (double)scale;
        if (scaledX >= -63.0 && scaledZ >= -63.0 && scaledX <= 63.0 && scaledZ <= 63.0) {
            class_17 marker = class_17.method_73((class_1922)world, (class_2338)pos);
            if (marker == null) {
                return false;
            }
            String key = marker.method_71();
            if (this.accessor.getBannerMarkers().remove(key, marker)) {
                this.accessor.invokeRemoveDecoration(marker.method_71());
                return true;
            }
            if (!this.method_37343(256)) {
                this.accessor.getBannerMarkers().put(key, marker);
                this.method_107((class_6880<class_9428>)marker.method_72(), world, key, x, z, 180.0, marker.comp_2314().orElse(null));
                return true;
            }
        }
        return false;
    }

    private void addTargetIcon(class_1936 world, class_2338 target) {
        if (target != null) {
            this.method_107((class_6880<class_9428>)class_21.field_85, world, this.getTargetKey(target), target.method_10263(), target.method_10260(), 180.0, null);
        }
    }

    private String getTargetKey(class_2338 start) {
        return String.format("target-%d-%d-%d", start.method_10263(), start.method_10264(), start.method_10260());
    }

    public void startLocator(class_3218 world) {
        if (this.targetId == null) {
            return;
        }
        this.locator = new StructureLocatorAsync(world, this.targetId, 5000L);
    }

    public void cancelLocator() {
        this.locator = null;
    }

    public class_2338 getDisplayedCenter() {
        return this.displayedCenter;
    }

    public void addTarget(class_1936 world, class_2338 pos) {
        this.targets.add(pos);
        this.addTargetIcon(world, pos);
    }

    public void setTargetId(@Nullable class_2960 targetId) {
        if (this.targetId != targetId) {
            this.targetId = targetId;
            this.method_80();
        }
    }

    @Nullable
    public class_2960 getTargetId() {
        return this.targetId;
    }

    @Nullable
    public class_2382 getDisplayDelta() {
        return this.displayDelta;
    }

    public void clearDisplayDelta() {
        if (this.displayDelta != null) {
            int sampleSize = 1 << this.field_119;
            class_2382 remainder = new class_2382(this.displayDelta.method_10263() % sampleSize, 0, this.displayDelta.method_10260() % sampleSize);
            class_2382 delta = this.displayDelta.method_35852(remainder);
            this.displayedCenter = this.displayedCenter.method_10081(delta);
            this.displayDelta = remainder;
            if (this.locator != null) {
                this.locator.ping(this.displayedCenter, this::addTarget);
            }
        } else {
            this.displayDelta = class_2382.field_11176;
        }
    }

    public void updateDimension(class_5321<class_1937> dimension) {
        if (!this.field_118.equals(dimension)) {
            this.field_118 = dimension;
            this.displayDelta = null;
            this.targets.clear();
            this.targetId = null;
            this.method_80();
        }
    }
}

