/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.item.ActivatableItem;
import de.dafuqs.spectrum.api.item.SplitDamageItem;
import de.dafuqs.spectrum.api.render.SlotBackgroundEffectProvider;
import de.dafuqs.spectrum.particle.effect.ColoredCraftingParticleEffect;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class DreamflayerItem
extends class_1829
implements InkPowered,
ActivatableItem,
SplitDamageItem,
SlotBackgroundEffectProvider {
    public static final InkColor USED_COLOR = InkColors.RED;
    public static final long INK_COST_FOR_ACTIVATION = 200L;
    public static final long INK_COST_PER_SECOND = 20L;
    public static final float ARMOR_DIFFERENCE_DAMAGE_MULTIPLIER = 2.5f;
    private final float baseAttackDamage;
    private final float baseAttackSpeed;

    public DreamflayerItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, settings.method_57348(class_1829.method_57394((class_1832)toolMaterial, (int)attackDamage, (float)attackSpeed)));
        this.baseAttackDamage = attackDamage;
        this.baseAttackSpeed = attackSpeed;
    }

    public static float getDamageAfterModifier(float amount, class_1309 attacker, class_1309 target) {
        float damageMultiplier = ((float)target.method_6096() + 2.5f) / ((float)attacker.method_6096() + 2.5f);
        return amount * damageMultiplier;
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        super.method_7852(world, user, stack, remainingUseTicks);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (hand == class_1268.field_5808 && user.method_5715()) {
            boolean isActivated = ActivatableItem.isActivated(stack);
            if (isActivated) {
                this.setActivated(stack, false);
                if (!world.field_9236) {
                    world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), SpectrumSoundEvents.DREAMFLAYER_DEACTIVATE, class_3419.field_15248, 1.0f, 1.0f);
                }
            } else if (InkPowered.tryDrainEnergy(user, USED_COLOR, 200L)) {
                this.setActivated(stack, true);
                if (!world.field_9236) {
                    world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), SpectrumSoundEvents.DREAMFLAYER_ACTIVATE, class_3419.field_15248, 1.0f, 1.0f);
                }
            } else if (!world.field_9236) {
                world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), SpectrumSoundEvents.DREAMFLAYER_DEACTIVATE, class_3419.field_15248, 1.0f, 1.0f);
            }
            return class_1271.method_22430((Object)stack);
        }
        return class_1271.method_22427((Object)stack);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_3222 player;
        super.method_7888(stack, world, entity, slot, selected);
        if (world.field_9236) {
            if (ActivatableItem.isActivated(stack)) {
                class_243 pos = entity.method_19538();
                world.method_8406((class_2394)ColoredCraftingParticleEffect.RED, entity.method_23322(1.0), pos.method_10214() + 1.05, entity.method_23325(1.0), 0.0, 0.1, 0.0);
            }
        } else if (world.method_8510() % 20L == 0L && ActivatableItem.isActivated(stack) && entity instanceof class_3222 && !InkPowered.tryDrainEnergy((class_1657)(player = (class_3222)entity), USED_COLOR, 20L)) {
            this.setActivated(stack, false);
            world.method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), SpectrumSoundEvents.DREAMFLAYER_DEACTIVATE, class_3419.field_15248, 0.8f, 1.0f);
        }
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.dreamflayer.tooltip").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.dreamflayer.tooltip2").method_27692(class_124.field_1080));
        if (ActivatableItem.isActivated(stack)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.dreamflayer.tooltip.activated").method_27692(class_124.field_1080));
        } else {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.dreamflayer.tooltip.deactivated", (Object[])new Object[]{USED_COLOR.getColoredInkName()}).method_27692(class_124.field_1080));
        }
    }

    public boolean allowComponentsUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return this.reequipAnimation(oldStack, newStack);
    }

    private boolean reequipAnimation(class_1799 before, class_1799 after) {
        return !after.method_31574((class_1792)this) || ActivatableItem.isActivated(before) != ActivatableItem.isActivated(after);
    }

    @Override
    public void setActivated(class_1799 stack, boolean active) {
        if (ActivatableItem.isActivated(stack) != active) {
            float damage = this.baseAttackDamage * (active ? 1.5f : 1.0f);
            float speed = this.baseAttackSpeed * (active ? 0.75f : 1.0f);
            stack.method_57368(class_9334.field_49636, (Object)class_9285.field_49326, comp -> {
                class_9285.class_9286 builder = class_9285.method_57480();
                for (class_9285.class_9287 entry : comp.comp_2393()) {
                    if (entry.comp_2396().method_60718(field_8006)) {
                        builder.method_57487(class_5134.field_23721, new class_1322(field_8006, (double)damage, class_1322.class_1323.field_6328), class_9274.field_49217);
                    }
                    if (entry.comp_2396().method_60718(field_8001)) {
                        builder.method_57487(class_5134.field_23723, new class_1322(field_8001, (double)speed, class_1322.class_1323.field_6328), class_9274.field_49217);
                        continue;
                    }
                    builder.method_57487(entry.comp_2395(), entry.comp_2396(), entry.comp_2397());
                }
                return builder.method_57486();
            });
            ActivatableItem.setActivated(stack, active);
        }
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(USED_COLOR);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addInkPoweredTooltip(List<class_2561> tooltip) {
        InkPowered.super.addInkPoweredTooltip(tooltip);
    }

    @Override
    public SplitDamageItem.DamageComposition getDamageComposition(class_1309 attacker, class_1309 target, class_1799 stack, float damage) {
        float newDamage = DreamflayerItem.getDamageAfterModifier(damage, attacker, target);
        SplitDamageItem.DamageComposition composition = new SplitDamageItem.DamageComposition();
        if (ActivatableItem.isActivated(stack)) {
            composition.addPlayerOrEntity(attacker, newDamage * 0.5f);
            composition.add(attacker.method_48923().method_48831(), newDamage * 0.25f);
            composition.add(SpectrumDamageTypes.setHealth(attacker.method_37908(), attacker), newDamage * 0.25f);
        } else {
            composition.addPlayerOrEntity(attacker, newDamage * 0.75f);
            composition.add(attacker.method_48923().method_48831(), newDamage * 0.25f);
        }
        return composition;
    }

    @Override
    public SlotBackgroundEffectProvider.SlotEffect backgroundType(@Nullable class_1657 player, class_1799 stack) {
        if (ActivatableItem.isActivated(stack)) {
            return SlotBackgroundEffectProvider.SlotEffect.FULL_PACKAGE;
        }
        boolean usable = InkPowered.hasAvailableInk(player, new InkCost(InkColors.RED, 200L));
        return usable ? SlotBackgroundEffectProvider.SlotEffect.BORDER_FADE : SlotBackgroundEffectProvider.SlotEffect.NONE;
    }

    @Override
    public int getBackgroundColor(@Nullable class_1657 player, class_1799 stack, float tickDelta) {
        return -972236;
    }
}

