/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.render.SlotBackgroundEffectProvider;
import de.dafuqs.spectrum.components.WorkstaffComponent;
import de.dafuqs.spectrum.entity.entity.MiningProjectileEntity;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.items.tools.WorkstaffItem;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class GlassCrestWorkstaffItem
extends WorkstaffItem
implements SlotBackgroundEffectProvider {
    public static final int COOLDOWN_DURATION_TICKS = 10;
    public static final InkCost PROJECTILE_COST = new InkCost(InkColors.WHITE, 50L);

    public GlassCrestWorkstaffItem(class_1832 material, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(material, attackDamage, attackSpeed, settings);
    }

    public static boolean canShoot(class_1799 stack) {
        return ((WorkstaffComponent)stack.method_57825(SpectrumDataComponentTypes.WORKSTAFF, (Object)WorkstaffComponent.DEFAULT)).canShoot();
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1271<class_1799> result = super.method_7836(world, user, hand);
        if (!result.method_5467().method_23665()) {
            class_1799 stack = user.method_5998(hand);
            if (GlassCrestWorkstaffItem.canShoot(stack) && InkPowered.tryDrainEnergy(user, PROJECTILE_COST)) {
                user.method_7357().method_7906((class_1792)this, 10);
                if (!world.field_9236) {
                    user.method_17356(SpectrumSoundEvents.LIGHT_CRYSTAL_RING, class_3419.field_15248, 0.5f, 0.75f + user.method_59922().method_43057());
                    MiningProjectileEntity.shoot(world, (class_1309)user, user.method_5998(hand));
                }
                stack.method_7970(2, (class_1309)user, class_1304.field_6173);
                return class_1271.method_22428((Object)stack);
            }
            return class_1271.method_22431((Object)stack);
        }
        return result;
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        if (GlassCrestWorkstaffItem.canShoot(stack)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.workstaff.tooltip.projectile").method_27692(class_124.field_1080));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.workstaff.tooltip.projectiles_disabled").method_27692(class_124.field_1079));
        }
    }

    @Override
    public SlotBackgroundEffectProvider.SlotEffect backgroundType(@Nullable class_1657 player, class_1799 stack) {
        boolean usable = InkPowered.hasAvailableInk(player, PROJECTILE_COST);
        return usable ? SlotBackgroundEffectProvider.SlotEffect.BORDER_FADE : SlotBackgroundEffectProvider.SlotEffect.NONE;
    }

    @Override
    public int getBackgroundColor(@Nullable class_1657 player, class_1799 stack, float tickDelta) {
        if (player != null) {
            class_5455 lookup = player.method_37908().method_30349();
            boolean resonance = SpectrumEnchantmentHelper.hasEnchantment((class_7225.class_7874)lookup, SpectrumEnchantments.RESONANCE, stack);
            boolean silkTouch = SpectrumEnchantmentHelper.hasEnchantment((class_7225.class_7874)lookup, (class_5321<class_1887>)class_1893.field_9099, stack);
            boolean fortune = SpectrumEnchantmentHelper.hasEnchantment((class_7225.class_7874)lookup, (class_5321<class_1887>)class_1893.field_9130, stack);
            if (resonance) {
                return -1;
            }
            if (silkTouch) {
                return -10747923;
            }
            if (fortune) {
                return -8741121;
            }
        }
        return -5395027;
    }
}

