/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.InkPoweredStatusEffectInstance;
import de.dafuqs.spectrum.api.item.InkPoweredPotionFillable;
import de.dafuqs.spectrum.api.render.SlotBackgroundEffectProvider;
import de.dafuqs.spectrum.helpers.SpectrumColorHelper;
import de.dafuqs.spectrum.particle.effect.DynamicParticleEffect;
import de.dafuqs.spectrum.registries.SpectrumEntityAttributes;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NightfallsBladeItem
extends class_1831
implements InkPoweredPotionFillable,
SlotBackgroundEffectProvider {
    private static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("unlocks/equipment/nightfalls_blade");

    public NightfallsBladeItem(class_1832 material, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(material, settings.method_57348(class_9285.method_57480().method_57487(class_5134.field_23721, new class_1322(field_8006, (double)((float)attackDamage + material.method_8028()), class_1322.class_1323.field_6328), class_9274.field_49217).method_57487(class_5134.field_23723, new class_1322(field_8001, (double)attackSpeed, class_1322.class_1323.field_6328), class_9274.field_49217).method_57487(class_5134.field_47759, new class_1322(SpectrumEntityAttributes.REACH_MODIFIER_ID, -1.5, class_1322.class_1323.field_6328), class_9274.field_49217).method_57486()));
    }

    @Override
    public int maxEffectCount() {
        return 1;
    }

    @Override
    public int maxEffectAmplifier() {
        return 2;
    }

    @Override
    public boolean isWeapon() {
        return true;
    }

    @Override
    public long adjustFinalCostFor(@NotNull InkPoweredStatusEffectInstance instance) {
        boolean mod = SpectrumStatusEffects.isStrongSleepEffect(instance);
        return Math.round(Math.pow(instance.getInkCost().cost(), 1.75 + (double)instance.getStatusEffectInstance().method_5578() + (double)mod));
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        class_1657 player;
        if (target.method_5805() && attacker instanceof class_1657 && AdvancementHelper.hasAdvancement((class_1657)(player = (class_1657)attacker), (class_2960)UNLOCK_IDENTIFIER)) {
            List<InkPoweredStatusEffectInstance> effects = InkPoweredPotionFillable.getEffects(stack);
            for (InkPoweredStatusEffectInstance instance : effects) {
                if (!InkPowered.tryDrainEnergy(player, instance.getInkCost().color(), instance.getInkCost().cost())) continue;
                class_1937 world = attacker.method_37908();
                if (world.field_9236) {
                    world.method_8406((class_2394)new DynamicParticleEffect((class_2396<?>)class_2398.field_11245, 0.1f, SpectrumColorHelper.colorIntToVec(((class_1291)instance.getStatusEffectInstance().method_5579().comp_349()).method_5556()), 0.5f, 120, true, true), target.method_23322(0.5), target.method_23323(0.5), target.method_23325(0.5), (double)world.field_9229.method_43057() - 0.5, (double)world.field_9229.method_43057() - 0.5, (double)world.field_9229.method_43057() - 0.5);
                    continue;
                }
                target.method_37222(instance.getStatusEffectInstance(), (class_1297)attacker);
            }
        }
        return super.method_7873(stack, target, attacker);
    }

    public boolean method_7886(class_1799 stack) {
        return super.method_7886(stack) || !((class_1844)stack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274)).method_57405();
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        this.appendPotionFillableTooltip(stack, tooltip, class_2561.method_43471((String)"item.spectrum.nightfalls_blade.when_struck"), true, context.method_59531());
    }

    @Override
    public SlotBackgroundEffectProvider.SlotEffect backgroundType(@Nullable class_1657 player, class_1799 stack) {
        List<InkPoweredStatusEffectInstance> effects = InkPoweredPotionFillable.getEffects(stack);
        if (effects.isEmpty()) {
            return SlotBackgroundEffectProvider.SlotEffect.NONE;
        }
        InkPoweredStatusEffectInstance effect = effects.getFirst();
        boolean usable = InkPowered.hasAvailableInk(player, new InkCost(effect.getInkCost().color(), this.adjustFinalCostFor(effect)));
        return usable ? SlotBackgroundEffectProvider.SlotEffect.BORDER_FADE : SlotBackgroundEffectProvider.SlotEffect.BORDER;
    }

    @Override
    public int getBackgroundColor(@Nullable class_1657 player, class_1799 stack, float tickDelta) {
        List<InkPoweredStatusEffectInstance> effects = InkPoweredPotionFillable.getEffects(stack);
        if (effects.isEmpty()) {
            return 0;
        }
        return effects.getFirst().getColor();
    }

    @Override
    public float getEffectOpacity(@Nullable class_1657 player, class_1799 stack, float tickDelta) {
        List<InkPoweredStatusEffectInstance> effects = InkPoweredPotionFillable.getEffects(stack);
        if (effects.isEmpty()) {
            return 0.0f;
        }
        InkPoweredStatusEffectInstance effect = effects.getFirst();
        if (InkPowered.hasAvailableInk(player, new InkCost(effect.getInkCost().color(), this.adjustFinalCostFor(effect)))) {
            return 1.0f;
        }
        if (player == null) {
            return 0.0f;
        }
        long time = player.method_37908().method_8510();
        return (float)(Math.sin(((float)time + tickDelta) / 30.0f) * (double)0.3f + 0.3);
    }
}

