/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import com.google.common.collect.Multimap;
import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.cca.OnPrimordialFireComponent;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import dev.emi.trinkets.api.SlotReference;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class AshenCircletItem
extends SpectrumTrinketItem {
    public static final int FIRE_RESISTANCE_EFFECT_DURATION = 600;
    public static final long COOLDOWN_TICKS = 3000L;
    public static final double LAVA_MOVEMENT_SPEED_MOD = 0.4;
    public static final double LAVA_VIEW_DISTANCE_MOD = 24.0;
    public static class_2960 LAVA_SPEED_ATTRIBUTE_ID = SpectrumCommon.locate("ashen_circlet_lava_speed");
    public static class_2960 LAVA_VISIBILITY_ATTRIBUTE_ID = SpectrumCommon.locate("ashen_circlet_lava_visibility");

    public AshenCircletItem(class_1792.class_1793 settings) {
        super(settings, SpectrumCommon.locate("unlocks/trinkets/ashen_circlet"));
    }

    public static long getCooldownTicks(@NotNull class_1799 ashenCircletStack, @NotNull class_1937 world) {
        Long last = (Long)ashenCircletStack.method_57825(SpectrumDataComponentTypes.LAST_COOLDOWN_START, (Object)0L);
        return Math.max(0L, last + 3000L - world.method_8510());
    }

    private static void setCooldown(@NotNull class_1799 ashenCircletStack, @NotNull class_1937 world) {
        ashenCircletStack.method_57379(SpectrumDataComponentTypes.LAST_COOLDOWN_START, (Object)world.method_8510());
    }

    public static void grantFireResistance(@NotNull class_1799 ashenCircletStack, @NotNull class_1309 livingEntity) {
        if (!livingEntity.method_6059(class_1294.field_5918)) {
            livingEntity.method_6092(new class_1293(class_1294.field_5918, 600, 0, true, true));
            livingEntity.method_37908().method_8396(null, livingEntity.method_24515(), class_3417.field_14839, class_3419.field_15248, 1.0f, 1.0f);
            AshenCircletItem.setCooldown(ashenCircletStack, livingEntity.method_37908());
        }
    }

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.tick(stack, slot, entity);
        if (entity.method_5809()) {
            entity.method_20803(0);
        }
        if (AshenCircletItem.getCooldownTicks(stack, entity.method_37908()) == 0L && OnPrimordialFireComponent.putOut(entity)) {
            entity.method_37908().method_8396(null, entity.method_24515(), class_3417.field_14839, class_3419.field_15248, 1.0f, 1.0f);
            AshenCircletItem.setCooldown(stack, entity.method_37908());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.ashen_circlet.tooltip").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.ashen_circlet.tooltip2").method_27692(class_124.field_1080));
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            long cooldownTicks = AshenCircletItem.getCooldownTicks(stack, (class_1937)world);
            if (cooldownTicks == 0L) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.ashen_circlet.tooltip.cooldown_full"));
            } else {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.ashen_circlet.tooltip.cooldown_seconds", (Object[])new Object[]{cooldownTicks / 20L}));
            }
        }
    }

    public Multimap<class_6880<class_1320>, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, class_2960 slotIdentifier) {
        Multimap modifiers = super.getModifiers(stack, slot, entity, slotIdentifier);
        modifiers.put((Object)AdditionalEntityAttributes.LAVA_SPEED, (Object)new class_1322(LAVA_SPEED_ATTRIBUTE_ID, 0.4, class_1322.class_1323.field_6328));
        modifiers.put((Object)AdditionalEntityAttributes.LAVA_VISIBILITY, (Object)new class_1322(LAVA_VISIBILITY_ATTRIBUTE_ID, 24.0, class_1322.class_1323.field_6328));
        return modifiers;
    }
}

