/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import com.google.common.collect.Multimap;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.energy.storage.FixedSingleInkStorage;
import de.dafuqs.spectrum.items.trinkets.InkDrainTrinketItem;
import de.dafuqs.spectrum.items.trinkets.SingleSlotGlove;
import dev.emi.trinkets.api.SlotReference;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class ExtraReachGlovesItem
extends InkDrainTrinketItem
implements SingleSlotGlove {
    public static class_2960 BLOCK_INTERACTION_ATTRIBUTE_ID = SpectrumCommon.locate("gloves_of_dawns_grasp_block_interaction");
    public static class_2960 ENTITY_INTERACTION_ATTRIBUTE_ID = SpectrumCommon.locate("gloves_of_dawns_grasp_entity_interaction");

    public ExtraReachGlovesItem(class_1792.class_1793 settings) {
        super(settings, SpectrumCommon.locate("unlocks/trinkets/gloves_of_dawns_grasp"), InkColors.LIGHT_BLUE);
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.gloves_of_dawns_grasp.tooltip").method_27692(class_124.field_1080));
        super.method_7851(stack, context, tooltip, type);
    }

    public Multimap<class_6880<class_1320>, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, class_2960 slotIdentifier) {
        Multimap modifiers = super.getModifiers(stack, slot, entity, slotIdentifier);
        FixedSingleInkStorage inkStorage = this.getEnergyStorage(stack);
        long storedInk = inkStorage.getEnergy(inkStorage.getStoredColor());
        double extraReach = this.getExtraReach(storedInk);
        if (extraReach != 0.0) {
            modifiers.put((Object)class_5134.field_47758, (Object)new class_1322(BLOCK_INTERACTION_ATTRIBUTE_ID, extraReach, class_1322.class_1323.field_6328));
            modifiers.put((Object)class_5134.field_47759, (Object)new class_1322(ENTITY_INTERACTION_ATTRIBUTE_ID, extraReach / 6.0, class_1322.class_1323.field_6328));
        }
        SingleSlotGlove.disableSecondGloveSlot((Multimap<class_6880<class_1320>, class_1322>)modifiers);
        return modifiers;
    }

    public double getExtraReach(long storedInk) {
        if (storedInk < 100L) {
            return 0.0;
        }
        return 0.5 + ExtraReachGlovesItem.roundHalf(Math.log((float)storedInk / 100.0f) / Math.log(64.0));
    }

    public static double roundHalf(double number) {
        return (double)((int)(number * 2.0)) / 2.0;
    }
}

