/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import de.dafuqs.spectrum.api.energy.InkStorage;
import de.dafuqs.spectrum.api.energy.InkStorageItem;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.storage.FixedSingleInkStorage;
import de.dafuqs.spectrum.api.render.ExtendedItemBarProvider;
import de.dafuqs.spectrum.api.render.SlotBackgroundEffectProvider;
import de.dafuqs.spectrum.components.InkStorageComponent;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InkDrainTrinketItem
extends SpectrumTrinketItem
implements InkStorageItem<FixedSingleInkStorage>,
ExtendedItemBarProvider,
SlotBackgroundEffectProvider {
    public static final int MAX_INK = 0x320000;
    public final InkColor inkColor;

    public InkDrainTrinketItem(class_1792.class_1793 settings, class_2960 unlockIdentifier, InkColor inkColor) {
        super(settings, unlockIdentifier);
        this.inkColor = inkColor;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        FixedSingleInkStorage inkStorage = this.getEnergyStorage(stack);
        long storedInk = inkStorage.getEnergy(inkStorage.getStoredColor());
        if (storedInk >= 0x320000L) {
            tooltip.add((class_2561)class_2561.method_43471((String)"spectrum.tooltip.ink_drain.tooltip.maxed_out").method_27692(class_124.field_1080));
        } else {
            long nextStepInk;
            int pow = 0;
            do {
                nextStepInk = (long)(100.0 * Math.pow(8.0, pow));
                ++pow;
            } while (storedInk >= nextStepInk);
            tooltip.add((class_2561)class_2561.method_43469((String)"spectrum.tooltip.ink_drain.tooltip.ink_for_next_step", (Object[])new Object[]{storedInk, inkStorage.getStoredColor().getColoredInkName(), Support.getShortenedNumberString(nextStepInk - storedInk)}).method_27692(class_124.field_1080));
        }
    }

    public boolean method_7886(class_1799 stack) {
        return this.isMaxedOut(stack);
    }

    private boolean isMaxedOut(class_1799 stack) {
        return this.getEnergyStorage(stack).isFull();
    }

    @Override
    public class_1799 method_7854() {
        return super.method_7854();
    }

    @Override
    public InkStorageItem.Drainability getDrainability() {
        return InkStorageItem.Drainability.NEVER;
    }

    @Override
    public FixedSingleInkStorage getEnergyStorage(class_1799 itemStack) {
        Iterator<Map.Entry<InkColor, Long>> iterator;
        InkStorageComponent storage = (InkStorageComponent)itemStack.method_57824(SpectrumDataComponentTypes.INK_STORAGE);
        if (storage != null && (iterator = storage.storedEnergy().entrySet().iterator()).hasNext()) {
            Map.Entry<InkColor, Long> entry = iterator.next();
            return new FixedSingleInkStorage(storage.maxEnergyTotal(), entry.getKey(), entry.getValue());
        }
        return new FixedSingleInkStorage(0x320000L, this.inkColor);
    }

    @Override
    public void setEnergyStorage(class_1799 itemStack, InkStorage storage) {
        itemStack.method_57379(SpectrumDataComponentTypes.INK_STORAGE, (Object)new InkStorageComponent(storage));
        itemStack.method_57379(class_9334.field_50073, (Object)(storage.isFull() ? class_1814.field_8904 : (class_1814)super.method_7854().method_57824(class_9334.field_50073)));
    }

    @Override
    public class_1799 getFullStack() {
        return InkStorageItem.super.getFullStack();
    }

    @Override
    public int barCount(class_1799 stack) {
        return 1;
    }

    @Override
    public boolean allowVanillaDurabilityBarRendering(@Nullable class_1657 player, class_1799 stack) {
        return false;
    }

    @Override
    public ExtendedItemBarProvider.BarSignature getSignature(@Nullable class_1657 player, @NotNull class_1799 stack, int index) {
        FixedSingleInkStorage inkTank = this.getEnergyStorage(stack);
        int progress = (int)Math.round(class_3532.method_15390((double)0.0, (double)14.0, (double)(Math.log((float)inkTank.getEnergy(this.inkColor) / 100.0f) / Math.log(8.0) / 5.0)));
        if (progress == 0 || progress == 14) {
            return PASS;
        }
        return new ExtendedItemBarProvider.BarSignature(1, 13, 14, progress, 1, this.inkColor.getTextColorInt(), 2, -16777216);
    }

    @Override
    public float getEffectOpacity(@Nullable class_1657 player, class_1799 stack, float tickDelta) {
        FixedSingleInkStorage inkTank = this.getEnergyStorage(stack);
        return (float)(Math.log((float)inkTank.getEnergy(this.inkColor) / 100.0f) / Math.log(8.0) / 5.0);
    }

    @Override
    public SlotBackgroundEffectProvider.SlotEffect backgroundType(@Nullable class_1657 player, class_1799 stack) {
        FixedSingleInkStorage inkTank = this.getEnergyStorage(stack);
        return inkTank.isFull() ? SlotBackgroundEffectProvider.SlotEffect.PULSE : SlotBackgroundEffectProvider.SlotEffect.NONE;
    }

    @Override
    public int getBackgroundColor(@Nullable class_1657 player, class_1799 stack, float tickDelta) {
        return this.inkColor.getColorInt();
    }
}

