/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.networking.s2c_payloads;

import de.dafuqs.spectrum.api.item.ExperienceStorageItem;
import de.dafuqs.spectrum.blocks.chests.BlackHoleChestBlockEntity;
import de.dafuqs.spectrum.networking.SpectrumC2SPackets;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record BlackHoleChestStatusUpdatePayload(class_2338 pos, boolean isFull, boolean canStoreExperience, long storedExperience, long maxStoredExperience) implements class_8710
{
    public static final class_8710.class_9154<BlackHoleChestStatusUpdatePayload> ID = SpectrumC2SPackets.makeId("black_hole_chest_status_update");
    public static final class_9139<class_2540, BlackHoleChestStatusUpdatePayload> CODEC = class_9139.method_56906((class_9139)class_2338.field_48404, BlackHoleChestStatusUpdatePayload::pos, (class_9139)class_9135.field_48547, BlackHoleChestStatusUpdatePayload::isFull, (class_9139)class_9135.field_48547, BlackHoleChestStatusUpdatePayload::canStoreExperience, (class_9139)class_9135.field_48551, BlackHoleChestStatusUpdatePayload::storedExperience, (class_9139)class_9135.field_48551, BlackHoleChestStatusUpdatePayload::maxStoredExperience, BlackHoleChestStatusUpdatePayload::new);

    public static void sendBlackHoleChestUpdate(BlackHoleChestBlockEntity chest) {
        class_1799 xpStack = chest.method_5438(27);
        long storedXP = 0L;
        long maxStoredXP = 0L;
        class_1792 class_17922 = xpStack.method_7909();
        if (class_17922 instanceof ExperienceStorageItem) {
            ExperienceStorageItem experienceStorageItem = (ExperienceStorageItem)class_17922;
            if (chest.method_10997() != null) {
                storedXP = ExperienceStorageItem.getStoredExperience(xpStack);
                maxStoredXP = experienceStorageItem.getMaxStoredExperience((class_7225.class_7874)chest.method_10997().method_30349(), xpStack);
            }
        }
        for (class_3222 player : PlayerLookup.tracking((class_2586)chest)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new BlackHoleChestStatusUpdatePayload(chest.method_11016(), chest.isFullServer(), chest.canStoreExperience(), storedXP, maxStoredXP));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void execute(BlackHoleChestStatusUpdatePayload payload, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        if (client.field_1687 != null) {
            Optional entity = client.field_1687.method_35230(payload.pos, SpectrumBlockEntities.BLACK_HOLE_CHEST);
            entity.ifPresent(chest -> {
                chest.setFull(payload.isFull);
                chest.setHasXPStorage(payload.canStoreExperience);
                chest.setXPData(payload.storedExperience, payload.maxStoredExperience);
            });
        }
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }
}

