/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.networking.s2c_payloads;

import de.dafuqs.spectrum.blocks.chests.FabricationChestBlockEntity;
import de.dafuqs.spectrum.networking.SpectrumC2SPackets;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record FabricationChestStatusUpdatePayload(class_2338 pos, boolean isFull, boolean hasValidRecipes, List<class_1799> stacks) implements class_8710
{
    public static final class_8710.class_9154<FabricationChestStatusUpdatePayload> ID = SpectrumC2SPackets.makeId("fabrication_chest_status_update");
    public static final class_9139<class_9129, FabricationChestStatusUpdatePayload> CODEC = class_9139.method_56905((class_9139)class_2338.field_48404, FabricationChestStatusUpdatePayload::pos, (class_9139)class_9135.field_48547, FabricationChestStatusUpdatePayload::isFull, (class_9139)class_9135.field_48547, FabricationChestStatusUpdatePayload::hasValidRecipes, (class_9139)class_1799.field_48350, FabricationChestStatusUpdatePayload::stacks, FabricationChestStatusUpdatePayload::new);

    public static void sendFabricationChestStatusUpdate(FabricationChestBlockEntity chest) {
        class_2338 pos = chest.method_11016();
        boolean isFull = chest.isFullServer();
        boolean hasValidRecipes = chest.hasValidRecipes();
        ArrayList<class_1799> stacks = new ArrayList<class_1799>(chest.getRecipeOutputs());
        for (class_3222 player : PlayerLookup.tracking((class_2586)chest)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new FabricationChestStatusUpdatePayload(pos, isFull, hasValidRecipes, stacks));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void execute(FabricationChestStatusUpdatePayload payload, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        class_2338 pos = payload.pos;
        boolean isFull = payload.isFull;
        boolean hasValidRecipes = payload.hasValidRecipes;
        List<class_1799> outputs = payload.stacks;
        Optional entity = client.field_1687.method_35230(pos, SpectrumBlockEntities.FABRICATION_CHEST);
        if (entity.isPresent()) {
            ((FabricationChestBlockEntity)((Object)entity.get())).updateState(isFull, hasValidRecipes, outputs);
        }
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }
}

