/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.networking.s2c_payloads;

import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import de.dafuqs.spectrum.networking.SpectrumC2SPackets;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record PastelNodeStatusUpdatePayload(boolean longSpin, Map<class_2338, Integer> spinTimes) implements class_8710
{
    public static final class_8710.class_9154<PastelNodeStatusUpdatePayload> ID = SpectrumC2SPackets.makeId("pastel_node_status_update");
    public static final class_9139<class_2540, PastelNodeStatusUpdatePayload> CODEC = class_9139.method_56435((class_9139)class_9135.field_48547, PastelNodeStatusUpdatePayload::longSpin, (class_9139)class_9135.method_56377(Object2IntArrayMap::new, (class_9139)class_2338.field_48404, (class_9139)class_9135.field_49675), PastelNodeStatusUpdatePayload::spinTimes, PastelNodeStatusUpdatePayload::new);

    public static void sendPastelNodeStatusUpdate(List<PastelNodeBlockEntity> nodes, boolean longSpin) {
        Object2IntArrayMap spinTimes = new Object2IntArrayMap();
        for (PastelNodeBlockEntity node : nodes) {
            class_1937 world = node.method_10997();
            if (world == null) continue;
            int time = longSpin ? 24 + world.method_8409().method_43048(11) : 10 + world.method_8409().method_43048(11);
            spinTimes.put(node.method_11016(), time);
        }
        for (class_3222 player : PlayerLookup.tracking((class_2586)nodes.getFirst())) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new PastelNodeStatusUpdatePayload(longSpin, (Map<class_2338, Integer>)spinTimes));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void execute(PastelNodeStatusUpdatePayload payload, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        for (Map.Entry<class_2338, Integer> e : payload.spinTimes.entrySet()) {
            class_2586 entity = client.field_1687.method_8321(e.getKey());
            if (!(entity instanceof PastelNodeBlockEntity)) continue;
            PastelNodeBlockEntity node = (PastelNodeBlockEntity)entity;
            node.setSpinTicks(e.getValue().intValue());
            if (!payload.longSpin || !node.isTriggerTransfer()) continue;
            node.markTriggered();
        }
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }
}

