/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.networking.s2c_payloads;

import de.dafuqs.spectrum.blocks.memory.MemoryBlockEntity;
import de.dafuqs.spectrum.helpers.SpectrumColorHelper;
import de.dafuqs.spectrum.networking.SpectrumC2SPackets;
import de.dafuqs.spectrum.particle.effect.ColoredCraftingParticleEffect;
import de.dafuqs.spectrum.particle.effect.DynamicParticleEffect;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5819;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public record PlayMemoryManifestingParticlesPayload(class_2338 pos, int eggColor1, int eggColor2, int amount) implements class_8710
{
    public static final class_8710.class_9154<PlayMemoryManifestingParticlesPayload> ID = SpectrumC2SPackets.makeId("play_memory_manifesting_particles");
    public static final class_9139<class_2540, PlayMemoryManifestingParticlesPayload> CODEC = class_9139.method_56905((class_9139)class_2338.field_48404, PlayMemoryManifestingParticlesPayload::pos, (class_9139)class_9135.field_49675, PlayMemoryManifestingParticlesPayload::eggColor1, (class_9139)class_9135.field_49675, PlayMemoryManifestingParticlesPayload::eggColor2, (class_9139)class_9135.field_49675, PlayMemoryManifestingParticlesPayload::amount, PlayMemoryManifestingParticlesPayload::new);

    public static void playMemoryManifestingParticles(class_3218 serverWorld, @NotNull class_2338 pos, class_1299<?> entityType, int amount) {
        class_3545<Integer, Integer> eggColors = MemoryBlockEntity.getEggColorsForEntity(entityType);
        for (class_3222 player : PlayerLookup.tracking((class_3218)serverWorld, (class_2338)pos)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new PlayMemoryManifestingParticlesPayload(pos, (Integer)eggColors.method_15442(), (Integer)eggColors.method_15441(), amount));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void execute(PlayMemoryManifestingParticlesPayload payload, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        class_5819 random = client.field_1687.field_9229;
        Vector3f colorVec1 = SpectrumColorHelper.colorIntToVec(payload.eggColor1);
        Vector3f colorVec2 = SpectrumColorHelper.colorIntToVec(payload.eggColor1);
        class_2338 pos = payload.pos;
        for (int i = 0; i < payload.amount; ++i) {
            int randomLifetime = 30 + random.method_43048(20);
            client.field_1687.method_8406((class_2394)new DynamicParticleEffect(ColoredCraftingParticleEffect.WHITE.method_10295(), 0.5f, colorVec1, 1.0f, randomLifetime, false, true), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260(), 0.15 - (double)random.method_43057() * 0.3, (double)random.method_43057() * 0.15 + 0.1, 0.15 - (double)random.method_43057() * 0.3);
            client.field_1687.method_8406((class_2394)new DynamicParticleEffect(ColoredCraftingParticleEffect.WHITE.method_10295(), 0.5f, colorVec2, 1.0f, randomLifetime, false, true), (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, 0.15 - (double)random.method_43057() * 0.3, (double)random.method_43057() * 0.15 + 0.1, 0.15 - (double)random.method_43057() * 0.3);
        }
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }
}

