/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_8944;

public class PedestalCraftingCriterion
extends class_4558<Conditions> {
    public static final class_2960 ID = SpectrumCommon.locate("crafted_with_pedestal");

    public void trigger(class_3222 player, class_1799 craftedStack, int experience, int durationTicks) {
        this.method_22510(player, conditions -> conditions.matches(craftedStack, experience, durationTicks));
    }

    public Codec<Conditions> method_54937() {
        return Conditions.CODEC;
    }

    public static final class Conditions
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_5258> location;
        private final Optional<class_2073> craftedItemPredicate;
        private final class_2096.class_2100 experienceRange;
        private final class_2096.class_2100 craftingDurationTicksRange;
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(Conditions::comp_2029), (App)class_5258.field_47234.optionalFieldOf("location").forGetter(Conditions::location), (App)class_2073.field_45754.optionalFieldOf("item").forGetter(Conditions::craftedItemPredicate), (App)class_2096.class_2100.field_45763.optionalFieldOf("gained_experience", (Object)class_2096.class_2100.field_9708).forGetter(Conditions::experienceRange), (App)class_2096.class_2100.field_45763.optionalFieldOf("crafting_duration_ticks", (Object)class_2096.class_2100.field_9708).forGetter(Conditions::craftingDurationTicksRange)).apply((Applicative)instance, Conditions::new));

        public Conditions(Optional<class_5258> player, Optional<class_5258> location, Optional<class_2073> craftedItemPredicate, class_2096.class_2100 experienceRange, class_2096.class_2100 craftingDurationTicksRange) {
            this.player = player;
            this.location = location;
            this.craftedItemPredicate = craftedItemPredicate;
            this.experienceRange = experienceRange;
            this.craftingDurationTicksRange = craftingDurationTicksRange;
        }

        public void method_54938(class_8944 validator) {
            super.method_54938(validator);
        }

        public boolean matches(class_1799 craftedStack, int experience, int durationTicks) {
            if (this.craftedItemPredicate.isPresent() && !this.craftedItemPredicate.get().method_8970(craftedStack)) {
                return false;
            }
            if (!this.experienceRange.method_9054(experience)) {
                return false;
            }
            return this.craftingDurationTicksRange.method_9054(durationTicks);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Conditions.class, "player;location;craftedItemPredicate;experienceRange;craftingDurationTicksRange", "player", "location", "craftedItemPredicate", "experienceRange", "craftingDurationTicksRange"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Conditions.class, "player;location;craftedItemPredicate;experienceRange;craftingDurationTicksRange", "player", "location", "craftedItemPredicate", "experienceRange", "craftingDurationTicksRange"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Conditions.class, "player;location;craftedItemPredicate;experienceRange;craftingDurationTicksRange", "player", "location", "craftedItemPredicate", "experienceRange", "craftingDurationTicksRange"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_5258> location() {
            return this.location;
        }

        public Optional<class_2073> craftedItemPredicate() {
            return this.craftedItemPredicate;
        }

        public class_2096.class_2100 experienceRange() {
            return this.experienceRange;
        }

        public class_2096.class_2100 craftingDurationTicksRange() {
            return this.craftingDurationTicksRange;
        }
    }
}

