/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_4558;
import net.minecraft.class_5258;

public class TrinketChangeCriterion
extends class_4558<Conditions> {
    public static final class_2960 ID = SpectrumCommon.locate("trinket_change");

    public void trigger(class_3222 player) {
        this.method_22510(player, conditions -> {
            Optional trinketComponent = TrinketsApi.getTrinketComponent((class_1309)player);
            if (trinketComponent.isPresent()) {
                ArrayList<class_1799> equippedStacks = new ArrayList<class_1799>();
                int spectrumStacks = 0;
                for (class_3545 t : ((TrinketComponent)trinketComponent.get()).getAllEquipped()) {
                    equippedStacks.add((class_1799)t.method_15441());
                    if (!(((class_1799)t.method_15441()).method_7909() instanceof SpectrumTrinketItem)) continue;
                    ++spectrumStacks;
                }
                return conditions.matches(equippedStacks, equippedStacks.size(), spectrumStacks);
            }
            return false;
        });
    }

    public Codec<Conditions> method_54937() {
        return Conditions.CODEC;
    }

    public static final class Conditions
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<List<class_2073>> itemPredicates;
        private final Optional<class_2096.class_2100> totalCountRange;
        private final Optional<class_2096.class_2100> spectrumCountRange;
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5258.field_47234.optionalFieldOf("player").forGetter(Conditions::comp_2029), (App)class_2073.field_45754.listOf().optionalFieldOf("items").forGetter(Conditions::itemPredicates), (App)class_2096.class_2100.field_45763.optionalFieldOf("total_count").forGetter(Conditions::totalCountRange), (App)class_2096.class_2100.field_45763.optionalFieldOf("spectrum_count").forGetter(Conditions::spectrumCountRange)).apply((Applicative)instance, Conditions::new));

        public Conditions(Optional<class_5258> player, Optional<List<class_2073>> itemPredicates, Optional<class_2096.class_2100> totalCountRange, Optional<class_2096.class_2100> spectrumCountRange) {
            this.player = player;
            this.itemPredicates = itemPredicates;
            this.totalCountRange = totalCountRange;
            this.spectrumCountRange = spectrumCountRange;
        }

        public boolean matches(List<class_1799> trinketStacks, int totalCount, int spectrumCount) {
            if (this.totalCountRange.isPresent() && this.totalCountRange.get().method_9054(totalCount) || this.spectrumCountRange.isPresent() && this.spectrumCountRange.get().method_9054(spectrumCount)) {
                int i = this.itemPredicates.orElse(List.of()).size();
                if (i == 0) {
                    return true;
                }
                ObjectArrayList requiredTrinkets = new ObjectArrayList((Collection)this.itemPredicates.get());
                for (class_1799 trinketStack : trinketStacks) {
                    if (requiredTrinkets.isEmpty()) {
                        return true;
                    }
                    if (trinketStack.method_7960()) continue;
                    requiredTrinkets.removeIf(item -> item.method_8970(trinketStack));
                }
                return requiredTrinkets.isEmpty();
            }
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Conditions.class, "player;itemPredicates;totalCountRange;spectrumCountRange", "player", "itemPredicates", "totalCountRange", "spectrumCountRange"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Conditions.class, "player;itemPredicates;totalCountRange;spectrumCountRange", "player", "itemPredicates", "totalCountRange", "spectrumCountRange"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Conditions.class, "player;itemPredicates;totalCountRange;spectrumCountRange", "player", "itemPredicates", "totalCountRange", "spectrumCountRange"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<List<class_2073>> itemPredicates() {
            return this.itemPredicates;
        }

        public Optional<class_2096.class_2100> totalCountRange() {
            return this.totalCountRange;
        }

        public Optional<class_2096.class_2100> spectrumCountRange() {
            return this.spectrumCountRange;
        }
    }
}

