/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe;

import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_9695;

public abstract class GatedStackSpectrumRecipe<C extends class_9695>
extends GatedSpectrumRecipe<C> {
    protected GatedStackSpectrumRecipe(String group, boolean secret, Optional<class_2960> requiredAdvancementIdentifier) {
        super(group, secret, requiredAdvancementIdentifier);
    }

    public abstract List<IngredientStack> getIngredientStacks();

    protected boolean matchIngredientStacksExclusively(class_9695 recipeInput, List<IngredientStack> ingredientStacks) {
        if (recipeInput.method_59983() < ingredientStacks.size()) {
            return false;
        }
        ArrayList<class_1799> nonEmptyStacks = new ArrayList<class_1799>();
        for (int i = 0; i < recipeInput.method_59983(); ++i) {
            class_1799 stack = recipeInput.method_59984(i);
            if (stack.method_7960()) continue;
            nonEmptyStacks.add(stack);
        }
        if (nonEmptyStacks.size() != ingredientStacks.size()) {
            return false;
        }
        ObjectArraySet ingredients = ObjectArraySet.of((Object[])ingredientStacks.toArray(new IngredientStack[0]));
        for (class_1799 stack : nonEmptyStacks) {
            IngredientStack foundStack = null;
            for (IngredientStack ingredientStack : ingredients) {
                if (!ingredientStack.test(stack)) continue;
                foundStack = ingredientStack;
                break;
            }
            if (foundStack == null) {
                return false;
            }
            ingredients.remove(foundStack);
            if (!ingredients.isEmpty()) continue;
            break;
        }
        return true;
    }

    protected boolean matchIngredientStacksExclusively(class_9695 recipeInput, List<IngredientStack> ingredients, int[] slots) {
        int inputStackCount = 0;
        for (int slot : slots) {
            if (recipeInput.method_59984(slot).method_7960()) continue;
            ++inputStackCount;
        }
        if (inputStackCount != ingredients.size()) {
            return false;
        }
        Object object = ingredients.iterator();
        while (object.hasNext()) {
            IngredientStack ingredient = (IngredientStack)object.next();
            boolean found = false;
            for (int slot : slots) {
                if (!ingredient.test(recipeInput.method_59984(slot))) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

