/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.enchanter;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.api.item.ExperienceStorageItem;
import de.dafuqs.spectrum.helpers.PacketCodecHelper;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.RecipeScaling;
import de.dafuqs.spectrum.recipe.enchanter.EnchanterRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9695;

public class EnchantmentUpgradeRecipe
extends GatedSpectrumRecipe<class_9695> {
    protected final Either<class_6880<class_1887>, class_5321<class_1887>> either;
    protected final int levelCap;
    protected final class_1856 bulkItem;
    protected final RecipeScaling.ScalingData itemScaling;
    protected final RecipeScaling.ScalingData XPScaling;
    protected final class_2371<class_1856> inputs;
    protected final class_1799 output;

    public EnchantmentUpgradeRecipe(String group, boolean secret, Optional<class_2960> requiredAdvancementIdentifier, Either<class_6880<class_1887>, class_5321<class_1887>> enchantmentEntry, int levelCap, class_1856 bulkItem, RecipeScaling.ScalingData XPScaling, RecipeScaling.ScalingData itemScaling) {
        super(group, secret, requiredAdvancementIdentifier);
        this.either = enchantmentEntry;
        this.levelCap = levelCap;
        this.bulkItem = bulkItem;
        this.itemScaling = itemScaling;
        this.XPScaling = XPScaling;
        class_2371 inputs = class_2371.method_10213((int)2, (Object)class_1856.field_9017);
        if (enchantmentEntry.left().isPresent()) {
            class_6880 enchantment = (class_6880)enchantmentEntry.left().get();
            int baseMax = ((class_1887)enchantment.comp_349()).method_8183();
            if (levelCap < baseMax) {
                throw new JsonParseException("Level Cap cannot be lower than the Enchantment's base level (levelCap " + levelCap + "< enchantment's" + baseMax + ")");
            }
            class_1799 ingredientStack = new class_1799((class_1935)class_1802.field_8598);
            ingredientStack.method_7978(enchantment, levelCap - 1);
            inputs.set(0, (Object)class_1856.method_8101((class_1799[])new class_1799[]{ingredientStack}));
            inputs.set(1, (Object)bulkItem);
            this.inputs = inputs;
            class_1799 outputStack = new class_1799((class_1935)class_1802.field_8598);
            outputStack.method_7978((class_6880)enchantmentEntry.left().get(), levelCap);
            this.output = outputStack;
        } else {
            this.inputs = class_2371.method_10211();
            this.output = class_1799.field_8037;
        }
    }

    public boolean method_8115(class_9695 inv, class_1937 world) {
        if (inv.method_59983() > 9) {
            int requiredXp;
            class_1799 centerStack = inv.method_59984(0);
            if (this.either.left().isEmpty()) {
                throw new UnsupportedOperationException("Attempted to match a datagen enchantment upgrade");
            }
            class_6880 enchantment = (class_6880)this.either.left().get();
            if (!((class_1856)this.inputs.getFirst()).method_8093(centerStack)) {
                return false;
            }
            class_9304 enchantments = (class_9304)centerStack.method_57824(class_9334.field_49643);
            if (enchantments == null) {
                return false;
            }
            int bookLevel = enchantments.method_57536(enchantment);
            if (!enchantments.method_57534().contains(enchantment) || bookLevel >= this.levelCap) {
                return false;
            }
            int availableXp = ExperienceStorageItem.getStoredExperience(inv.method_59984(1));
            if (availableXp < (requiredXp = this.XPScaling.apply(bookLevel))) {
                return false;
            }
            int bulkInput = 0;
            for (int i = 1; i < 9; ++i) {
                class_1799 currentStack = inv.method_59984(i + 1);
                if (currentStack.method_7960()) continue;
                class_1799 slotStack = inv.method_59984(i + 1);
                if (this.bulkItem.method_8093(slotStack)) {
                    bulkInput += slotStack.method_7947();
                    continue;
                }
                return false;
            }
            return bulkInput >= this.itemScaling.apply(bookLevel);
        }
        return false;
    }

    public class_1799 method_8116(class_9695 inv, class_7225.class_7874 drm) {
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_7225.class_7874 registryManager) {
        return this.output;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)SpectrumBlocks.ENCHANTER);
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.ENCHANTMENT_UPGRADE_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.ENCHANTMENT_UPGRADE;
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return EnchanterRecipe.UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "enchantment_upgrade";
    }

    public class_2371<class_1856> method_8117() {
        return this.inputs;
    }

    public class_1792 getBulkItem() {
        class_1799[] match = this.bulkItem.method_8105();
        if (match != null && match.length > 0) {
            return this.bulkItem.method_8105()[0].method_7909();
        }
        return class_1802.field_8162;
    }

    public int getBaseXPCost() {
        return this.XPScaling.apply(1.0);
    }

    public int getBaseItemCost() {
        return this.itemScaling.apply(1.0);
    }

    public RecipeScaling.ScalingData getXPScaling() {
        return this.XPScaling;
    }

    public RecipeScaling.ScalingData getItemScaling() {
        return this.itemScaling;
    }

    public class_6880<class_1887> getEnchantment() {
        if (this.either.left().isEmpty()) {
            throw new UnsupportedOperationException("Attempted to match a datagen enchantment upgrade");
        }
        return (class_6880)this.either.left().get();
    }

    public int getLevelCap() {
        return this.levelCap;
    }

    public boolean isInNormalRange(int level) {
        if (this.either.left().isEmpty()) {
            throw new UnsupportedOperationException("Attempted to match a datagen enchantment upgrade");
        }
        return level < ((class_1887)((class_6880)this.either.left().get()).comp_349()).method_8183();
    }

    public static class Serializer
    implements class_1865<EnchantmentUpgradeRecipe> {
        public static final MapCodec<EnchantmentUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)class_2960.field_25139.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)Codec.either((Codec)class_1887.field_51644, (Codec)class_5321.method_39154((class_5321)class_7924.field_41265)).fieldOf("enchantment").forGetter(c -> c.either), (App)Codec.INT.fieldOf("level_cap").forGetter(recipe -> recipe.levelCap), (App)class_1856.field_46096.fieldOf("bulk_item").forGetter(recipe -> recipe.bulkItem), (App)RecipeScaling.CODEC.fieldOf("xp_scaling").forGetter(recipe -> recipe.XPScaling), (App)RecipeScaling.CODEC.fieldOf("item_scaling").forGetter(recipe -> recipe.itemScaling)).apply((Applicative)i, EnchantmentUpgradeRecipe::new));
        public static final class_9139<class_9129, EnchantmentUpgradeRecipe> PACKET_CODEC = PacketCodecHelper.tuple(class_9135.field_48554, recipe -> recipe.group, class_9135.field_48547, recipe -> recipe.secret, class_9135.method_56382((class_9139)class_2960.field_48267), recipe -> recipe.requiredAdvancementIdentifier, class_9135.method_57995((class_9139)class_1887.field_51950, (class_9139)class_5321.method_56038((class_5321)class_7924.field_41265)), c -> c.either, class_9135.field_48550, recipe -> recipe.levelCap, class_1856.field_48355, recipe -> recipe.bulkItem, RecipeScaling.PACKET_CODEC, recipe -> recipe.XPScaling, RecipeScaling.PACKET_CODEC, recipe -> recipe.itemScaling, EnchantmentUpgradeRecipe::new);

        public MapCodec<EnchantmentUpgradeRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, EnchantmentUpgradeRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}

