/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.fusion_shrine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.block.MultiblockCrafter;
import de.dafuqs.spectrum.api.predicate.location.WorldConditionsPredicate;
import de.dafuqs.spectrum.api.recipe.FluidIngredient;
import de.dafuqs.spectrum.api.recipe.FusionShrineRecipeWorldEffect;
import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.blocks.fusion_shrine.FusionShrineBlockEntity;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.helpers.CodecHelper;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.helpers.PacketCodecHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.recipe.GatedStackSpectrumRecipe;
import de.dafuqs.spectrum.recipe.StorageRecipeInput;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9304;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionShrineRecipe
extends GatedStackSpectrumRecipe<StorageRecipeInput<SingleVariantStorage<FluidVariant>>> {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("build_fusion_shrine");
    protected final List<IngredientStack> craftingInputs;
    protected final FluidIngredient fluid;
    protected final class_1799 output;
    protected final float experience;
    protected final int craftingTime;
    protected final boolean noBenefitsFromYieldAndEfficiencyUpgrades;
    protected final boolean playCraftingFinishedEffects;
    protected final List<WorldConditionsPredicate> worldConditionsPredicates;
    @NotNull
    protected final FusionShrineRecipeWorldEffect startWorldEffect;
    @NotNull
    protected final List<FusionShrineRecipeWorldEffect> duringWorldEffects;
    @NotNull
    protected final FusionShrineRecipeWorldEffect finishWorldEffect;
    @Nullable
    protected final class_2561 description;
    protected final boolean copyComponents;

    public FusionShrineRecipe(String group, boolean secret, Optional<class_2960> requiredAdvancementIdentifier, List<IngredientStack> craftingInputs, FluidIngredient fluid, class_1799 output, float experience, int craftingTime, boolean noBenefitsFromYieldAndEfficiencyUpgrades, boolean playCraftingFinishedEffects, boolean copyComponents, List<WorldConditionsPredicate> worldConditionsPredicates, @NotNull FusionShrineRecipeWorldEffect startWorldEffect, @NotNull List<FusionShrineRecipeWorldEffect> duringWorldEffects, @NotNull FusionShrineRecipeWorldEffect finishWorldEffect, @Nullable class_2561 description) {
        super(group, secret, requiredAdvancementIdentifier);
        this.craftingInputs = craftingInputs;
        this.fluid = fluid;
        this.output = output;
        this.experience = experience;
        this.craftingTime = craftingTime;
        this.noBenefitsFromYieldAndEfficiencyUpgrades = noBenefitsFromYieldAndEfficiencyUpgrades;
        this.playCraftingFinishedEffects = playCraftingFinishedEffects;
        this.worldConditionsPredicates = worldConditionsPredicates;
        this.startWorldEffect = startWorldEffect;
        this.duringWorldEffects = duringWorldEffects;
        this.finishWorldEffect = finishWorldEffect;
        this.description = description;
        this.copyComponents = copyComponents;
        this.registerInToastManager(this.method_17716(), this);
    }

    public boolean matches(StorageRecipeInput<SingleVariantStorage<FluidVariant>> recipeInput, class_1937 world) {
        SingleVariantStorage<FluidVariant> fluidStorage = recipeInput.getFluidStorage();
        if (!this.fluid.test((FluidVariant)fluidStorage.variant)) {
            return false;
        }
        if (this.fluid != FluidIngredient.EMPTY && fluidStorage.getAmount() != fluidStorage.getCapacity()) {
            return false;
        }
        return this.matchIngredientStacksExclusively(recipeInput, this.getIngredientStacks());
    }

    public class_1799 assemble(StorageRecipeInput<SingleVariantStorage<FluidVariant>> inv, class_7225.class_7874 drm) {
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return this.craftingInputs.size() <= width * height;
    }

    public class_1799 method_8110(class_7225.class_7874 registryManager) {
        return this.output;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)SpectrumBlocks.FUSION_SHRINE_BASALT);
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.FUSION_SHRINE_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.FUSION_SHRINE;
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        return this.craftingInputs;
    }

    public float getExperience() {
        return this.experience;
    }

    public boolean areConditionMetCurrently(class_3218 world, class_2338 pos) {
        if (this.worldConditionsPredicates.isEmpty()) {
            return true;
        }
        return this.worldConditionsPredicates.stream().anyMatch(p -> p.test(world, pos));
    }

    public FluidIngredient getFluid() {
        return this.fluid;
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public boolean areYieldAndEfficiencyUpgradesDisabled() {
        return this.copyComponents || this.noBenefitsFromYieldAndEfficiencyUpgrades;
    }

    public FusionShrineRecipeWorldEffect getWorldEffectForTick(int tick, int totalTicks) {
        if (tick == 1) {
            return this.startWorldEffect;
        }
        if (tick == totalTicks) {
            return this.finishWorldEffect;
        }
        if (this.duringWorldEffects.isEmpty()) {
            return null;
        }
        if (this.duringWorldEffects.size() == 1) {
            return this.duringWorldEffects.getFirst();
        }
        float parts = (float)totalTicks / (float)this.duringWorldEffects.size();
        int index = (int)((float)tick / parts);
        FusionShrineRecipeWorldEffect effect = this.duringWorldEffects.get(index);
        if (effect.isOneTimeEffect() && index != (int)parts) {
            return null;
        }
        return effect;
    }

    public Optional<class_2561> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return Optional.of(this.description);
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "fusion_shrine";
    }

    public void craft(class_1937 world, FusionShrineBlockEntity fusionShrineBlockEntity) {
        class_1799 firstStack = class_1799.field_8037;
        class_1799 memory = class_1799.field_8037;
        int maxAmount = 1;
        class_1799 output = this.assemble(new StorageRecipeInput<SingleVariantStorage<FluidVariant>>((List<class_1799>)fusionShrineBlockEntity.getItems(), fusionShrineBlockEntity.fluidStorage), (class_7225.class_7874)world.method_30349());
        if (!output.method_7960()) {
            maxAmount = output.method_7914();
            block0: for (IngredientStack ingredientStack : this.getIngredientStacks()) {
                for (int i = 0; i < fusionShrineBlockEntity.method_5439(); ++i) {
                    class_1799 currentStack = fusionShrineBlockEntity.method_5438(i);
                    if (!ingredientStack.test(currentStack)) continue;
                    if (firstStack.method_7960()) {
                        firstStack = currentStack;
                    }
                    int ingredientStackAmount = ingredientStack.getCount();
                    maxAmount = Math.min(maxAmount, currentStack.method_7947() / ingredientStackAmount);
                    continue block0;
                }
            }
            memory = firstStack.method_7972();
            if (maxAmount > 0) {
                double efficiencyModifier = this.areYieldAndEfficiencyUpgradesDisabled() ? 1.0 : (double)fusionShrineBlockEntity.getUpgradeHolder().getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY);
                this.decrementIngredients(world, fusionShrineBlockEntity, maxAmount, efficiencyModifier);
            }
        } else {
            block2: for (IngredientStack ingredientStack : this.getIngredientStacks()) {
                double efficiencyModifier = fusionShrineBlockEntity.getUpgradeHolder().getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY);
                for (int i = 0; i < fusionShrineBlockEntity.method_5439(); ++i) {
                    class_1799 currentStack = fusionShrineBlockEntity.method_5438(i);
                    if (!ingredientStack.test(currentStack)) continue;
                    int reducedAmountAfterMod = currentStack == firstStack && this.copyComponents ? ingredientStack.getCount() : Support.getIntFromDecimalWithChance((double)ingredientStack.getCount() / efficiencyModifier, world.field_9229);
                    currentStack.method_7934(reducedAmountAfterMod);
                    continue block2;
                }
            }
        }
        if (this.copyComponents) {
            class_9304 originalEnchantments = output.method_58657();
            output = memory.method_56701((class_1935)output.method_7909(), output.method_7947());
            for (class_6880 enchantment : originalEnchantments.method_57534()) {
                output.method_7978(enchantment, originalEnchantments.method_57536(enchantment));
            }
        }
        this.spawnCraftingResultAndXP(world, fusionShrineBlockEntity, output, maxAmount);
    }

    private void decrementIngredients(class_1937 world, FusionShrineBlockEntity fusionShrineBlockEntity, int recipesCrafted, double efficiencyModifier) {
        block0: for (IngredientStack ingredientStack : this.getIngredientStacks()) {
            for (int i = 0; i < fusionShrineBlockEntity.method_5439(); ++i) {
                class_1799 currentStack = fusionShrineBlockEntity.method_5438(i);
                if (!ingredientStack.test(currentStack)) continue;
                int reducedAmount = recipesCrafted * ingredientStack.getCount();
                int reducedAmountAfterMod = efficiencyModifier == 1.0 ? reducedAmount : Support.getIntFromDecimalWithChance((double)reducedAmount / efficiencyModifier, world.field_9229);
                class_1799 currentRemainder = currentStack.getRecipeRemainder();
                currentStack.method_7934(reducedAmountAfterMod);
                if (currentRemainder.method_7960()) continue block0;
                currentRemainder = currentRemainder.method_7972();
                currentRemainder.method_7939(reducedAmountAfterMod);
                InventoryHelper.smartAddToInventory(currentRemainder, fusionShrineBlockEntity, null);
                continue block0;
            }
        }
    }

    protected void spawnCraftingResultAndXP(@NotNull class_1937 world, @NotNull FusionShrineBlockEntity fusionShrineBlockEntity, @NotNull class_1799 stack, int recipeCount) {
        int resultAmountBeforeMod = recipeCount * stack.method_7947();
        double yieldModifier = this.areYieldAndEfficiencyUpgradesDisabled() ? 1.0 : (double)fusionShrineBlockEntity.getUpgradeHolder().getEffectiveValue(Upgradeable.UpgradeType.YIELD);
        int resultAmountAfterMod = Support.getIntFromDecimalWithChance((double)resultAmountBeforeMod * yieldModifier, world.field_9229);
        int intExperience = Support.getIntFromDecimalWithChance((float)recipeCount * this.experience, world.field_9229);
        MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(world, fusionShrineBlockEntity.method_11016().method_10086(2), stack, resultAmountAfterMod, MultiblockCrafter.RECIPE_STACK_VELOCITY);
        if (this.experience > 0.0f) {
            MultiblockCrafter.spawnExperience(world, fusionShrineBlockEntity.method_11016(), intExperience);
        }
        fusionShrineBlockEntity.grantPlayerFusionCraftingAdvancement(stack, intExperience);
    }

    public boolean shouldPlayCraftingFinishedEffects() {
        return this.playCraftingFinishedEffects;
    }

    public static class Serializer
    implements class_1865<FusionShrineRecipe> {
        public static final MapCodec<FusionShrineRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)class_2960.field_25139.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)IngredientStack.Serializer.CODEC.listOf(0, 7).fieldOf("ingredients").forGetter(recipe -> recipe.craftingInputs), (App)FluidIngredient.CODEC.optionalFieldOf("fluid", (Object)FluidIngredient.EMPTY).forGetter(recipe -> recipe.fluid), (App)class_1799.field_24671.optionalFieldOf("result", (Object)class_1799.field_8037).forGetter(recipe -> recipe.output), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.experience)), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(recipe -> recipe.craftingTime), (App)Codec.BOOL.optionalFieldOf("disable_yield_upgrades", (Object)false).forGetter(recipe -> recipe.noBenefitsFromYieldAndEfficiencyUpgrades), (App)Codec.BOOL.optionalFieldOf("play_crafting_finished_effects", (Object)true).forGetter(recipe -> recipe.playCraftingFinishedEffects), (App)Codec.BOOL.optionalFieldOf("copy_components", (Object)false).forGetter(recipe -> recipe.copyComponents), (App)CodecHelper.singleOrList(WorldConditionsPredicate.CODEC).optionalFieldOf("world_conditions", List.of()).forGetter(recipe -> recipe.worldConditionsPredicates), (App)FusionShrineRecipeWorldEffect.CODEC.fieldOf("start_crafting_effect").forGetter(recipe -> recipe.startWorldEffect), (App)FusionShrineRecipeWorldEffect.CODEC.listOf().optionalFieldOf("during_crafting_effects", List.of()).forGetter(recipe -> recipe.duringWorldEffects), (App)FusionShrineRecipeWorldEffect.CODEC.fieldOf("finish_crafting_effect").forGetter(recipe -> recipe.finishWorldEffect), (App)class_8824.field_46597.optionalFieldOf("description", (Object)class_2561.method_43473()).forGetter(recipe -> recipe.description)).apply((Applicative)i, FusionShrineRecipe::new));
        public static final class_9139<class_9129, FusionShrineRecipe> PACKET_CODEC = PacketCodecHelper.tuple(class_9135.field_48554, recipe -> recipe.group, class_9135.field_48547, recipe -> recipe.secret, class_9135.method_56382((class_9139)class_2960.field_48267), recipe -> recipe.requiredAdvancementIdentifier, IngredientStack.Serializer.PACKET_CODEC.method_56433(class_9135.method_58000((int)7)), recipe -> recipe.craftingInputs, FluidIngredient.PACKET_CODEC, recipe -> recipe.fluid, class_1799.field_49268, recipe -> recipe.output, class_9135.field_48552, recipe -> Float.valueOf(recipe.experience), class_9135.field_48550, recipe -> recipe.craftingTime, class_9135.field_48547, recipe -> recipe.noBenefitsFromYieldAndEfficiencyUpgrades, class_9135.field_48547, recipe -> recipe.playCraftingFinishedEffects, class_9135.field_48547, recipe -> recipe.copyComponents, WorldConditionsPredicate.PACKET_CODEC.method_56433(class_9135.method_56363()), recipe -> recipe.worldConditionsPredicates, FusionShrineRecipeWorldEffect.PACKET_CODEC, recipe -> recipe.startWorldEffect, FusionShrineRecipeWorldEffect.PACKET_CODEC.method_56433(class_9135.method_56363()), recipe -> recipe.duringWorldEffects, FusionShrineRecipeWorldEffect.PACKET_CODEC, recipe -> recipe.finishWorldEffect, class_8824.field_49668, recipe -> recipe.description, FusionShrineRecipe::new);

        public MapCodec<FusionShrineRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, FusionShrineRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}

